/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.settings.elements;

import net.labymod.ingamegui.Module;
import net.labymod.ingamegui.enums.EnumDisplayType;
import net.labymod.main.LabyMod;
import net.labymod.settings.elements.BooleanElement;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;

public class CategoryModuleEditorElement
extends SettingsElement {
    private ControlElement.IconData iconData;

    public CategoryModuleEditorElement(String displayName, ControlElement.IconData iconData) {
        super(displayName, null);
        this.iconData = iconData;
    }

    @Override
    public void init() {
    }

    @Override
    public void draw(int x, int y, int maxX, int maxY, int mouseX, int mouseY) {
        super.draw(x, y, maxX, maxY, mouseX, mouseY);
        int absoluteY = y + 7;
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        draw.drawRectangle(x, y, maxX, maxY, ModColor.toRGB(200, 200, 200, this.mouseOver ? 50 : 30));
        int imageSize = maxY - y;
        if (this.iconData.hasTextureIcon()) {
            ave.A().P().a(this.iconData.getTextureIcon());
            LabyMod.getInstance().getDrawUtils().drawTexture(x + 2, y + 2, 256.0, 256.0, 18.0, 18.0);
        } else if (this.iconData.hasMaterialIcon()) {
            LabyMod.getInstance().getDrawUtils().drawItem(this.iconData.getMaterialIcon().createItemStack(), x + 3, y + 3, null);
        }
        draw.drawString(this.getDisplayName(), x + imageSize + 5, absoluteY);
        int totalSubCount = 0;
        int enabledCount = 0;
        for (SettingsElement element : this.getSubSettings().getElements()) {
            Module module;
            boolean isCurrentTab = false;
            if (element instanceof ControlElement && (module = ((ControlElement)element).getModule()) != null) {
                for (EnumDisplayType type : module.getDisplayTypes()) {
                    if (type != Module.getLastDrawnDisplayType()) continue;
                    isCurrentTab = true;
                }
            }
            if (element instanceof BooleanElement && ((BooleanElement)element).getCurrentValue()) {
                ++enabledCount;
            }
            if (!isCurrentTab) continue;
            ++totalSubCount;
        }
        draw.drawRightString(enabledCount + ModColor.cl("7") + "/" + ModColor.cl("f") + totalSubCount, maxX - 5, absoluteY);
    }

    public ControlElement.IconData getIconData() {
        return this.iconData;
    }

    @Override
    public int getEntryHeight() {
        return 22;
    }

    @Override
    public void drawDescription(int x, int y, int screenWidth) {
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
    }

    @Override
    public void mouseRelease(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void unfocus(int mouseX, int mouseY, int mouseButton) {
    }
}

