/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.settings;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.DropDownMenu;
import net.labymod.gui.elements.ModTextField;
import net.labymod.gui.elements.Scrollbar;
import net.labymod.gui.elements.Tabs;
import net.labymod.ingamegui.Module;
import net.labymod.ingamegui.ModuleCategory;
import net.labymod.ingamegui.ModuleCategoryRegistry;
import net.labymod.ingamegui.ModuleConfig;
import net.labymod.ingamegui.ModuleGui;
import net.labymod.ingamegui.enums.EnumDisplayType;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.main.lang.LanguageManager;
import net.labymod.settings.DefaultElementsCreator;
import net.labymod.settings.PreviewRenderer;
import net.labymod.settings.elements.BooleanElement;
import net.labymod.settings.elements.CategoryModuleEditorElement;
import net.labymod.settings.elements.ColorPickerCheckBoxBulkElement;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.DropDownElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.settings.elements.SliderElement;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.labymod.utils.ModUtils;
import net.labymod.utils.manager.TooltipHelper;
import org.lwjgl.input.Keyboard;

public class LabyModModuleEditorGui
extends axu {
    private static EnumDisplayType selectedTab = EnumDisplayType.INGAME;
    private static final ModuleGui moduleGui = new ModuleGui(true, true, selectedTab);
    public static String selectedProfile = null;
    public static final String GLOBAL_PROFILE = LanguageManager.translate("global_profile");
    public static final String SINGLEPLAYER_PROFILE = LanguageManager.translate("singleplayer_profile");
    private axu lastScreen;
    private boolean mouseClickSplitScreen = false;
    private Scrollbar scrollbar;
    private SettingsElement mouseOverElement;
    private BooleanElement masterElement;
    private List<SettingsElement> path = new ArrayList<SettingsElement>();
    private avs buttonGoBack;
    private ModTextField textFieldSearch;
    private String searchedString = "";
    private ControlElement selectedControlElement;
    private long lightUpSelectedElement = 0L;
    private EnumDisplayType hoveredTab = null;
    private DropDownMenu<EnumModuleEditorScale> scalingDropdown;
    private DropDownMenu<String> profilesDropdown;
    private boolean hoverResetButton = false;
    private Consumer<Module> moduleDoubleClickModuleListener = new Consumer<Module>(){

        @Override
        public void accept(Module accepted) {
            BooleanElement element = accepted.getBooleanElement();
            if (element.hasSubList() && element.getButtonAdvanced().l) {
                element.getButtonAdvanced().a(ave.A().W());
                LabyModModuleEditorGui.this.path.clear();
                if (selectedTab == EnumDisplayType.INGAME) {
                    if (element.getModule() != null && element.getModule().getCategory() != null && element.getModule().getCategory().getCategoryElement() != null) {
                        LabyModModuleEditorGui.this.path.add(element.getModule().getCategory().getCategoryElement());
                    } else {
                        LabyModModuleEditorGui.this.path.add(element);
                    }
                }
                moduleGui.setFocusedModule(element.getModule());
                LabyModModuleEditorGui.this.selectedControlElement = element;
                LabyModModuleEditorGui.this.lightUpSelectedElement = System.currentTimeMillis();
                LabyModModuleEditorGui.this.initList(true);
                LabyModModuleEditorGui.this.updateScrollbarValues(4);
                int index = -1;
                List foundModules = LabyModModuleEditorGui.this.getFoundModules();
                for (SettingsElement settingsElement : foundModules) {
                    ++index;
                    if (!settingsElement.equals(element)) continue;
                    LabyModModuleEditorGui.this.scrollbar.scrollTo(index);
                    break;
                }
            }
        }
    };
    private Consumer<Module> moduleClickModuleListener = new Consumer<Module>(){

        @Override
        public void accept(Module module) {
            if (module == null) {
                return;
            }
            BooleanElement element = module.getBooleanElement();
            if (element.hasSubList() && element.getButtonAdvanced().l) {
                moduleGui.setFocusedModule(element.getModule());
                if (LabyModModuleEditorGui.this.masterElement != null && LabyModModuleEditorGui.this.masterElement.equals(LabyModModuleEditorGui.this.getCurrentSelectedSubList())) {
                    return;
                }
                LabyModModuleEditorGui.this.selectedControlElement = element;
                LabyModModuleEditorGui.this.initList(false);
            }
        }
    };

    public LabyModModuleEditorGui() {
        this(null);
    }

    public LabyModModuleEditorGui(axu lastScreen) {
        this.lastScreen = lastScreen;
        if (LabyMod.getSettings().moduleEditorZoom == -1.0) {
            LabyMod.getSettings().moduleEditorZoom = 33.333333333333336;
        }
        Module.setLastDrawnDisplayType(selectedTab);
        this.scrollbar = new Scrollbar(24);
        this.masterElement = new BooleanElement("LabyMod GUI", new ControlElement.IconData(ModTextures.LOGO_LABYMOD_LOGO), new Consumer<Boolean>(){

            @Override
            public void accept(Boolean accepted) {
                ModuleConfig.getConfig().setModulesEnabled(accepted);
            }
        }, ModuleConfig.getConfig().isModulesEnabled());
        DefaultElementsCreator.createAlignment(null, true, this.masterElement.getSubSettings().getElements());
        DefaultElementsCreator.createFormatting(null, true, this.masterElement.getSubSettings().getElements());
        DefaultElementsCreator.createColorPicker(null, true, this.masterElement.getSubSettings().getElements());
        DefaultElementsCreator.createDurability(null, true, this.masterElement.getSubSettings().getElements());
        DefaultElementsCreator.createKeyVisible(null, true, this.masterElement.getSubSettings().getElements());
        DefaultElementsCreator.createBackgroundVisible(null, true, this.masterElement.getSubSettings().getElements());
        DefaultElementsCreator.createPadding(null, true, this.masterElement.getSubSettings().getElements());
        this.masterElement.getSubSettings().getElements().add(new BooleanElement(LanguageManager.translate("grid_switch"), new ControlElement.IconData(ModTextures.SETTINGS_DEFAULT_GRID_MOVEMENT), new Consumer<Boolean>(){

            @Override
            public void accept(Boolean accepted) {
                ModuleConfig.getConfig().setGridEnabled(accepted);
            }
        }, ModuleConfig.getConfig().isGridEnabled()));
        this.masterElement.getSubSettings().getElements().add(new BooleanElement(LanguageManager.translate("item_gravity"), new ControlElement.IconData(ModTextures.SETTINGS_DEFAULT_ITEM_GRAVITY), new Consumer<Boolean>(){

            @Override
            public void accept(Boolean accepted) {
                ModuleConfig.getConfig().setItemSlotGravity(accepted);
            }
        }, ModuleConfig.getConfig().isItemSlotGravity()));
        this.masterElement.getSubSettings().getElements().add(new SliderElement(LanguageManager.translate("gui_scale"), new ControlElement.IconData(ModTextures.SETTINGS_DEFAULT_GUI_SCALING), ModuleConfig.getConfig().getGuiScale()).setRange(50, 150).setSteps(5).addCallback(new Consumer<Integer>(){

            @Override
            public void accept(Integer accepted) {
                ModuleConfig.getConfig().setGuiScale(accepted);
            }
        }));
    }

    public void m() {
        ModuleConfig.getConfigManager().save();
        PreviewRenderer.getInstance().kill();
        Keyboard.enableRepeatEvents((boolean)false);
        moduleGui.m();
        Module.setCurrentModuleGui(null);
    }

    public void b() {
        Keyboard.enableRepeatEvents((boolean)true);
        PreviewRenderer.getInstance().init(LabyModModuleEditorGui.class);
        Module.setCurrentModuleGui(moduleGui);
        moduleGui.b();
        this.initList(true);
        Tabs.initGui(this);
    }

    private void initList(boolean scrollUp) {
        this.n.clear();
        if (!moduleGui.getClickModuleListeners().contains(this.moduleClickModuleListener)) {
            moduleGui.getClickModuleListeners().add(this.moduleClickModuleListener);
        }
        if (!moduleGui.getDoubleClickModuleListeners().contains(this.moduleDoubleClickModuleListener)) {
            moduleGui.getDoubleClickModuleListeners().add(this.moduleDoubleClickModuleListener);
        }
        this.scrollbar.setPosition(LabyMod.getSettings().moduleEditorSplitX - 8, 0, LabyMod.getSettings().moduleEditorSplitX - 4, this.m - 31);
        this.scrollbar.setSpeed(10);
        if (scrollUp) {
            this.scrollbar.setScrollY(0.0);
        }
        this.updateScrollbarValues(4);
        this.scrollbar.init();
        boolean displayBackButton = this.path.size() != 0;
        this.textFieldSearch = new ModTextField(0, LabyModCore.getMinecraft().getFontRenderer(), displayBackButton ? 60 : 6, 0, LabyMod.getSettings().moduleEditorSplitX - (displayBackButton ? 69 : 12), 14);
        this.textFieldSearch.setText(this.searchedString);
        if (!displayBackButton) {
            this.textFieldSearch.setFocused(true);
        }
        this.textFieldSearch.setCursorPositionEnd();
        this.textFieldSearch.setPlaceHolder(LanguageManager.translate("search_textbox_placeholder"));
        if (this.lastScreen != null) {
            this.n.add(new avs(5, 5, this.m - 25, LabyMod.getSettings().moduleEditorSplitX - 10, 20, LanguageManager.translate("button_done")));
        }
        this.scalingDropdown = new DropDownMenu<EnumModuleEditorScale>("", this.l - 75, this.m - 12 - 5, 70, 12).fill(EnumModuleEditorScale.values());
        this.scalingDropdown.setSelected(EnumModuleEditorScale.getByZoom(LabyMod.getSettings().moduleEditorZoom));
        this.scalingDropdown.setMaxY(this.m);
        this.scalingDropdown.setEntryDrawer(new DropDownMenu.DropDownEntryDrawer(){

            @Override
            public void draw(Object object, int x, int y, String trimmedEntry) {
                LabyMod.getInstance().getDrawUtils().drawString(((EnumModuleEditorScale)((Object)object)).getDisplayName(), x, y);
            }
        });
        this.profilesDropdown = new DropDownMenu("", this.lastScreen == null ? 5 : LabyMod.getSettings().moduleEditorSplitX + 5, this.m - 12 - 5, 150, 12);
        this.profilesDropdown.addOption(GLOBAL_PROFILE);
        String currentServer = null;
        if (ave.A().D() != null) {
            currentServer = ModUtils.getProfileNameByIp(ave.A().D().b);
            this.profilesDropdown.addOption(currentServer);
        }
        if (ave.A().F()) {
            this.profilesDropdown.addOption(SINGLEPLAYER_PROFILE);
        }
        for (File file : ModuleConfig.listProfileFiles()) {
            String profileName = file.getName().replace(".json", "");
            if (profileName.equals("singleplayer") || currentServer != null && profileName.equals(currentServer)) continue;
            this.profilesDropdown.addOption(profileName);
        }
        this.profilesDropdown.setSelected(selectedProfile == null ? GLOBAL_PROFILE : (selectedProfile.equals("singleplayer") ? SINGLEPLAYER_PROFILE : selectedProfile));
        this.profilesDropdown.setMaxY(this.m);
        this.profilesDropdown.setEntryDrawer(new DropDownMenu.DropDownEntryDrawer(){

            @Override
            public void draw(Object object, int x, int y, String trimmedEntry) {
                File file = ModuleConfig.getFile(object.equals(GLOBAL_PROFILE) ? null : object.toString());
                String prefix = file.exists() ? "" : ModColor.cl('e') + "+ " + ModColor.cl('f');
                LabyMod.getInstance().getDrawUtils().drawString(prefix + object.toString(), x, y);
            }
        });
        this.buttonGoBack = new avs(7, 5, 47, 20, 20, "<");
        this.n.add(this.buttonGoBack);
        this.checkSplitscreenBorder();
        super.b();
        if (this.path.size() != 0) {
            for (SettingsElement module : this.getCurrentSelectedSubList().getSubSettings().getElements()) {
                module.init();
            }
        }
    }

    protected void a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.j.a(this.lastScreen);
            return;
        }
        if (this.textFieldSearch.textboxKeyTyped(typedChar, keyCode)) {
            this.searchedString = this.textFieldSearch.getText();
            this.scrollbar.update(this.getFoundModules().size());
        }
        moduleGui.a(typedChar, keyCode);
        if (this.selectedControlElement != null) {
            this.selectedControlElement.keyTyped(typedChar, keyCode);
        }
    }

    protected void a(avs button) throws IOException {
        if (button.k == 5) {
            this.j.a(this.lastScreen);
        }
        if (button.k == this.buttonGoBack.k) {
            this.searchedString = "";
            if (this.path.size() != 0) {
                this.path.remove(this.path.size() - 1);
            }
            moduleGui.setFocusedModule(null);
            this.b();
        }
        super.a(button);
    }

    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        ControlElement element;
        if (Tabs.mouseClicked(this)) {
            return;
        }
        if (this.scalingDropdown.onClick(mouseX, mouseY, mouseButton) && this.scalingDropdown.getSelected() != null && !this.scalingDropdown.isOpen()) {
            double scaling;
            LabyMod.getSettings().moduleEditorZoom = scaling = (double)this.scalingDropdown.getSelected().getScaling() / 3.0 * 100.0;
            ave.A().a((axu)new LabyModModuleEditorGui(this.lastScreen));
            return;
        }
        if (this.profilesDropdown.onClick(mouseX, mouseY, mouseButton) && this.profilesDropdown.getSelected() != null && !this.profilesDropdown.isOpen()) {
            selectedProfile = this.profilesDropdown.getSelected();
            if (selectedProfile != null && selectedProfile.equals(GLOBAL_PROFILE)) {
                selectedProfile = null;
            }
            ModuleConfig.switchProfile(selectedProfile, true);
            ave.A().a((axu)new LabyModModuleEditorGui(this.lastScreen));
            return;
        }
        if (this.hoverResetButton) {
            ave.A().a((axu)new awy(new awx(){

                public void a(boolean flag, int id) {
                    if (!flag) {
                        ModuleConfig.deleteProfile(selectedProfile);
                    }
                    ave.A().a((axu)new LabyModModuleEditorGui(LabyModModuleEditorGui.this.lastScreen));
                }
            }, LanguageManager.translate(selectedProfile == null ? LanguageManager.translate("reset_modules_global") : LanguageManager.translate("reset_modules_profile", selectedProfile)), LanguageManager.translate("reset_modules_undone"), LanguageManager.translate("button_no"), LanguageManager.translate("button_yes"), 0));
        }
        if (mouseY > this.m - 30) {
            super.a(mouseX, mouseY, mouseButton);
            return;
        }
        List<SettingsElement> foundModules = this.getFoundModules();
        for (SettingsElement element2 : foundModules) {
            if (element2 instanceof DropDownElement && ((DropDownElement)element2).onClickDropDown(mouseX, mouseY, mouseButton)) {
                return;
            }
            if (!(element2 instanceof ColorPickerCheckBoxBulkElement) || !((ColorPickerCheckBoxBulkElement)element2).onClickBulkEntry(mouseX, mouseY, mouseButton)) continue;
            return;
        }
        this.textFieldSearch.mouseClicked(mouseX, mouseY, mouseButton);
        this.unfocusSubListTextfields(mouseX, mouseY, mouseButton);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.CLICKED);
        if (this.mouseOverElement != null) {
            boolean flag = true;
            if (this.mouseOverElement instanceof ControlElement) {
                SettingsElement element2;
                element2 = (ControlElement)this.mouseOverElement;
                boolean mouseOver = mouseX < LabyMod.getSettings().moduleEditorSplitX - ((ControlElement)element2).getObjectWidth() - ((ControlElement)element2).getSubListButtonWidth() - (this.scrollbar.isHidden() ? 5 : 10) - 2;
                Module module = ((ControlElement)element2).getModule();
                if (module != null && mouseOver) {
                    this.selectedControlElement = element2;
                    moduleGui.setFocusedModule(module);
                    this.textFieldSearch.setFocused(false);
                    this.unfocusSubListTextfields(mouseX, mouseY, mouseButton);
                    flag = false;
                }
            }
            if (this.mouseOverElement instanceof CategoryModuleEditorElement) {
                this.path.add(this.mouseOverElement);
                moduleGui.setFocusedModule(null);
            }
            if (flag) {
                this.mouseOverElement.mouseClicked(mouseX, mouseY, mouseButton);
            }
            if (this.mouseOverElement instanceof ControlElement) {
                this.selectedControlElement = (ControlElement)this.mouseOverElement;
            }
            this.updateScrollbarValues(4);
        }
        if (!this.mouseClickSplitScreen) {
            moduleGui.a(mouseX, mouseY, mouseButton);
        }
        if (this.mouseOverElement != null && this.mouseOverElement instanceof ControlElement && (element = (ControlElement)this.mouseOverElement).hasSubList() && element.getButtonAdvanced().a() && element.getButtonAdvanced().l) {
            element.getButtonAdvanced().a(this.j.W());
            this.path.add(element);
            moduleGui.setFocusedModule(element.getModule());
            this.b();
        }
        if (mouseButton == 0 && mouseX > LabyMod.getSettings().moduleEditorSplitX - 5 && mouseX < LabyMod.getSettings().moduleEditorSplitX + 2 && mouseY > 45 && mouseY < this.m - 30) {
            this.mouseClickSplitScreen = true;
        }
        if (this.hoveredTab != null && selectedTab != this.hoveredTab) {
            selectedTab = this.hoveredTab;
            for (Module module : Module.getModules()) {
                module.setBooleanElement(null);
            }
            for (ModuleCategory moduleCategory : ModuleCategoryRegistry.getCategories()) {
                moduleCategory.setCategoryElement(null);
            }
            Module.setLastDrawnDisplayType(selectedTab);
            moduleGui.setDisplayType(selectedTab);
            this.path.clear();
            this.b();
        }
        super.a(mouseX, mouseY, mouseButton);
    }

    private void unfocusSubListTextfields(int mouseX, int mouseY, int mouseButton) {
        if (this.path.size() != 0) {
            for (SettingsElement moduleElement : this.getCurrentSelectedSubList().getSubSettings().getElements()) {
                moduleElement.unfocus(mouseX, mouseY, mouseButton);
            }
        }
    }

    private SettingsElement getCurrentSelectedSubList() {
        return this.path.size() == 0 ? null : this.path.get(this.path.size() - 1);
    }

    protected void b(int mouseX, int mouseY, int mouseButton) {
        super.b(mouseX, mouseY, mouseButton);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.RELEASED);
        if (!this.mouseClickSplitScreen) {
            moduleGui.b(mouseX, mouseY, mouseButton);
        }
        if (mouseButton == 0) {
            this.mouseClickSplitScreen = false;
        }
        if (this.mouseOverElement != null) {
            this.mouseOverElement.mouseRelease(mouseX, mouseY, mouseButton);
        }
    }

    protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.DRAGGING);
        if (!this.mouseClickSplitScreen) {
            moduleGui.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }
        if (this.mouseClickSplitScreen) {
            LabyMod.getSettings().moduleEditorSplitX = mouseX;
            this.checkSplitscreenBorder();
            this.b();
            this.textFieldSearch.setFocused(false);
        }
        if (this.mouseOverElement != null) {
            this.mouseOverElement.mouseClickMove(mouseX, mouseY, clickedMouseButton);
        }
    }

    private void checkSplitscreenBorder() {
        if (LabyMod.getSettings().moduleEditorSplitX < 180) {
            LabyMod.getSettings().moduleEditorSplitX = 180;
        }
        if (LabyMod.getSettings().moduleEditorSplitX > 300) {
            LabyMod.getSettings().moduleEditorSplitX = 300;
        }
    }

    public void k() throws IOException {
        super.k();
        this.scrollbar.mouseInput();
        if (!this.mouseClickSplitScreen) {
            moduleGui.k();
        }
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        boolean hoverSplitscreen;
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        avr scaled = LabyMod.getInstance().getDrawUtils().getScaledResolution();
        double rescale = (double)scaled.e() / LabyMod.getInstance().getDrawUtils().getCustomScaling();
        ave.A().b().a(true);
        int left = LabyMod.getSettings().moduleEditorSplitX - 1;
        int top = 38 + (int)(20.0 * rescale);
        int right = this.l - 1;
        int bottom = this.m - 31;
        int scrollBarListY = top - 26;
        LabyMod.getInstance().getDrawUtils().drawDimmedOverlayBackground(0, scrollBarListY, this.l, this.m - 30);
        this.renderPreview(selectedTab, left, top + 1, right, bottom - 1, mouseX, mouseY);
        Module.draw(left, top, right, bottom, selectedTab, selectedTab == EnumDisplayType.INGAME);
        moduleGui.a(mouseX, mouseY, partialTicks);
        List<SettingsElement> foundModules = this.getFoundModules();
        Collections.reverse(foundModules);
        double totalHeight = 0.0;
        for (SettingsElement element : foundModules) {
            totalHeight += (double)(element.getEntryHeight() + 1);
        }
        double moduleListStartY = (double)(scrollBarListY + 28 + (this.path.size() == 0 ? 20 : 0)) + this.scrollbar.getScrollY();
        this.updateScrollbarValues(scrollBarListY);
        this.scrollbar.draw(mouseX, mouseY);
        this.renderModuleList(foundModules, moduleListStartY, totalHeight, mouseX, mouseY);
        draw.drawOverlayBackground(0, top);
        draw.drawOverlayBackground(bottom, this.m);
        draw.drawOverlayBackground(0, 0, LabyMod.getSettings().moduleEditorSplitX - 4, scrollBarListY + 25);
        draw.drawGradientShadowTop(top, 0.0, LabyMod.getSettings().moduleEditorSplitX - 1);
        draw.drawGradientShadowBottom(bottom, 0.0, LabyMod.getSettings().moduleEditorSplitX - 1);
        boolean bl = hoverSplitscreen = mouseX > LabyMod.getSettings().moduleEditorSplitX - 5 && mouseX < LabyMod.getSettings().moduleEditorSplitX + 1 && mouseY > 45 && mouseY < this.m - 30;
        if (hoverSplitscreen || this.mouseClickSplitScreen) {
            draw.drawRectangle(LabyMod.getSettings().moduleEditorSplitX - 2, top, LabyMod.getSettings().moduleEditorSplitX - 1, this.m - 31, Integer.MAX_VALUE);
            draw.drawCenteredString("|||", mouseX + 1, mouseY - 3);
        }
        if (draw.getWidth() > 400) {
            draw.drawRightString(LanguageManager.translate("labymod_gui_editor"), this.l - 10, top - 18);
        }
        if (this.path.size() != 0) {
            SettingsElement element = this.getCurrentSelectedSubList();
            int posY = scrollBarListY + 2;
            EnumDisplayType[] list = draw.listFormattedStringToWidth(element.getDisplayName(), LabyMod.getSettings().moduleEditorSplitX - 33 - 5 - 15, 3);
            int fontHeight = 16 - list.size() * 3;
            double listY = posY + 6;
            for (String string : list) {
                draw.drawString(string, 33.0, listY - (double)(list.size() * fontHeight / 2) + (double)(fontHeight / 2));
                listY += (double)fontHeight;
            }
            ControlElement.IconData masterIconData = null;
            if (element instanceof ControlElement) {
                ControlElement.IconData iconData = masterIconData = ((ControlElement)element).getModule() == null ? null : ((ControlElement)element).getModule().getIconData();
            }
            if (element instanceof CategoryModuleEditorElement) {
                masterIconData = ((CategoryModuleEditorElement)element).getIconData();
            }
            if (masterIconData != null) {
                if (masterIconData.hasTextureIcon()) {
                    ave.A().P().a(masterIconData.getTextureIcon());
                    LabyMod.getInstance().getDrawUtils().drawTexture(LabyMod.getSettings().moduleEditorSplitX - 22, posY + 3, 256.0, 256.0, 16.0, 16.0);
                } else if (masterIconData.hasMaterialIcon()) {
                    LabyMod.getInstance().getDrawUtils().drawItem(masterIconData.getMaterialIcon().createItemStack(), LabyMod.getSettings().moduleEditorSplitX - 22, posY + 3, null);
                }
            }
            LabyModCore.getMinecraft().setButtonYPosition(this.buttonGoBack, posY);
        } else if (this.path.size() == 0) {
            this.textFieldSearch.yPosition = top + 4;
            this.textFieldSearch.drawTextBox();
            int masterY = top - 26;
            this.masterElement.setHoverable(true).setSelected(this.selectedControlElement == null).draw(5, masterY, LabyMod.getSettings().moduleEditorSplitX - 4, masterY + 22, mouseX, mouseY);
        }
        this.buttonGoBack.m = this.path.size() != 0;
        int tabX = left + 3;
        int tabY = top - 12;
        this.hoveredTab = null;
        for (EnumDisplayType type : EnumDisplayType.values()) {
            int animate;
            boolean hovered;
            int tabLen = draw.getStringWidth(type.getDisplayName()) + 6;
            int n = 12;
            if (mouseX > tabX && mouseX < tabX + tabLen && mouseY > tabY && mouseY < tabY + n) {
                this.hoveredTab = type;
            }
            boolean selected = selectedTab == type;
            boolean bl2 = hovered = this.hoveredTab == type;
            int n2 = selected || hovered ? (selected ? 2 : 1) : (animate = 0);
            if (selected) {
                tabLen += 6;
            }
            int tabMid = tabX + tabLen / 2;
            draw.drawRectangle(tabX, tabY - animate * 2, tabX + tabLen, tabY + n, ModColor.toRGB(5, 5, 5, 140));
            draw.drawRectBorder(tabX, tabY - animate * 2, tabX + tabLen, tabY + n, ModColor.toRGB(5, 5, 5, 140), 1.0);
            if (selected) {
                draw.drawRectangle(tabX + 1, tabY - animate * 2 + 1, tabX + tabLen - 1, tabY + n, ModColor.toRGB(55, 55, 55, 65));
            }
            draw.drawCenteredString((selected || hovered ? ModColor.cl("f") : ModColor.cl("8")) + type.getDisplayName(), tabMid, tabY + 2 - animate);
            tabX += tabLen + 1;
        }
        draw.drawGradientShadowBottom(top, 0.0, this.l);
        draw.drawGradientShadowTop(bottom, 0.0, this.l);
        draw.drawString(LanguageManager.translate("preview_zoom"), this.l - 75, this.m - 26, 0.75);
        this.scalingDropdown.draw(mouseX, mouseY);
        draw.drawString(LanguageManager.translate("module_profiles"), this.lastScreen == null ? 5.0 : (double)(LabyMod.getSettings().moduleEditorSplitX + 5), this.m - 26, 0.75);
        this.profilesDropdown.draw(mouseX, mouseY);
        int resetX = (this.lastScreen == null ? 5 : LabyMod.getSettings().moduleEditorSplitX + 5) + this.profilesDropdown.getWidth() + 5;
        this.hoverResetButton = mouseX > resetX && mouseX < resetX + 16 && mouseY > this.m - 19 && mouseY < this.m - 19 + 16;
        draw.bindTexture(ModTextures.BUTTON_RESET);
        draw.drawTexture(resetX, this.m - 19, 0.0, this.hoverResetButton ? 127.5 : 0.0, 255.0, 127.5, 16.0, 16.0);
        if (this.hoverResetButton) {
            TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, selectedProfile == null ? LanguageManager.translate("reset_modules_description") : LanguageManager.translate("delete_profile_description", selectedProfile));
        }
        if (this.profilesDropdown.isMouseOver(mouseX, mouseY)) {
            TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, LanguageManager.translate("module_profiles_description"));
        }
        this.renderDescriptions(foundModules, moduleListStartY, totalHeight, mouseX, mouseY);
        super.a(mouseX, mouseY, partialTicks);
        Tabs.drawScreen(this, mouseX, mouseY);
    }

    private void updateScrollbarValues(int scrollBarListY) {
        List<SettingsElement> foundModules = this.getFoundModules();
        double totalHeight = 0.0;
        for (SettingsElement element : foundModules) {
            totalHeight += (double)(element.getEntryHeight() + 1);
        }
        this.scrollbar.setEntryHeight(totalHeight / (double)foundModules.size());
        this.scrollbar.update(foundModules.size());
        this.scrollbar.setPosTop(scrollBarListY + 25 + 2 + (this.path.size() == 0 ? 24 : 0));
        this.scrollbar.setSpeed((int)this.scrollbar.getEntryHeight() / 2);
    }

    private void renderModuleList(List<SettingsElement> foundModules, double listY, double totalHeight, int mouseX, int mouseY) {
        SettingsElement mouseOverElement = null;
        for (int zLevel = 0; zLevel < 2; ++zLevel) {
            int x = 5;
            double y = listY + totalHeight;
            int maxX = LabyMod.getSettings().moduleEditorSplitX - (this.scrollbar.isHidden() ? 5 : 10);
            for (SettingsElement element : foundModules) {
                boolean inYRange;
                int nextSetting = element.getEntryHeight();
                y -= (double)(nextSetting + 1);
                boolean bl = inYRange = (double)mouseY > listY && mouseY < this.m - 30;
                if ((!(element instanceof DropDownElement) || element instanceof ColorPickerCheckBoxBulkElement) && zLevel == 0 || (element instanceof DropDownElement || element instanceof ColorPickerCheckBoxBulkElement) && zLevel == 1) {
                    if (element instanceof ControlElement) {
                        ControlElement controlElement = (ControlElement)element;
                        boolean hoverable = controlElement.isModule() && mouseX < LabyMod.getSettings().moduleEditorSplitX - controlElement.getObjectWidth() - controlElement.getSubListButtonWidth() - (this.scrollbar.isHidden() ? 5 : 10) - 2;
                        boolean selected = this.selectedControlElement != null && this.selectedControlElement == controlElement;
                        controlElement.setHoverable(hoverable && inYRange).setSelected(selected);
                        controlElement.draw(x, (int)y, maxX, (int)y + nextSetting, mouseX, mouseY);
                        if (this.selectedControlElement != null && this.selectedControlElement.equals(controlElement) && this.lightUpSelectedElement + 1000L > System.currentTimeMillis()) {
                            int alpha = (int)((System.currentTimeMillis() - this.lightUpSelectedElement) * -1L + 1000L) / 4;
                            LabyMod.getInstance().getDrawUtils().drawRectBorder(x, y, maxX, y + (double)nextSetting, ModColor.toRGB(200, 20, 20, alpha), 1.0);
                        }
                    }
                    if (element instanceof CategoryModuleEditorElement) {
                        CategoryModuleEditorElement categoryElement = (CategoryModuleEditorElement)element;
                        categoryElement.draw(x, (int)y, maxX, (int)y + nextSetting, mouseX, mouseY);
                    }
                }
                if (!element.isMouseOver() || !inYRange || zLevel != 1) continue;
                mouseOverElement = element;
            }
        }
        if (this.masterElement.isMouseOver() && this.path.size() == 0) {
            mouseOverElement = this.masterElement;
        }
        this.mouseOverElement = mouseOverElement;
    }

    private void renderDescriptions(List<SettingsElement> foundModules, double listY, double totalHeight, int mouseX, int mouseY) {
        for (SettingsElement element : foundModules) {
            if (!element.isMouseOver() || !((double)mouseY > listY) || !((double)mouseY < listY + totalHeight)) continue;
            element.drawDescription(mouseX, mouseY, this.l);
        }
    }

    public void e() {
        super.e();
        if (this.path.size() != 0) {
            for (SettingsElement module : this.getCurrentSelectedSubList().getSubSettings().getElements()) {
                module.updateScreen();
            }
        }
        this.textFieldSearch.updateCursorCounter();
    }

    private void renderPreview(EnumDisplayType displayType, int left, int top, int right, int bottom, int mouseX, int mouseY) {
        PreviewRenderer.getInstance().render(displayType, left, top, right, bottom, LabyMod.getInstance().getPartialTicks(), mouseX, mouseY);
    }

    /*
     * Unable to fully structure code
     */
    private List<SettingsElement> getFoundModules() {
        v0 = isMasterOpen = this.path.size() != 0 && this.path.get(0) == this.masterElement;
        if (this.textFieldSearch != null && this.textFieldSearch.getText().replaceAll(" ", "").isEmpty() == false ? this.path.size() >= 1 : this.path.size() >= 2) ** GOTO lbl-1000
        if (LabyModModuleEditorGui.selectedTab != EnumDisplayType.INGAME && this.path.size() != 0 && !isMasterOpen) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = isSubSettingOpen = false;
        }
        if (LabyModModuleEditorGui.selectedTab != EnumDisplayType.INGAME && !isMasterOpen && !isSubSettingOpen) {
            list = new ArrayList<SettingsElement>();
            for (Module module : Module.getModules()) {
                isCurrentTab = false;
                for (EnumDisplayType type : module.getDisplayTypes()) {
                    if (type != LabyModModuleEditorGui.selectedTab) continue;
                    isCurrentTab = true;
                }
                if (!isCurrentTab || !module.getBooleanElement().isVisible()) continue;
                list.add(module.getBooleanElement());
            }
            return list;
        }
        if (this.path.size() != 0) {
            list = new ArrayList<SettingsElement>();
            for (SettingsElement element : this.getCurrentSelectedSubList().getSubSettings().getElements()) {
                v2 = isCurrentTab = isMasterOpen != false || isSubSettingOpen != false;
                if (element instanceof ControlElement && (module = ((ControlElement)element).getModule()) != null) {
                    for (EnumDisplayType type : module.getDisplayTypes()) {
                        if (type != LabyModModuleEditorGui.selectedTab) continue;
                        isCurrentTab = true;
                    }
                }
                if (!isCurrentTab || !(element instanceof ControlElement) || !element.isVisible()) continue;
                list.add(element);
            }
            return list;
        }
        if (this.textFieldSearch == null) {
            return this.toElements(ModuleCategoryRegistry.getCategories());
        }
        searchValue = this.textFieldSearch.getText().toLowerCase();
        if (searchValue.replace(" ", "").isEmpty()) {
            return this.toElements(ModuleCategoryRegistry.getCategories());
        }
        list = new ArrayList<SettingsElement>();
        for (Module module : Module.getModules()) {
            if (!module.getControlName().toLowerCase().contains(searchValue) && !module.getDescription().toLowerCase().contains(searchValue) && !module.getCategory().getName().toLowerCase().contains(searchValue) && !searchValue.equals("*")) continue;
            isCurrentTab = isMasterOpen != false || isSubSettingOpen != false;
            for (EnumDisplayType type : module.getDisplayTypes()) {
                if (type != LabyModModuleEditorGui.selectedTab) continue;
                isCurrentTab = true;
            }
            if (!isCurrentTab || !module.getBooleanElement().isVisible()) continue;
            list.add(module.getBooleanElement());
        }
        return list;
    }

    private List<SettingsElement> toElements(List<ModuleCategory> moduleCategories) {
        ArrayList<SettingsElement> list = new ArrayList<SettingsElement>();
        for (ModuleCategory module : moduleCategories) {
            list.add(module.getCategoryElement());
        }
        return list;
    }

    public static EnumDisplayType getSelectedTab() {
        return selectedTab;
    }

    public axu getLastScreen() {
        return this.lastScreen;
    }

    public static enum EnumModuleEditorScale {
        SMALL(LanguageManager.translate("scaletype_small"), 1),
        NORMAL(LanguageManager.translate("scaletype_normal"), 2),
        LARGE(LanguageManager.translate("scaletype_large"), 3),
        AUTO(LanguageManager.translate("scaletype_auto"), 4);

        private String displayName;
        private int scaling;

        public static EnumModuleEditorScale getByScaling(int guiScale) {
            for (EnumModuleEditorScale emes : EnumModuleEditorScale.values()) {
                if (emes.getScaling() < guiScale) continue;
                return emes;
            }
            return NORMAL;
        }

        public static EnumModuleEditorScale getByZoom(double zoom) {
            double customScaleFactor = 1.0 + zoom * 0.03;
            for (EnumModuleEditorScale emes : EnumModuleEditorScale.values()) {
                if ((long)emes.getScaling() != Math.round(customScaleFactor) - 1L) continue;
                return emes;
            }
            return NORMAL;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getScaling() {
            return this.scaling;
        }

        private EnumModuleEditorScale(String displayName, int scaling) {
            this.displayName = displayName;
            this.scaling = scaling;
        }
    }
}

