/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.settings;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.labymod.addon.AddonLoader;
import net.labymod.addon.online.AddonInfoManager;
import net.labymod.addon.online.info.AddonInfo;
import net.labymod.addon.online.info.OnlineAddonInfo;
import net.labymod.api.LabyModAddon;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.CheckBox;
import net.labymod.gui.elements.ModTextField;
import net.labymod.gui.elements.Scrollbar;
import net.labymod.gui.elements.Tabs;
import net.labymod.ingamegui.Module;
import net.labymod.main.LabyMod;
import net.labymod.main.Source;
import net.labymod.main.lang.LanguageManager;
import net.labymod.settings.elements.AddonElement;
import net.labymod.settings.elements.ColorPickerCheckBoxBulkElement;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.DropDownElement;
import net.labymod.settings.elements.KeyElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import org.lwjgl.input.Keyboard;

public class LabyModAddonsGui
extends axu {
    private axu lastScreen;
    private Scrollbar scrollbar = new Scrollbar(1);
    private avs buttonDone;
    private avs buttonBack;
    private avs buttonWarningExitGame;
    private avs buttonWarningRestartLater;
    private ModTextField fieldSearch;
    private boolean displayRestartWarning = false;
    private AddonElement openedAddonSettings = null;
    private AddonElement mouseOverAddonEntry;
    private SettingsElement mouseOverElement;
    private List<SettingsElement> listedElementsStored = new ArrayList<SettingsElement>();
    private List<SettingsElement> tempElementsStored = new ArrayList<SettingsElement>();
    private ArrayList<SettingsElement> path = new ArrayList();
    private double preScrollPos = 0.0;
    private EnumSortingState selectedSortingState = EnumSortingState.TRENDING;
    private EnumSortingState hoveredSortingState = null;
    private List<AddonInfo> sortedAddonInfoList = AddonInfoManager.getInstance().getAddonInfoList();
    private int[] enabledFilter = null;

    public LabyModAddonsGui() {
        this(null);
    }

    public LabyModAddonsGui(axu lastScreen) {
        this.lastScreen = lastScreen;
        AddonInfoManager.getInstance().init();
        AddonInfoManager.getInstance().createElementsForAddons();
        if (!AddonLoader.getAddons().isEmpty()) {
            this.selectedSortingState = EnumSortingState.INSTALLED;
        }
        if (AddonInfoManager.getInstance().isLoaded()) {
            this.handleCheckBox(false, 0, 0, 0);
        }
    }

    public void b() {
        super.b();
        this.n.clear();
        this.doQuery();
        this.sortAddonInfoList();
        this.scrollbar.setPosition(this.l / 2 + 152, this.isInSubSettings() ? 50 : 80, this.l / 2 + 152 + 4, this.m - 15);
        this.scrollbar.setSpeed(20);
        this.scrollbar.init();
        if (this.lastScreen != null) {
            this.buttonDone = new avs(0, this.l / 2 + 50, this.m - 25, 100, 20, LanguageManager.translate("button_done"));
            this.n.add(this.buttonDone);
        }
        this.buttonBack = new avs(1, this.l / 2 - 100, 20, 22, 20, "<");
        this.n.add(this.buttonBack);
        this.buttonWarningRestartLater = new avs(2, this.l / 2 - 95, this.m / 2 + 20, 90, 20, LanguageManager.translate("button_restart_later"));
        this.n.add(this.buttonWarningRestartLater);
        this.buttonWarningExitGame = new avs(3, this.l / 2 + 5, this.m / 2 + 20, 90, 20, LanguageManager.translate("button_exit_game"));
        this.n.add(this.buttonWarningExitGame);
        this.fieldSearch = new ModTextField(0, LabyModCore.getMinecraft().getFontRenderer(), this.l / 2 - 150, 35, 200, 16);
        this.fieldSearch.setBlackBox(false);
        this.fieldSearch.setPlaceHolder(LanguageManager.translate("search_textbox_placeholder"));
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.isInSubSettings()) {
            for (SettingsElement settingsElement : this.listedElementsStored) {
                settingsElement.init();
            }
        }
        Tabs.initGui(this);
    }

    public void m() {
        for (LabyModAddon addon : AddonLoader.getAddons()) {
            addon.saveConfig();
        }
        super.m();
        Keyboard.enableRepeatEvents((boolean)false);
        if (LabyModAddonsGui.isRestartRequired() && !this.displayRestartWarning) {
            this.displayRestartWarning = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ave.A().a(new Runnable(){

                        @Override
                        public void run() {
                            if (!(ave.A().m instanceof LabyModAddonsGui)) {
                                LabyModAddonsGui gui = new LabyModAddonsGui(ave.A().m);
                                gui.displayRestartWarning = true;
                                ave.A().a((axu)gui);
                            }
                        }
                    });
                }
            }).start();
            return;
        }
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        draw.drawAutoDimmedBackground(this.scrollbar.getScrollY());
        this.drawElementList(mouseX, mouseY);
        if (!AddonInfoManager.getInstance().isLoaded() || AddonInfoManager.getInstance().getAddonInfoList().isEmpty()) {
            draw.drawCenteredString(LanguageManager.translate("button_no_addons_available", Source.ABOUT_MC_VERSION), this.l / 2, this.m / 2);
        }
        int top = this.isInSubSettings() ? 45 : 75;
        draw.drawOverlayBackground(0, top);
        draw.drawGradientShadowTop(top, 0.0, this.l);
        int bottom = this.lastScreen == null ? this.m - 10 : this.m - 30;
        draw.drawOverlayBackground(bottom, this.m);
        draw.drawGradientShadowBottom(bottom, 0.0, this.l);
        this.scrollbar.draw(mouseX, mouseY);
        if (this.buttonDone != null) {
            this.buttonDone.l = !this.displayRestartWarning;
        }
        this.buttonBack.m = this.openedAddonSettings != null;
        this.buttonBack.l = !this.displayRestartWarning;
        this.buttonWarningExitGame.m = this.displayRestartWarning;
        this.buttonWarningRestartLater.m = this.displayRestartWarning;
        if (AddonInfoManager.getInstance().isLoaded()) {
            if (!this.isInSubSettings()) {
                this.drawSortingTabs(mouseX, mouseY);
            } else {
                draw.drawString(this.openedAddonSettings.getAddonInfo().getName(), this.l / 2 - 100 + 30, 25.0);
                this.openedAddonSettings.drawIcon(this.l / 2 + 100 - 20, 20, 20, 20);
            }
        }
        if (!this.isInSubSettings() && AddonInfoManager.getInstance().isLoaded()) {
            this.drawCategoryFilterMenu(mouseX, mouseY);
        }
        super.a(mouseX, mouseY, partialTicks);
        if (!this.isInSubSettings()) {
            Tabs.drawScreen(this, mouseX, mouseY);
        }
        if (this.displayRestartWarning) {
            draw.drawIngameBackground();
            draw.drawRectangle(this.l / 2 - 100 - 2, this.m / 2 - 50 - 2, this.l / 2 + 100 + 2, this.m / 2 + 50 + 2, Integer.MIN_VALUE);
            draw.drawRectangle(this.l / 2 - 100, this.m / 2 - 50, this.l / 2 + 100, this.m / 2 + 50, ModColor.toRGB(20, 20, 20, 144));
            LabyModCore.getMinecraft().drawButton(this.buttonWarningRestartLater, mouseX, mouseY);
            LabyModCore.getMinecraft().drawButton(this.buttonWarningExitGame, mouseX, mouseY);
            draw.drawCenteredString(LanguageManager.translate("warning_title"), this.l / 2, this.m / 2 - 44);
            List<String> list = draw.listFormattedStringToWidth(LanguageManager.translate("warning_content"), 190);
            int lineY = 0;
            for (String line : list) {
                draw.drawCenteredString(ModColor.cl("4") + line, this.l / 2, this.m / 2 - 30 + lineY);
                lineY += 10;
            }
        }
        if (this.fieldSearch != null && !this.isInSubSettings()) {
            this.fieldSearch.drawTextBox();
        }
        if (this.openedAddonSettings != null) {
            this.openedAddonSettings.onRenderPreview(mouseX, mouseY, partialTicks);
        }
    }

    private void drawCategoryFilterMenu(int mouseX, int mouseY) {
        int x = this.l / 2 + 60;
        int y = 36;
        for (CheckBox checkBox : AddonInfoManager.getInstance().getCategorieCheckboxList()) {
            checkBox.setX(x);
            checkBox.setY(y);
            checkBox.drawCheckbox(mouseX, mouseY);
            x += 25;
        }
    }

    private void doQuery() {
        this.tempElementsStored.clear();
        if (this.openedAddonSettings != null) {
            if (this.path.isEmpty()) {
                this.tempElementsStored.addAll(this.openedAddonSettings.getSubSettings());
            } else {
                SettingsElement currentOpenElement = this.path.get(this.path.size() - 1);
                this.tempElementsStored.addAll(currentOpenElement.getSubSettings().getElements());
            }
        }
        this.listedElementsStored = this.tempElementsStored;
    }

    private void drawSortingTabs(int mouseX, int mouseY) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        int tabX = this.l / 2 - 150;
        int tabY = 63;
        this.hoveredSortingState = null;
        if (AddonInfoManager.getInstance().isLoaded()) {
            for (EnumSortingState sortingState : EnumSortingState.values()) {
                boolean selected = this.selectedSortingState == sortingState;
                int tabLen = draw.getStringWidth(sortingState.getDisplayName()) + 6 + (selected ? 6 : 0);
                String prefix = "";
                if (sortingState == EnumSortingState.INSTALLED) {
                    tabX = this.l / 2 + 150 - tabLen;
                    prefix = ModColor.cl(selected ? "6" : "8");
                }
                this.drawSingleTab(sortingState, prefix, tabX, tabY, tabLen, selected, mouseX, mouseY);
                tabX += tabLen + 1;
            }
        }
    }

    private void drawSingleTab(EnumSortingState sortingState, String prefix, int tabX, int tabY, int length, boolean selected, int mouseX, int mouseY) {
        boolean hovered;
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        int tabHeight = 12;
        boolean bl = hovered = mouseX > tabX && mouseX < tabX + length && mouseY > tabY && mouseY < tabY + tabHeight;
        int animate = selected || hovered ? (selected ? 2 : 1) : 0;
        int tabMid = tabX + length / 2;
        draw.drawRectangle(tabX, tabY - animate * 2, tabX + length, tabY + tabHeight, ModColor.toRGB(5, 5, 5, 140));
        draw.drawRectBorder(tabX, tabY - animate * 2, tabX + length, tabY + tabHeight, ModColor.toRGB(5, 5, 5, 140), 1.0);
        if (selected) {
            draw.drawRectangle(tabX + 1, tabY - animate * 2 + 1, tabX + length - 1, tabY + tabHeight, ModColor.toRGB(55, 55, 55, 65));
        }
        draw.drawCenteredString((selected || hovered ? ModColor.cl("f") : ModColor.cl("8")) + prefix + sortingState.getDisplayName(), tabMid, tabY + 2 - animate);
        if (hovered) {
            this.hoveredSortingState = sortingState;
        }
    }

    private void drawElementList(int mouseX, int mouseY) {
        double totalEntryHeight = 0.0;
        this.mouseOverAddonEntry = null;
        this.mouseOverElement = null;
        boolean canRenderDescription = true;
        int count = 0;
        if (this.isInSubSettings()) {
            for (int zLevel = 0; zLevel < 2; ++zLevel) {
                totalEntryHeight = 0.0;
                double listY = 50.0 + this.scrollbar.getScrollY();
                this.listedElementsStored = Lists.reverse(this.listedElementsStored);
                for (SettingsElement settingsElement : this.listedElementsStored) {
                    listY += (double)(settingsElement.getEntryHeight() + 2);
                    totalEntryHeight += (double)(settingsElement.getEntryHeight() + 2);
                }
                for (SettingsElement settingsElement : this.listedElementsStored) {
                    listY -= (double)(settingsElement.getEntryHeight() + 2);
                    totalEntryHeight -= (double)(settingsElement.getEntryHeight() + 2);
                    if ((settingsElement instanceof DropDownElement && !(settingsElement instanceof ColorPickerCheckBoxBulkElement) || zLevel != 0) && (!(settingsElement instanceof DropDownElement) && !(settingsElement instanceof ColorPickerCheckBoxBulkElement) || zLevel != 1)) continue;
                    settingsElement.draw(this.l / 2 - 100, (int)listY, this.l / 2 + 100, (int)(listY + (double)settingsElement.getEntryHeight()), mouseX, mouseY);
                    if (canRenderDescription && settingsElement instanceof DropDownElement) {
                        boolean bl = canRenderDescription = !((DropDownElement)settingsElement).getDropDownMenu().isOpen();
                    }
                    if (!settingsElement.isMouseOver()) continue;
                    this.mouseOverElement = settingsElement;
                }
                for (SettingsElement settingsElement : this.listedElementsStored) {
                    listY += (double)(settingsElement.getEntryHeight() + 2);
                    totalEntryHeight += (double)(settingsElement.getEntryHeight() + 2);
                }
                this.listedElementsStored = Lists.reverse(this.listedElementsStored);
            }
            count = this.listedElementsStored.size();
        } else {
            boolean ranked = this.selectedSortingState.isRanked();
            int rank = 1;
            double listY = 80.0 + this.scrollbar.getScrollY();
            for (AddonInfo addonInfo : this.sortedAddonInfoList) {
                boolean visible;
                boolean bl = visible = this.enabledFilter == null;
                if (!visible) {
                    for (int i : this.enabledFilter) {
                        if (i != addonInfo.getCategory()) continue;
                        visible = true;
                    }
                }
                if (!visible) continue;
                boolean hasInstalled = AddonLoader.hasInstalled(addonInfo);
                if (this.selectedSortingState == EnumSortingState.VERIFIED && (this.fieldSearch == null || this.fieldSearch.getText().isEmpty()) && (!(addonInfo instanceof OnlineAddonInfo) || !((OnlineAddonInfo)addonInfo).isVerified()) || (this.selectedSortingState == EnumSortingState.INSTALLED ? !hasInstalled : !(addonInfo instanceof OnlineAddonInfo) && (this.fieldSearch == null || this.fieldSearch.getText().isEmpty()))) continue;
                AddonElement addonElement = addonInfo.getAddonElement();
                addonElement.canHover(mouseY >= 75 && mouseY <= this.m - 30).draw(this.l / 2 - 150, (int)listY, this.l / 2 + 150, (int)(listY + (double)addonElement.getEntryHeight()), mouseX, mouseY);
                if (ranked) {
                    String prefix = "8";
                    switch (rank) {
                        case 1: {
                            prefix = "e";
                            break;
                        }
                        case 2: {
                            prefix = "7";
                            break;
                        }
                        case 3: {
                            prefix = "6";
                        }
                    }
                    LabyMod.getInstance().getDrawUtils().drawRightString(ModColor.cl(prefix) + rank + ".", this.l / 2 - 152, listY + 3.0, 0.7);
                }
                if (addonElement.isMouseOver()) {
                    this.mouseOverAddonEntry = addonInfo.getAddonElement();
                }
                listY += (double)(addonElement.getEntryHeight() + 2);
                totalEntryHeight += (double)(addonElement.getEntryHeight() + 2);
                ++rank;
            }
            count = AddonInfoManager.getInstance().getAddonInfoList().size();
        }
        if (canRenderDescription) {
            this.drawDescriptions(mouseX, mouseY, 80, this.m - 30);
        }
        this.scrollbar.setEntryHeight(totalEntryHeight / (double)count);
        this.scrollbar.update(count);
    }

    private void drawDescriptions(int mouseX, int mouseY, int minY, int maxY) {
        for (SettingsElement element : this.listedElementsStored) {
            if (!element.isMouseOver() || mouseY <= minY || mouseY >= maxY) continue;
            element.drawDescription(mouseX, mouseY, this.l);
        }
    }

    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        ControlElement element;
        block14: {
            block13: {
                int bottom;
                super.a(mouseX, mouseY, mouseButton);
                if (!this.isInSubSettings() && !this.displayRestartWarning && Tabs.mouseClicked(this)) {
                    return;
                }
                if (this.displayRestartWarning) {
                    return;
                }
                if (this.hoveredSortingState != null) {
                    this.selectedSortingState = this.hoveredSortingState;
                    this.sortAddonInfoList();
                }
                if (!this.isInSubSettings()) {
                    this.handleCheckBox(true, mouseX, mouseY, mouseButton);
                }
                if (this.fieldSearch != null) {
                    this.fieldSearch.mouseClicked(mouseX, mouseY, mouseButton);
                }
                if (this.openedAddonSettings != null) {
                    this.openedAddonSettings.onMouseClickedPreview(mouseX, mouseY, mouseButton);
                }
                int top = this.isInSubSettings() ? 45 : 75;
                int n = bottom = this.lastScreen == null ? this.m - 10 : this.m - 30;
                if (mouseY < top || mouseY > bottom) {
                    return;
                }
                if (!this.isInSubSettings()) break block13;
                this.unfocusSubListTextfields(mouseX, mouseY, mouseButton);
                for (SettingsElement element2 : this.listedElementsStored) {
                    if (element2 instanceof DropDownElement && ((DropDownElement)element2).onClickDropDown(mouseX, mouseY, mouseButton)) {
                        return;
                    }
                    if (!(element2 instanceof ColorPickerCheckBoxBulkElement) || !((ColorPickerCheckBoxBulkElement)element2).onClickBulkEntry(mouseX, mouseY, mouseButton)) continue;
                    return;
                }
                if (this.mouseOverElement == null) break block14;
                boolean flag = true;
                if (this.mouseOverElement instanceof ControlElement) {
                    SettingsElement element2;
                    element2 = (ControlElement)this.mouseOverElement;
                    boolean mouseOver = mouseX < LabyMod.getSettings().moduleEditorSplitX - ((ControlElement)element2).getObjectWidth() - ((ControlElement)element2).getSubListButtonWidth() - (this.scrollbar.isHidden() ? 5 : 10) - 2;
                    Module module = ((ControlElement)element2).getModule();
                    if (module != null && mouseOver) {
                        this.unfocusSubListTextfields(mouseX, mouseY, mouseButton);
                        flag = false;
                    }
                }
                if (!flag) break block14;
                this.mouseOverElement.mouseClicked(mouseX, mouseY, mouseButton);
                break block14;
            }
            for (AddonInfo addonInfo : AddonInfoManager.getInstance().getAddonInfoList()) {
                AddonElement element3 = addonInfo.getAddonElement();
                element3.mouseClicked(mouseX, mouseY, mouseButton);
                if (!element3.isHoverSubSettingsButton()) continue;
                this.openedAddonSettings = this.mouseOverAddonEntry;
                this.b();
            }
        }
        if (this.mouseOverElement != null && this.mouseOverElement instanceof ControlElement && (element = (ControlElement)this.mouseOverElement).hasSubList() && element.getButtonAdvanced().a() && element.getButtonAdvanced().l) {
            element.getButtonAdvanced().a(this.j.W());
            this.path.add(element);
            this.preScrollPos = this.scrollbar.getScrollY();
            this.scrollbar.setScrollY(0.0);
            this.b();
        }
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.CLICKED);
    }

    private void unfocusSubListTextfields(int mouseX, int mouseY, int mouseButton) {
        for (SettingsElement moduleElement : this.listedElementsStored) {
            moduleElement.unfocus(mouseX, mouseY, mouseButton);
        }
    }

    private void sortAddonInfoList() {
        String query;
        String string = query = this.fieldSearch == null ? null : this.fieldSearch.getText().toLowerCase().replaceAll(" ", "");
        if (query != null && query.isEmpty()) {
            query = null;
        }
        ArrayList<AddonInfo> sortedAddonInfoList = new ArrayList<AddonInfo>();
        for (AddonInfo addonInfo : AddonInfoManager.getInstance().getAddonInfoList()) {
            if (query != null && !this.match(addonInfo.getName(), query) && !this.match(addonInfo.getDescription(), query) && !this.match(addonInfo.getAuthor(), query)) continue;
            sortedAddonInfoList.add(addonInfo);
        }
        final int index = this.selectedSortingState.ordinal();
        Collections.sort(sortedAddonInfoList, new Comparator<AddonInfo>(){

            @Override
            public int compare(AddonInfo a2, AddonInfo b2) {
                int aId = a2 instanceof OnlineAddonInfo ? ((OnlineAddonInfo)a2).getSorting()[index] : 0;
                int bId = b2 instanceof OnlineAddonInfo ? ((OnlineAddonInfo)b2).getSorting()[index] : 0;
                return aId - bId;
            }
        });
        this.sortedAddonInfoList = sortedAddonInfoList;
    }

    private boolean match(String s1, String s2) {
        return s1.toLowerCase().replaceAll(" ", "").contains(s2);
    }

    private void handleCheckBox(boolean handleMouseClick, int mouseX, int mouseY, int mouseButton) {
        if (!AddonInfoManager.getInstance().isLoaded()) {
            return;
        }
        CheckBox[] checkBoxList = AddonInfoManager.getInstance().getCategorieCheckboxList();
        this.enabledFilter = new int[checkBoxList.length];
        int index = 0;
        for (CheckBox checkBox : checkBoxList) {
            if (handleMouseClick) {
                checkBox.mouseClicked(mouseX, mouseY, mouseButton);
            }
            this.enabledFilter[index] = checkBox.getValue() == CheckBox.EnumCheckBoxValue.ENABLED ? index + 1 : 0;
            ++index;
        }
    }

    protected void b(int mouseX, int mouseY, int state) {
        super.b(mouseX, mouseY, state);
        if (this.isInSubSettings()) {
            for (SettingsElement settingsElement : this.listedElementsStored) {
                settingsElement.mouseRelease(mouseX, mouseY, state);
            }
        }
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.RELEASED);
    }

    protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.isInSubSettings()) {
            for (SettingsElement settingsElement : this.listedElementsStored) {
                settingsElement.mouseClickMove(mouseX, mouseY, clickedMouseButton);
            }
        }
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.DRAGGING);
    }

    public void k() throws IOException {
        super.k();
        this.scrollbar.mouseInput();
        if (this.isInSubSettings()) {
            for (SettingsElement settingsElement : this.listedElementsStored) {
                if (!(settingsElement instanceof DropDownElement)) continue;
                ((DropDownElement)settingsElement).onScrollDropDown();
            }
        }
    }

    public void e() {
        super.e();
        if (this.fieldSearch != null) {
            this.fieldSearch.updateCursorCounter();
        }
    }

    protected void a(avs button) throws IOException {
        super.a(button);
        if (button == this.buttonDone && !this.displayRestartWarning) {
            if (LabyModAddonsGui.isRestartRequired()) {
                this.displayRestartWarning = true;
            } else {
                ave.A().a(this.lastScreen);
            }
        }
        if (this.path.isEmpty()) {
            if (button == this.buttonBack && !this.displayRestartWarning) {
                this.openedAddonSettings = null;
            }
        } else {
            this.path.remove(this.path.size() - 1);
            this.b();
            this.scrollbar.setScrollY(this.preScrollPos);
            this.preScrollPos = 0.0;
        }
        if (button == this.buttonWarningExitGame && this.displayRestartWarning) {
            this.j.m();
        }
        if (button == this.buttonWarningRestartLater && this.displayRestartWarning) {
            ave.A().a(this.lastScreen);
        }
    }

    protected void a(char typedChar, int keyCode) throws IOException {
        if (this.isInSubSettings()) {
            for (SettingsElement settingsElement : this.listedElementsStored) {
                boolean cancel = settingsElement instanceof KeyElement && ((KeyElement)settingsElement).getTextField().isFocused();
                settingsElement.keyTyped(typedChar, keyCode);
                if (!cancel) continue;
                return;
            }
            super.a(typedChar, keyCode);
        }
        if (this.fieldSearch != null && !this.isInSubSettings()) {
            this.fieldSearch.textboxKeyTyped(typedChar, keyCode);
            this.sortAddonInfoList();
        }
        if (keyCode == 1) {
            if (!this.displayRestartWarning && LabyModAddonsGui.isRestartRequired()) {
                this.displayRestartWarning = true;
            } else {
                ave.A().a(this.lastScreen);
            }
            return;
        }
    }

    public static boolean isRestartRequired() {
        for (LabyModAddon labyModAddon : AddonLoader.getAddons()) {
            if (labyModAddon.about == null || !labyModAddon.about.deleted) continue;
            return true;
        }
        return false;
    }

    private boolean isInSubSettings() {
        return this.openedAddonSettings != null;
    }

    public static enum EnumSortingState {
        TRENDING(LanguageManager.translate("sortingtab_trending"), true),
        TOP(LanguageManager.translate("sortingtab_top"), true),
        LATEST(LanguageManager.translate("sortingtab_latest"), false),
        VERIFIED(LanguageManager.translate("sortingtab_featured"), false),
        INSTALLED(LanguageManager.translate("sortingtab_installed"), false);

        private String displayName;
        private boolean ranked;

        private EnumSortingState(String displayName, boolean ranked) {
            this.displayName = displayName;
            this.ranked = ranked;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isRanked() {
            return this.ranked;
        }
    }
}

