/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.servermanager.group;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import net.labymod.gui.GuiAddonRecommendation;
import net.labymod.utils.ServerData;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;

public class ServerGroup {
    @SerializedName(value="server_name")
    private final String serverName;
    @SerializedName(value="nice_name")
    private final String displayName;
    @SerializedName(value="direct_ip")
    private final String directIp;
    private final String[] wildcards;
    private final Map<String, String> social;
    private final List<GuiAddonRecommendation.RecommendedAddon> addons;

    public ServerGroup(String serverName, String displayName, String directIp, String[] wildcards, Map<String, String> social, List<GuiAddonRecommendation.RecommendedAddon> addons) {
        this.serverName = serverName;
        this.displayName = displayName;
        this.directIp = directIp;
        this.wildcards = wildcards;
        this.social = social;
        this.addons = addons;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDirectIp() {
        return this.directIp;
    }

    public String[] getWildcards() {
        return this.wildcards;
    }

    public Map<String, String> getSocial() {
        return this.social;
    }

    public List<GuiAddonRecommendation.RecommendedAddon> getAddons() {
        return this.addons;
    }

    public boolean matches(ServerData data) {
        if (this.directIp.equalsIgnoreCase(data.getIp())) {
            return true;
        }
        if (this.wildcards != null) {
            for (String wildcard : this.wildcards) {
                if (!FilenameUtils.wildcardMatch((String)data.getIp(), (String)wildcard.replace('%', '*'), (IOCase)IOCase.INSENSITIVE)) continue;
                return true;
            }
        }
        return false;
    }
}

