/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.servermanager;

import com.google.common.reflect.ClassPath;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.labymod.addon.AddonLoader;
import net.labymod.api.LabyModAddon;
import net.labymod.api.permissions.Permissions;
import net.labymod.core.LabyModCore;
import net.labymod.ingamegui.Module;
import net.labymod.main.LabyMod;
import net.labymod.main.Source;
import net.labymod.servermanager.ChatDisplayAction;
import net.labymod.servermanager.Server;
import net.labymod.servermanager.ServerConfig;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.support.util.Debug;
import net.labymod.utils.manager.ConfigManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ServerManager {
    private final ConfigManager<ServerConfig> serverConfigManager;
    private final ServerConfig config;
    private final List<Server> servers = new ArrayList<Server>();
    private final Map<Permissions.Permission, Boolean> permissionMap = new HashMap<Permissions.Permission, Boolean>();
    private Server currentServer;
    private bde prevServer;
    private long lastSecond = 0L;

    public ServerManager() {
        this.serverConfigManager = new ConfigManager<ServerConfig>(new File(Source.FILE_LABYMOD_FOLDER, "servers.json"), ServerConfig.class);
        this.config = this.serverConfigManager.getSettings();
    }

    public void init() {
        try {
            for (ClassPath.ClassInfo classInfo : ClassPath.from((ClassLoader)Module.class.getClassLoader()).getTopLevelClassesRecursive("net.labymod.servermanager.servers")) {
                final Server server = (Server)classInfo.load().newInstance();
                LabyModAddon dummyAddon = new LabyModAddon(){

                    @Override
                    public void onEnable() {
                        ServerManager.this.registerServerSupport(this, server);
                    }

                    @Override
                    public void onDisable() {
                    }

                    @Override
                    public void loadConfig() {
                    }

                    @Override
                    protected void fillSettings(List<SettingsElement> subSettings) {
                    }
                };
                dummyAddon.onEnable();
                dummyAddon.init(server.getName(), UUID.randomUUID());
                AddonLoader.getAddons().add(dummyAddon);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerServerSupport(LabyModAddon labyModAddon, Server server) {
        server.bindAddon(labyModAddon);
        this.servers.add(server);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        bde currentServerData = ave.A().D();
        if (currentServerData != null && LabyModCore.getMinecraft().getConnection() != null && this.prevServer != currentServerData) {
            this.prevServer = currentServerData;
            this.updateServer(currentServerData.b);
            if (this.currentServer != null) {
                this.currentServer.onJoin(currentServerData);
            }
            LabyMod.getInstance().onJoinServer(currentServerData);
        } else if (currentServerData == null && this.prevServer != null) {
            this.reset();
            this.updateServer(null);
            this.prevServer = null;
            Debug.log(Debug.EnumDebugMode.MINECRAFT, "Disconnected from server");
        }
        if (this.lastSecond < System.currentTimeMillis()) {
            this.lastSecond = System.currentTimeMillis() + 1000L;
            if (this.currentServer != null) {
                this.currentServer.loopSecond();
            }
        }
    }

    public ChatDisplayAction handleChatMessage(String clean, String formatted) {
        try {
            return this.currentServer == null ? ChatDisplayAction.NORMAL : this.currentServer.handleChatMessage(clean, formatted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ChatDisplayAction.NORMAL;
        }
    }

    public void updateServer(String ip) {
        if (ip == null) {
            this.currentServer = null;
            return;
        }
        for (Server server : this.servers) {
            for (String addresses : server.getAddressNames()) {
                if (!ip.toLowerCase().contains(addresses.toLowerCase())) continue;
                this.currentServer = server;
                return;
            }
        }
    }

    public void reset() {
        this.permissionMap.clear();
        for (Server server : this.servers) {
            server.reset();
        }
    }

    public void draw() {
        if (this.currentServer == null) {
            return;
        }
        this.currentServer.draw();
    }

    public boolean isServer(Class<? extends Server> serverClass) {
        return this.currentServer != null && this.currentServer.getClass().equals(serverClass);
    }

    public boolean isAllowed(Permissions.Permission permission) {
        if (ave.A().F()) {
            return true;
        }
        if (this.currentServer == null) {
            Boolean allowed = this.permissionMap.get((Object)permission);
            if (allowed == null) {
                allowed = permission.isDefaultEnabled();
            }
            return allowed;
        }
        return this.currentServer.isAllowed(permission);
    }

    public ConfigManager<ServerConfig> getServerConfigManager() {
        return this.serverConfigManager;
    }

    public ServerConfig getConfig() {
        return this.config;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public Map<Permissions.Permission, Boolean> getPermissionMap() {
        return this.permissionMap;
    }

    public Server getCurrentServer() {
        return this.currentServer;
    }

    public void setPrevServer(bde prevServer) {
        this.prevServer = prevServer;
    }
}

