/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.main.update.migration;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.labymod.addon.AddonLoader;
import net.labymod.addon.LabyModOFAddon;
import net.labymod.addon.online.AddonDownloader;
import net.labymod.addon.online.AddonInfoManager;
import net.labymod.addon.online.CallbackAddonDownloadProcess;
import net.labymod.addon.online.info.OnlineAddonInfo;
import net.labymod.main.LabyMod;
import net.labymod.main.QuickInstaller;
import net.labymod.main.Source;
import net.labymod.main.lang.LanguageManager;
import net.labymod.main.update.migration.InstallationProgressCallback;
import net.labymod.main.update.migration.LatestMinecraftVersion;
import net.labymod.main.update.migration.gui.GuiTrySodium;
import net.labymod.support.util.Debug;
import net.labymod.utils.JsonParse;
import net.labymod.utils.request.DownloadServerRequest;
import org.apache.commons.codec.binary.Base64;

public class MigrationUpdater {
    private static final String SODIUM_NAME = "Sodium";
    private static final JsonParser jsonParser = new JsonParser();
    public static final String LIBRARY_NAME = "LabyMod";
    public static final String LIBRARY_MAJOR_VERSION = "3";
    public static final String MOD_NAME = "LabyMod-3";
    private final File minecraftDirectory = QuickInstaller.getWorkingDirectory();
    private final AddonInfoManager addonManager = AddonInfoManager.getInstance();
    private List<OnlineAddonInfo> migratedAddons = new ArrayList<OnlineAddonInfo>();
    private List<OnlineAddonInfo> missingAddons = new ArrayList<OnlineAddonInfo>();
    private boolean usingOptiFine = false;

    public boolean hasLatestVersion() {
        LatestMinecraftVersion latestVersion = LabyMod.getInstance().getUpdater().getLabyModUpdateChecker().getLatestMinecraftVersion();
        if (latestVersion == null) {
            return true;
        }
        File librariesJar = new File(this.minecraftDirectory, "libraries/net/labymod/LabyMod/3_" + latestVersion.minecraftVersion + "/LabyMod-3_" + latestVersion.minecraftVersion + ".jar");
        return librariesJar.exists();
    }

    public void initAndInstallAsnyc(final InstallationProgressCallback callback) {
        LatestMinecraftVersion latestVersion = LabyMod.getInstance().getUpdater().getLabyModUpdateChecker().getLatestMinecraftVersion();
        if (latestVersion == null) {
            callback.failed();
            return;
        }
        this.missingAddons.clear();
        this.migratedAddons.clear();
        callback.progress(10.0, LanguageManager.translate("update_minecraft_progress_migrate_addons"));
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AddonInfoManager.getInstance().init();
                    MigrationUpdater.this.initAndInstall(callback);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    callback.failed();
                }
            }
        });
    }

    private void initAndInstall(final InstallationProgressCallback callback) {
        for (OnlineAddonInfo addonInfo : this.addonManager.getAllMinecraftVersionsAddonInfoList()) {
            if (!AddonLoader.hasInstalled(addonInfo)) continue;
            OnlineAddonInfo latestAddonInfo = this.getNewerAddonVersion(addonInfo);
            if (latestAddonInfo == null) {
                this.missingAddons.add(addonInfo);
            } else {
                this.migratedAddons.add(latestAddonInfo);
            }
            if (!addonInfo.isIncludeInJar()) continue;
            this.usingOptiFine = true;
        }
        final OnlineAddonInfo sodium = this.getSodium();
        if (sodium == null) {
            this.install(callback, false);
        } else {
            ave.A().a(new Runnable(){

                @Override
                public void run() {
                    axu currentScreen = ave.A().m;
                    ave.A().a((axu)new GuiTrySodium(currentScreen, new Consumer<Boolean>(){

                        @Override
                        public void accept(Boolean useSodium) {
                            if (useSodium.booleanValue()) {
                                MigrationUpdater.this.migratedAddons.add(sodium);
                            }
                            MigrationUpdater.this.installAsync(callback, useSodium);
                        }
                    }, MigrationUpdater.this.usingOptiFine));
                }
            });
        }
    }

    private void installAsync(final InstallationProgressCallback callback, final Boolean useSodium) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    MigrationUpdater.this.install(callback, useSodium);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    callback.failed();
                }
            }
        });
    }

    private void install(final InstallationProgressCallback callback, boolean useSodium) {
        FileOutputStream fos;
        LatestMinecraftVersion latestVersion = LabyMod.getInstance().getUpdater().getLabyModUpdateChecker().getLatestMinecraftVersion();
        File directoryAddonsCurrent = AddonLoader.getAddonsDirectory();
        File directoryAddonsLatest = new File(Source.FILE_LABYMOD_FOLDER, "addons-" + latestVersion.minecraftVersionRaw[0] + "." + latestVersion.minecraftVersionRaw[1]);
        directoryAddonsLatest.mkdirs();
        new File(Source.FILE_LABYMOD_FOLDER, "ofhandler").mkdir();
        final double maxPercentOffset = 70.0;
        final double maxPercent = this.migratedAddons.size() * 100;
        int i = 0;
        for (final OnlineAddonInfo migratedAddon : this.migratedAddons) {
            if (useSodium && migratedAddon.isIncludeInJar()) continue;
            final double totalPercent = i * 100;
            try {
                File destination = migratedAddon.isIncludeInJar() ? new File(Source.FILE_LABYMOD_FOLDER, "ofhandler/optifine.jar") : new File(directoryAddonsLatest, migratedAddon.getName() + ".jar");
                double percentOffset = maxPercentOffset / maxPercent * (totalPercent + 0.0);
                callback.progress(10.0 + percentOffset, LanguageManager.translate("update_minecraft_progress_download_addon", migratedAddon.getName(), "0%"));
                new AddonDownloader(migratedAddon, destination, new CallbackAddonDownloadProcess(){

                    @Override
                    public void success(File file) {
                        double percentOffset = maxPercentOffset / maxPercent * (totalPercent + 100.0);
                        Debug.log(Debug.EnumDebugMode.UPDATER, "Downloaded " + file.getAbsolutePath());
                        callback.progress(10.0 + percentOffset, LanguageManager.translate("update_minecraft_progress_download_addon", migratedAddon.getName(), "100%"));
                    }

                    @Override
                    public void progress(double percent) {
                        double percentOffset = maxPercentOffset / maxPercent * (totalPercent + percent);
                        callback.progress(10.0 + percentOffset, LanguageManager.translate("update_minecraft_progress_download_addon", migratedAddon.getName(), String.valueOf((int)percent)) + "%");
                    }

                    @Override
                    public void failed(String message) {
                        Debug.log(Debug.EnumDebugMode.UPDATER, "Error: " + message);
                    }
                }).downloadSync();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (directoryAddonsCurrent.exists() && directoryAddonsLatest.exists()) {
            File currentConfig = new File(directoryAddonsCurrent, "config");
            File latestConfig = new File(directoryAddonsLatest, "config");
            currentConfig.mkdir();
            latestConfig.mkdir();
            File[] files = currentConfig.listFiles();
            if (files != null) {
                for (File json : files) {
                    if (!json.getName().endsWith(".json")) continue;
                    try {
                        Files.copy((File)json, (File)new File(latestConfig, json.getName()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        File minecraftDirectory = QuickInstaller.getWorkingDirectory();
        File latestVersionDirectory = new File(minecraftDirectory, "versions/LabyMod-3-" + latestVersion.minecraftVersion);
        callback.progress(80.0, LanguageManager.translate("update_minecraft_progress_download_mc_json"));
        try {
            File jsonFile = new File(latestVersionDirectory, "LabyMod-3-" + latestVersion.minecraftVersion + ".json");
            jsonFile.getParentFile().mkdirs();
            fos = new FileOutputStream(jsonFile);
            DownloadServerRequest.writeBytes(String.format("https://dl.labymod.net/latest/install/json/%s.json", latestVersion.minecraftVersion), fos);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            callback.failed();
            return;
        }
        File jarFile = new File(latestVersionDirectory, "LabyMod-3-" + latestVersion.minecraftVersion + ".jar");
        callback.progress(85.0, LanguageManager.translate("update_minecraft_progress_download_mc_jar"));
        try {
            jarFile.getParentFile().mkdirs();
            fos = new FileOutputStream(jarFile);
            DownloadServerRequest.writeBytes(String.format(latestVersion.mcUrl, latestVersion.minecraftVersion), fos);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            callback.failed();
            return;
        }
        File librariesJar = new File(minecraftDirectory, "libraries/net/labymod/LabyMod/3_" + latestVersion.minecraftVersion + "/LabyMod-3_" + latestVersion.minecraftVersion + ".jar");
        callback.progress(90.0, LanguageManager.translate("update_minecraft_progress_download_labymod"));
        try {
            librariesJar.getParentFile().mkdirs();
            FileOutputStream fos2 = new FileOutputStream(librariesJar);
            DownloadServerRequest.writeBytes(String.format(latestVersion.url, latestVersion.minecraftVersion), fos2);
            fos2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            callback.failed();
            return;
        }
        if (!librariesJar.exists()) {
            Debug.log(Debug.EnumDebugMode.UPDATER, librariesJar.getAbsolutePath() + " is still not there. AntiVirus?");
            callback.failed();
            return;
        }
        if (this.usingOptiFine && !useSodium) {
            callback.progress(95.0, LanguageManager.translate("update_minecraft_progress_install_optifine"));
            try {
                LabyModOFAddon.downloadOFHandler(false);
                LabyModOFAddon.executeOfHandlerDirect(true, latestVersion.minecraftVersion, jarFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        callback.progress(98.0, LanguageManager.translate("update_minecraft_progress_update_launcher"));
        boolean success = this.updateLauncherProfiles(new File(minecraftDirectory, "launcher_profiles.json"), useSodium);
        if (this.updateLauncherProfiles(new File(minecraftDirectory, "launcher_profiles_microsoft_store.json"), useSodium)) {
            success = true;
        }
        try {
            this.updateLauncherUIState(new File(minecraftDirectory, "launcher_ui_state.json"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.updateLauncherUIState(new File(minecraftDirectory, "launcher_ui_state_microsoft_store.json"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (success) {
            callback.completed();
        } else {
            callback.failed();
        }
    }

    private OnlineAddonInfo getNewerAddonVersion(OnlineAddonInfo info) {
        LatestMinecraftVersion latestVersion = LabyMod.getInstance().getUpdater().getLabyModUpdateChecker().getLatestMinecraftVersion();
        String major = latestVersion.minecraftVersionRaw[0] + "" + latestVersion.minecraftVersionRaw[1];
        for (OnlineAddonInfo addonInfo : this.addonManager.getAllMinecraftVersionsAddonInfoList()) {
            if (!addonInfo.getMcVersion().equals(major) || (!addonInfo.isIncludeInJar() || !info.isIncludeInJar()) && (!addonInfo.getName().equalsIgnoreCase(info.getName()) || !addonInfo.getAuthor().equalsIgnoreCase(info.getAuthor()))) continue;
            return addonInfo;
        }
        return null;
    }

    private OnlineAddonInfo getSodium() {
        LatestMinecraftVersion latestVersion = LabyMod.getInstance().getUpdater().getLabyModUpdateChecker().getLatestMinecraftVersion();
        String major = latestVersion.minecraftVersionRaw[0] + "" + latestVersion.minecraftVersionRaw[1];
        for (OnlineAddonInfo addonInfo : this.addonManager.getAllMinecraftVersionsAddonInfoList()) {
            if (!addonInfo.getMcVersion().equals(major) || !addonInfo.getName().equalsIgnoreCase(SODIUM_NAME)) continue;
            return addonInfo;
        }
        return null;
    }

    private boolean updateLauncherProfiles(File launcherProfilesFile, boolean useSodium) {
        if (!launcherProfilesFile.exists()) {
            return false;
        }
        LatestMinecraftVersion latestVersion = LabyMod.getInstance().getUpdater().getLabyModUpdateChecker().getLatestMinecraftVersion();
        String profileName = "LabyMod-3-" + latestVersion.minecraftVersion;
        String profileNameCurrent = "LabyMod-3-" + Source.ABOUT_MC_VERSION;
        String json = null;
        try {
            json = MigrationUpdater.readFile(launcherProfilesFile);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        JsonObject root = (JsonObject)JsonParse.parse(json);
        if (!root.has("profiles")) {
            return false;
        }
        int profileFormatVersion = 0;
        try {
            profileFormatVersion = root.get("launcherVersion").getAsJsonObject().get("profilesFormat").getAsInt();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        JsonObject profiles = root.get("profiles").getAsJsonObject();
        String javaArgs = useSodium ? null : "-Xmx5G";
        try {
            JsonObject obj;
            if (profiles.has(profileNameCurrent) && (obj = profiles.get(profileNameCurrent).getAsJsonObject()).has("javaArgs")) {
                javaArgs = useSodium ? obj.get("javaArgs").getAsString() : obj.get("javaArgs").getAsString().replaceAll("-Xmx\\d\\w+", javaArgs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonObject profileObject = new JsonObject();
        profileObject.addProperty("name", profileName);
        profileObject.addProperty("lastVersionId", profileName);
        if (javaArgs != null) {
            profileObject.addProperty("javaArgs", javaArgs);
        }
        if (profileFormatVersion >= 2) {
            try {
                ImageIcon imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(MigrationUpdater.class.getResource("/assets/minecraft/labymod/textures/labymod_logo.png")));
                BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
                Graphics2D graphics = bufferedImage.createGraphics();
                imageIcon.paintIcon(null, graphics, 0, 0);
                graphics.dispose();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                String encodedBase64Image = new String(Base64.encodeBase64((byte[])byteArrayOutputStream.toByteArray()));
                profileObject.addProperty("icon", "data:image/png;base64," + encodedBase64Image);
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
        if (!profiles.has(profileName)) {
            profiles.add(profileName, (JsonElement)profileObject);
        }
        root.addProperty("selectedProfile", profileName);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            FileWriter fwJson = new FileWriter(launcherProfilesFile);
            fwJson.write(gson.toJson((JsonElement)root));
            fwJson.flush();
            fwJson.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void updateLauncherUIState(File launcherUIStateFile) {
        if (!launcherUIStateFile.exists()) {
            Debug.log(Debug.EnumDebugMode.UPDATER, "launcher_ui_state.json doesn't exist. Skipping it...");
            return;
        }
        LatestMinecraftVersion latestVersion = LabyMod.getInstance().getUpdater().getLabyModUpdateChecker().getLatestMinecraftVersion();
        String profileName = "LabyMod-3-" + latestVersion.minecraftVersion;
        String json = null;
        try {
            json = MigrationUpdater.readFile(launcherUIStateFile);
        }
        catch (Throwable e) {
            Debug.log(Debug.EnumDebugMode.UPDATER, "Couldn't read launcher_ui_state.json: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        JsonObject root = (JsonObject)jsonParser.parse(json);
        if (!root.has("data")) {
            Debug.log(Debug.EnumDebugMode.UPDATER, "Didn't find data-attribute in launcher_ui_state.json");
            return;
        }
        int uiStateFormatVersion = 0;
        try {
            uiStateFormatVersion = root.get("formatVersion").getAsInt();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        if (uiStateFormatVersion != 1) {
            Debug.log(Debug.EnumDebugMode.UPDATER, "It's a newer version: " + uiStateFormatVersion);
            return;
        }
        JsonObject dataObject = root.get("data").getAsJsonObject();
        String uiEventsJson = dataObject.get("UiEvents").getAsString();
        JsonObject uiEventsObject = (JsonObject)jsonParser.parse(uiEventsJson);
        JsonObject target = null;
        if (uiEventsObject.has("hidePlayerSafetyDisclaimer")) {
            target = uiEventsObject.get("hidePlayerSafetyDisclaimer").getAsJsonObject();
        } else {
            target = new JsonObject();
            uiEventsObject.add("hidePlayerSafetyDisclaimer", (JsonElement)target);
        }
        if (target != null) {
            target.addProperty(profileName + "_" + profileName, Boolean.valueOf(true));
        }
        dataObject.addProperty("UiEvents", uiEventsObject.toString());
        String uiSettingsJson = dataObject.get("UiSettings").getAsString();
        JsonObject uiSettingsObject = (JsonObject)jsonParser.parse(uiSettingsJson);
        if (uiSettingsObject.has("javaConfigurationFilter")) {
            JsonObject javaConfigurationFilter = uiSettingsObject.get("javaConfigurationFilter").getAsJsonObject();
            javaConfigurationFilter.addProperty("modded", Boolean.valueOf(true));
        }
        dataObject.addProperty("UiSettings", uiSettingsObject.toString());
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            FileWriter fwJson = new FileWriter(launcherUIStateFile);
            fwJson.write(gson.toJson((JsonElement)root));
            fwJson.flush();
            fwJson.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String readFile(File file) throws IOException {
        String line;
        FileInputStream fin = new FileInputStream(file);
        InputStreamReader inr = new InputStreamReader((InputStream)fin, "UTF-8");
        BufferedReader br = new BufferedReader(inr);
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        br.close();
        inr.close();
        fin.close();
        return sb.toString();
    }
}

