/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.main.update.migration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.labymod.main.update.LabyModUpdateChecker;
import net.labymod.main.update.UpdateData;

public class LatestMinecraftVersion {
    public short[] minecraftVersionRaw;
    public String minecraftVersion;
    public String labymodVersion;
    public String mcUrl;
    public String url;
    public boolean isPlusOnly;

    public LatestMinecraftVersion(short[] version, JsonObject object) {
        this.minecraftVersionRaw = version;
        this.minecraftVersion = version[0] + "." + version[1] + "." + version[2];
        this.labymodVersion = object.get("version").getAsString();
        this.mcUrl = object.get("mcUrl").getAsString();
        this.url = object.has("url") ? object.get("url").getAsString() : object.get("plusUrl").getAsString();
        this.isPlusOnly = object.has("plusUrl");
    }

    public static LatestMinecraftVersion from(JsonObject object) {
        short[] latestVersion = null;
        JsonObject latestObject = null;
        for (Map.Entry entry : object.entrySet()) {
            short[] version = UpdateData.getShortVersionOfString((String)entry.getKey());
            if (latestVersion != null && !LabyModUpdateChecker.isClientOutdated(latestVersion, version)) continue;
            latestVersion = version;
            latestObject = ((JsonElement)entry.getValue()).getAsJsonObject();
        }
        return new LatestMinecraftVersion(latestVersion, latestObject);
    }
}

