/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.main.update.migration;

import java.util.List;
import java.util.function.Consumer;
import net.labymod.main.LabyMod;
import net.labymod.main.lang.LanguageManager;
import net.labymod.main.update.LabyModUpdateChecker;
import net.labymod.main.update.migration.InstallationProgressCallback;
import net.labymod.main.update.migration.MigrationUpdater;
import net.labymod.main.update.migration.gui.GuiGiveItATry;
import net.labymod.support.util.Debug;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import org.lwjgl.opengl.GL11;

public class LatestMinecraftPopupRenderer {
    private MigrationUpdater latestMinecraftVersionInstaller = new MigrationUpdater();
    private boolean hoverUpdateClose = false;
    private boolean hoverUpdate = false;
    private boolean updateStarted = false;
    private boolean updateFinished = false;
    private String updateProgressMessage = null;
    private double updateProgress = 0.0;
    private double prevUpdateProgress = 0.0;
    private long lastProgressUpdate = 0L;

    public void draw(int mouseX, int mouseY, String version) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        double updateWidth = 100.0;
        double updateHeight = 20.0;
        double centerX = draw.getWidth() / 2;
        double centerY = 90 + (draw.getHeight() / 2 - 40 - 90) / 2;
        int closeSize = 5;
        double closeX = centerX + updateWidth;
        double closeY = centerY - updateHeight / 2.0;
        boolean hoverClose = (double)mouseX > closeX - (double)closeSize && (double)mouseX < closeX + (double)closeSize && (double)mouseY > closeY - (double)closeSize && (double)mouseY < closeY + (double)closeSize;
        closeSize = hoverClose ? 5 : 4;
        boolean hover = !hoverClose && (double)mouseX > centerX - updateWidth && (double)mouseX < centerX + updateWidth && (double)mouseY > centerY - updateHeight / 2.0 && (double)mouseY < centerY + updateHeight / 2.0;
        draw.drawRect(centerX - updateWidth - 1.0, centerY - updateHeight / 2.0 - 1.0, centerX + updateWidth + 1.0, centerY + updateHeight / 2.0 + 1.0, hover ? ModColor.toRGB(200, 100, 200, 100) : Integer.MAX_VALUE);
        if (this.updateStarted && !this.updateFinished) {
            double partialTicks = Math.min(1.0f, (float)(System.currentTimeMillis() - this.lastProgressUpdate) / 1000.0f);
            double progress = this.prevUpdateProgress + (this.updateProgress - this.prevUpdateProgress) * partialTicks;
            double progressWith = (updateWidth * 2.0 + 2.0) / 100.0 * Math.min(100.0, progress);
            draw.drawRect(centerX - updateWidth - 1.0, centerY - updateHeight / 2.0 - 1.0, centerX - updateWidth - 1.0 + progressWith, centerY + updateHeight / 2.0 + 1.0, hover ? ModColor.toRGB(100, 250, 100, 100) : Integer.MAX_VALUE);
        }
        draw.drawRect(centerX - updateWidth, centerY - updateHeight / 2.0, centerX + updateWidth, centerY + updateHeight / 2.0, Integer.MIN_VALUE);
        draw.drawRect(centerX - updateWidth, centerY - updateHeight / 2.0, centerX + updateWidth, centerY + updateHeight / 2.0, Integer.MIN_VALUE);
        String message = ModColor.createColors(this.updateProgressMessage == null ? LabyMod.getMessage("update_minecraft", version) : this.updateProgressMessage);
        int lenght = draw.getStringWidth(message);
        if ((double)lenght * 0.7 > updateWidth * 2.0) {
            List<String> list = draw.listFormattedStringToWidth(message, (int)(updateWidth * 2.0 / 0.7), 2);
            double listY = centerY - 6.5;
            for (String line : list) {
                draw.drawCenteredString(line, draw.getWidth() / 2, listY, 0.7);
                listY += 8.0;
            }
        } else {
            draw.drawCenteredString(message, draw.getWidth() / 2, centerY - 2.5, 0.7);
        }
        if (!this.updateStarted && !this.updateFinished) {
            int i;
            bfl.E();
            bfl.x();
            bfl.c((float)(hoverClose ? 0.8f : 0.2f), (float)0.2f, (float)0.2f);
            bfl.b((double)closeX, (double)closeY, (double)0.0);
            GL11.glBegin((int)9);
            for (i = 0; i < 6; ++i) {
                GL11.glVertex2d((double)(Math.sin((double)i / 6.0 * 2.0 * Math.PI) * (double)closeSize), (double)(Math.cos((double)i / 6.0 * 2.0 * Math.PI) * (double)closeSize));
            }
            GL11.glEnd();
            bfl.w();
            bfl.F();
            bfl.E();
            bfl.c((float)0.8f, (float)0.2f, (float)0.2f);
            bfl.b((double)closeX, (double)closeY, (double)0.0);
            for (i = 1; i < 3; ++i) {
                bfl.b((float)(45 * i), (float)0.0f, (float)0.0f, (float)1.0f);
                draw.drawRect((double)(-closeSize) / 2.0, -0.3, (double)closeSize / 2.0, 0.3, -1);
            }
            bfl.F();
        }
        this.hoverUpdate = hover;
        this.hoverUpdateClose = hoverClose;
    }

    public void onClick(int mouseX, int mouseY) {
        if (this.hoverUpdate && this.isVisible()) {
            this.hoverUpdate = false;
            this.migrateNow();
        }
        if (this.hoverUpdateClose && !this.updateStarted && !this.updateFinished) {
            this.hoverUpdateClose = false;
            ave.A().a((axu)new GuiGiveItATry(ave.A().m, new Consumer<Integer>(){

                @Override
                public void accept(Integer option) {
                    if (option == 0) {
                        LabyMod.getSettings().ignoreMigration = true;
                        LabyMod.getMainConfig().save();
                    }
                    if (option == 2) {
                        LatestMinecraftPopupRenderer.this.migrateNow();
                    }
                }
            }));
        }
    }

    private void migrateNow() {
        if (!this.updateStarted) {
            this.updateStarted = true;
            this.latestMinecraftVersionInstaller.initAndInstallAsnyc(new InstallationProgressCallback(){

                @Override
                public void progress(double progress, String message) {
                    LatestMinecraftPopupRenderer.this.prevUpdateProgress = LatestMinecraftPopupRenderer.this.updateProgress;
                    LatestMinecraftPopupRenderer.this.lastProgressUpdate = System.currentTimeMillis();
                    LatestMinecraftPopupRenderer.this.updateProgressMessage = message;
                    LatestMinecraftPopupRenderer.this.updateProgress = progress;
                }

                @Override
                public void failed() {
                    LatestMinecraftPopupRenderer.this.updateProgressMessage = ModColor.cl('c') + LanguageManager.translate("update_minecraft_failed");
                }

                @Override
                public void completed() {
                    LatestMinecraftPopupRenderer.this.updateFinished = true;
                    LatestMinecraftPopupRenderer.this.updateProgressMessage = ModColor.cl('a') + LanguageManager.translate("update_minecraft_finished");
                }
            });
        } else if (this.updateFinished) {
            ave.A().m();
        }
    }

    public MigrationUpdater getInstaller() {
        return this.latestMinecraftVersionInstaller;
    }

    public boolean isVisible() {
        LabyModUpdateChecker update = LabyMod.getInstance().getUpdater().getLabyModUpdateChecker();
        return !LabyMod.getSettings().ignoreMigration && (this.updateStarted || this.updateFinished || update != null && update.getLatestMinecraftVersion() != null && (!update.getLatestMinecraftVersion().isPlusOnly || Debug.isActive()) && !this.latestMinecraftVersionInstaller.hasLatestVersion());
    }
}

