/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.main.update;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import net.labymod.addon.AddonLoader;
import net.labymod.main.LabyMod;
import net.labymod.main.Source;
import net.labymod.main.update.AddonUpdateChecker;
import net.labymod.main.update.LabyModUpdateChecker;
import net.labymod.main.update.UpdateData;
import net.labymod.support.report.ReportArguments;
import net.labymod.support.util.Debug;
import net.labymod.utils.Consumer;
import net.labymod.utils.request.DownloadServerRequest;
import net.labymod.utils.request.RequestException;
import net.labymod.utils.request.ServerResponse;
import net.labymod.utils.request.ServerStatus;

public class Updater {
    private static final Gson GSON = new Gson();
    private final LabyModUpdateChecker labyModUpdateChecker = new LabyModUpdateChecker();
    private final AddonUpdateChecker addonUpdateChecker = new AddonUpdateChecker();
    private UpdateData coreUpdate = new UpdateData("unknown", null, false);
    private UpdateData[] addonUpdates = new UpdateData[0];
    private boolean updateAvailable = false;
    private int addonUpdateCount = 0;
    private boolean forceUpdate = false;
    private boolean backupMethod = false;

    public void addShutdownHook() {
        LabyMod.getInstance().getEventManager().registerShutdownHook(() -> {
            if (this.updateAvailable || this.forceUpdate) {
                this.executeUpdater();
                return;
            }
            this.labyModUpdateChecker.getUpdateData().thenAccept(data -> {
                if (data.isUpdateAvailable()) {
                    this.executeUpdater();
                }
            });
        });
    }

    public void checkUpdate() {
        try {
            this.ensureUpdaterAvailable(accepted -> {
                if (!accepted.booleanValue()) {
                    Debug.log(Debug.EnumDebugMode.UPDATER, "Failed to download updater, skipping update checks");
                    return;
                }
                this.labyModUpdateChecker.getUpdateData().thenAccept(data -> {
                    this.printInfo((UpdateData)data);
                    this.coreUpdate = data;
                    this.updateAvailable = data.isUpdateAvailable();
                    this.addonUpdateChecker.getAddonUpdateData().thenAccept(addonUpdates -> {
                        this.addonUpdates = addonUpdates;
                        this.addonUpdateCount = 0;
                        for (UpdateData update : addonUpdates) {
                            if (!update.isUpdateAvailable()) continue;
                            this.updateAvailable = true;
                            ++this.addonUpdateCount;
                        }
                    });
                });
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void executeReport(ReportArguments reportArguments) {
        String json = GSON.toJson((Object)reportArguments);
        this.execute(true, json);
    }

    public void executeUpdater() {
        Debug.log(Debug.EnumDebugMode.UPDATER, "Executing LabyMod Updater");
        this.execute(false, null);
        Debug.log(Debug.EnumDebugMode.UPDATER, "Updating complete");
    }

    public void execute(boolean report, String json) {
        try {
            String javaHome = System.getProperty("java.home");
            String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add(this.backupMethod ? "java" : javaBin);
            arguments.add("-jar");
            arguments.add(Source.FILE_UPDATER.getAbsolutePath());
            if (report) {
                arguments.add("report");
                arguments.add(Base64.getEncoder().encodeToString(json.getBytes()));
            }
            StringBuilder debug = new StringBuilder();
            for (String arg : arguments) {
                debug.append(arg).append(" ");
            }
            Debug.log(Debug.EnumDebugMode.UPDATER, debug.toString());
            ProcessBuilder pb = new ProcessBuilder(arguments);
            pb.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printInfo(UpdateData data) {
        Debug.log(Debug.EnumDebugMode.UPDATER, "The latest LabyMod version is v" + data.getLatestVersion() + ", you are currently using LabyMod version v" + "3.9.62");
        if (data.isUpdateAvailable()) {
            Debug.log(Debug.EnumDebugMode.UPDATER, "You are outdated!");
        } else {
            Debug.log(Debug.EnumDebugMode.UPDATER, "You are using the latest version.");
        }
    }

    public void ensureUpdaterAvailable(Consumer<Boolean> consumer) throws Exception {
        File file = Source.FILE_UPDATER;
        if (!file.exists()) {
            this.downloadUpdaterFile(consumer);
            return;
        }
        this.loadUpdaterHash().thenAccept(hash -> {
            if (hash == null) {
                consumer.accept(false);
                return;
            }
            try {
                if (AddonLoader.getCheckSum(file).equals(hash)) {
                    consumer.accept(true);
                    return;
                }
                this.downloadUpdaterFile(consumer);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                consumer.accept(false);
            }
        });
    }

    private void downloadUpdaterFile(final Consumer<Boolean> consumer) throws Exception {
        final File file = Source.FILE_UPDATER;
        final FileOutputStream fos = new FileOutputStream(file);
        DownloadServerRequest.writeBytesAsync("https://dl.labymod.net/latest/install/updater/updater.jar", fos, new ServerStatus(){

            @Override
            public void success() {
                Debug.log(Debug.EnumDebugMode.UPDATER, "Downloaded latest Updater https://dl.labymod.net/latest/install/updater/updater.jar");
                consumer.accept(file.exists());
            }

            @Override
            public void failed(RequestException exception) {
                exception.printStackTrace();
                consumer.accept(file.exists());
            }

            @Override
            public void close() throws Exception {
                fos.close();
            }
        });
    }

    private CompletableFuture<String> loadUpdaterHash() {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        DownloadServerRequest.getJsonObjectAsync("https://dl.labymod.net/latest/install/updater/hash.json", new ServerResponse<JsonElement>(){

            @Override
            public void success(JsonElement result) {
                String hash = result.getAsJsonObject().get("updater").getAsString();
                future.complete(hash);
            }

            @Override
            public void failed(RequestException exception) {
                exception.printStackTrace();
                future.complete(null);
            }
        });
        return future;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public UpdateData getCoreUpdate() {
        return this.coreUpdate;
    }

    public UpdateData[] getAddonUpdates() {
        return this.addonUpdates;
    }

    public int getAddonUpdateCount() {
        return this.addonUpdateCount;
    }

    public LabyModUpdateChecker getLabyModUpdateChecker() {
        return this.labyModUpdateChecker;
    }

    public AddonUpdateChecker getAddonUpdateChecker() {
        return this.addonUpdateChecker;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public boolean isBackupMethod() {
        return this.backupMethod;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    public void setBackupMethod(boolean backupMethod) {
        this.backupMethod = backupMethod;
    }
}

