/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.main.update;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.labymod.addon.AddonLoader;
import net.labymod.addon.online.AddonInfoManager;
import net.labymod.addon.online.info.AddonInfo;
import net.labymod.addon.online.info.OnlineAddonInfo;
import net.labymod.main.update.UpdateData;
import net.labymod.support.util.Debug;

public class AddonUpdateChecker {
    private static final JsonParser PARSER = new JsonParser();

    public CompletableFuture<UpdateData[]> getAddonUpdateData() {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, File> addons = new HashMap<String, File>();
            try {
                this.findOnlineAddons(AddonLoader.getAddonsDirectory(), addons);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            if (addons.isEmpty()) {
                return new UpdateData[0];
            }
            ArrayList<UpdateData> result = new ArrayList<UpdateData>();
            for (Map.Entry entry : addons.entrySet()) {
                String requiredHash;
                OnlineAddonInfo info = this.getAddonInfo((String)entry.getKey());
                if (info == null || (requiredHash = info.getHash()) == null || requiredHash.isEmpty()) continue;
                String hash = null;
                try {
                    hash = AddonLoader.getCheckSum((File)entry.getValue());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (hash == null || requiredHash.equalsIgnoreCase(hash)) continue;
                result.add(new UpdateData(String.valueOf(info.getVersion()), new short[]{(short)info.getVersion()}, true));
                Debug.log(Debug.EnumDebugMode.ADDON, info.getName() + ": " + hash + " != " + requiredHash);
            }
            return result.toArray(new UpdateData[0]);
        });
    }

    private OnlineAddonInfo getAddonInfo(String uuid) {
        AddonInfoManager.getInstance().init();
        AddonInfo info = AddonInfoManager.getInstance().getAddonInfoMap().get(UUID.fromString(uuid));
        if (!(info instanceof OnlineAddonInfo)) {
            return null;
        }
        return (OnlineAddonInfo)info;
    }

    private void findOnlineAddons(File directory, Map<String, File> target) throws IOException {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory() || file.getName().equals("debug.jar")) continue;
            Debug.log(Debug.EnumDebugMode.ADDON, "Check " + file.getName());
            try (JarFile jarFile = new JarFile(file);){
                JarEntry entry = jarFile.getJarEntry("addon.json");
                if (entry == null) continue;
                try (InputStreamReader reader = new InputStreamReader(jarFile.getInputStream(entry), StandardCharsets.UTF_8);){
                    String uuid;
                    JsonElement uuidElement;
                    JsonElement element = PARSER.parse((Reader)reader);
                    if (!element.isJsonObject() || !(uuidElement = element.getAsJsonObject().get("uuid")).isJsonPrimitive() || (uuid = uuidElement.getAsString()).equals("%uuid%") || element.getAsJsonObject().has("debug")) continue;
                    target.put(uuid, file);
                }
            }
        }
    }
}

