/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.main.listeners;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import net.labymod.api.events.MessageSendEvent;
import net.labymod.api.events.ServerMessageEvent;
import net.labymod.gui.GuiSwitchServer;
import net.labymod.main.LabyMod;
import net.labymod.support.util.Debug;
import net.labymod.utils.Consumer;
import net.labymod.utils.ModUtils;
import net.labymod.utils.ServerData;

public class ServerSwitchListener
implements ServerMessageEvent,
Consumer<ServerData>,
GuiSwitchServer.Result,
MessageSendEvent {
    private LabyMod labymod;
    private String destinationAddressToTrust;
    private boolean sessionTrusted = false;

    public ServerSwitchListener(LabyMod labymod) {
        this.labymod = labymod;
    }

    @Override
    public void onServerMessage(String messageKey, JsonElement serverMessage) {
        JsonObject obj;
        if (messageKey.equals("server_switch") && (obj = serverMessage.getAsJsonObject()).has("title") && obj.has("address")) {
            boolean preview;
            final String title = obj.get("title").getAsString();
            final String address = obj.get("address").getAsString();
            boolean bl = preview = obj.has("preview") && obj.get("preview").getAsBoolean();
            if (this.labymod.getCurrentServerData() != null && !LabyMod.isForge()) {
                if (this.sessionTrusted) {
                    ave.A().a(new Runnable(){

                        @Override
                        public void run() {
                            ServerSwitchListener.this.notifyServer(address, true, true);
                            ServerSwitchListener.this.labymod.switchServer(address, true);
                        }
                    });
                    return;
                }
                List<String> list = Arrays.asList(LabyMod.getSettings().trustedServers);
                if (list.contains(ModUtils.getProfileNameByIp(this.labymod.getCurrentServerData().getIp()))) {
                    ave.A().a(new Runnable(){

                        @Override
                        public void run() {
                            ServerSwitchListener.this.notifyServer(address, true, true);
                            ServerSwitchListener.this.labymod.switchServer(address, true);
                        }
                    });
                    return;
                }
            }
            ave.A().a(new Runnable(){

                @Override
                public void run() {
                    ave.A().a((axu)new GuiSwitchServer(title, address, preview, ServerSwitchListener.this));
                }
            });
        }
    }

    @Override
    public void notifyServer(String address, boolean accepted, boolean trusted) {
        if (accepted) {
            this.destinationAddressToTrust = address;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("address", address);
        jsonObject.addProperty("accepted", Boolean.valueOf(accepted));
        this.labymod.getLabyModAPI().sendJsonMessageToServer("server_switch", (JsonElement)jsonObject);
    }

    @Override
    public void accept(ServerData accepted) {
        if (accepted == null) {
            return;
        }
        if (this.destinationAddressToTrust != null && accepted.getIp().equalsIgnoreCase(this.destinationAddressToTrust)) {
            this.sessionTrusted = true;
        } else {
            this.sessionTrusted = false;
            this.destinationAddressToTrust = null;
        }
    }

    @Override
    public boolean onSend(String msg) {
        if (Debug.isActive() && msg.startsWith("/connect") && msg.contains(" ")) {
            String ip2 = msg.split(" ")[1];
            new Thread(() -> {
                try {
                    Thread.sleep(10L);
                    ave.A().a(() -> {
                        JsonObject object = new JsonObject();
                        object.addProperty("title", "LabyMod Server Switcher");
                        object.addProperty("address", ip2);
                        object.addProperty("preview", Boolean.valueOf(true));
                        this.onServerMessage("server_switch", (JsonElement)object);
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
            return true;
        }
        return false;
    }
}

