/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.main.listeners;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.labymod.api.events.RenderIngameOverlayEvent;
import net.labymod.api.events.ServerMessageEvent;
import net.labymod.api.permissions.Permissions;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.Economy;
import net.labymod.utils.ModColor;

public class RenderIngamePostOverlayListener
implements ServerMessageEvent,
RenderIngameOverlayEvent {
    private Economy cash = new Economy();
    private Economy bank = new Economy();
    private boolean watermarkVisible = false;
    private long watermarkValidTime = 0L;
    private int csPrevCoverage = 0;
    private int csCoverage = 20;
    private long csDuration = 1000L;
    private long csLastChanged = 0L;
    private Map<UUID, jy> languageFlags = new HashMap<UUID, jy>();
    private boolean labyOnlyServer = false;
    private String serverBanner = null;

    @Override
    public void onRender(float partialTicks) {
        bfl.E();
        bfl.b((float)0.0f, (float)0.0f, (float)10.0f);
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        LabyMod.getInstance().getMarkerManager().renderOverlay(partialTicks);
        if (this.cash.isVisible()) {
            bfl.E();
            ave.A().P().a(this.cash.getIcon(ModTextures.MISC_ECONOMY_CASH));
            draw.drawTexture(draw.getWidth() - 17, 8.5, 255.0, 255.0, 14.0, 14.0);
            draw.drawRightString(this.cash.getDisplayValue(), draw.getWidth() - 20, 10.0, 1.5);
            bfl.F();
        }
        if (this.bank.isVisible()) {
            bfl.E();
            ave.A().P().a(this.bank.getIcon(ModTextures.MISC_ECONOMY_BANK));
            draw.drawTexture(draw.getWidth() - 17, 8.5f + (float)(this.cash.isVisible() ? 17 : 0), 255.0, 255.0, 14.0, 14.0);
            draw.drawRightString(this.bank.getDisplayValue(), draw.getWidth() - 20, 10 + (this.cash.isVisible() ? 17 : 0), 1.5);
            bfl.F();
        }
        if (this.watermarkVisible && !(ave.A().m instanceof awv)) {
            bfl.E();
            ave.A().P().a(ModTextures.TITLE_LABYMOD_BANNER_WATERMARK);
            draw.drawTexture(draw.getWidth() - 100 - 2, draw.getHeight() - 20 - 2, 255.0, 255.0, 100.0, 20.0);
            bfl.F();
        }
        if (this.isCineScopeActive()) {
            long timePassed = System.currentTimeMillis() - this.csLastChanged;
            double x = 10.0 / (double)this.csDuration * (double)Math.min(this.csDuration, timePassed) - 5.0;
            double y = 1.0 / (1.0 + Math.exp(-x));
            double difference = this.csCoverage - this.csPrevCoverage;
            double cineScopeProgress = (double)this.csPrevCoverage + difference * y;
            double cineScopeHeight = (double)draw.getHeight() / 100.0 * (cineScopeProgress * 1.01);
            draw.drawRect(0.0, 0.0, draw.getWidth(), cineScopeHeight, ModColor.BLACK.getColor().getRGB());
            draw.drawRect(0.0, (double)draw.getHeight() - cineScopeHeight, draw.getWidth(), draw.getHeight(), ModColor.BLACK.getColor().getRGB());
        }
        LabyMod.getInstance().getGuiCustomAchievement().updateAchievementWindow();
        Permissions.getPermissionNotifyRenderer().render(draw.getWidth());
        bfl.b((float)0.0f, (float)0.0f, (float)-10.0f);
        bfl.F();
    }

    @Override
    public void onServerMessage(String messageKey, JsonElement serverMessage) {
        JsonObject obj;
        if (messageKey.equals("economy")) {
            JsonObject economy = serverMessage.getAsJsonObject();
            this.cash.update(economy, "cash");
            this.bank.update(economy, "bank");
        }
        if (messageKey.equals("watermark") && (obj = serverMessage.getAsJsonObject()).has("visible")) {
            this.watermarkVisible = obj.get("visible").getAsBoolean();
            this.watermarkValidTime = System.currentTimeMillis() + 10000L;
        }
        if (messageKey.equals("cinescopes")) {
            obj = serverMessage.getAsJsonObject();
            if (obj.has("coverage")) {
                this.csLastChanged = System.currentTimeMillis();
                this.csPrevCoverage = this.csCoverage;
                this.csCoverage = obj.get("coverage").getAsInt();
                this.csCoverage = Math.min(50, this.csCoverage);
                this.csCoverage = Math.max(0, this.csCoverage);
            }
            if (obj.has("duration")) {
                this.csDuration = obj.get("duration").getAsLong();
                this.csDuration = Math.min(10000L, this.csDuration);
                this.csDuration = Math.max(10L, this.csDuration);
            }
        }
        if (messageKey.equals("language_flag") && (obj = serverMessage.getAsJsonObject()).has("users")) {
            JsonArray array = obj.get("users").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject userEntry = array.get(i).getAsJsonObject();
                if (!userEntry.has("uuid") || !userEntry.has("code")) continue;
                UUID uuid = UUID.fromString(userEntry.get("uuid").getAsString());
                String code = userEntry.get("code").getAsString().toLowerCase();
                if (code.contains(".") || code.contains("/") || code.contains("\\")) continue;
                this.languageFlags.put(uuid, new jy(String.format("labymod/textures/flags/%s.png", code)));
            }
        }
        if (messageKey.equals("server_banner")) {
            obj = serverMessage.getAsJsonObject();
            String string = this.serverBanner = obj.has("url") ? obj.get("url").getAsString() : null;
        }
        if (messageKey.equals("laby_only_server") && (obj = serverMessage.getAsJsonObject()).has("enabled")) {
            this.labyOnlyServer = obj.get("enabled").getAsBoolean();
        }
    }

    public void reset() {
        this.csCoverage = 0;
        this.csDuration = 1000L;
        this.csLastChanged = -1L;
        this.watermarkVisible = false;
        this.bank.reset();
        this.cash.reset();
        this.languageFlags.clear();
        this.labyOnlyServer = false;
        this.serverBanner = null;
    }

    public boolean isWatermarkValid() {
        return this.watermarkVisible || System.currentTimeMillis() < this.watermarkValidTime;
    }

    public boolean isCineScopeActive() {
        return this.csCoverage != 0 || System.currentTimeMillis() < this.csLastChanged + this.csDuration;
    }

    public boolean isLabyOnlyServer() {
        return this.labyOnlyServer;
    }

    public jy getFlagFor(UUID uuid) {
        return this.languageFlags.get(uuid);
    }

    public Map<UUID, jy> getLanguageFlags() {
        return this.languageFlags;
    }

    public String getServerBanner() {
        return this.serverBanner;
    }

    public boolean hasServerBanner() {
        return (this.serverBanner != null || this.labyOnlyServer) && LabyMod.getSettings().serverBanner;
    }
}

