/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.main.listeners;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.labymod.addon.AddonLoader;
import net.labymod.addon.online.AddonInfoManager;
import net.labymod.api.events.ServerMessageEvent;
import net.labymod.gui.GuiAddonRecommendation;
import net.labymod.main.LabyMod;
import net.labymod.servermanager.group.ServerGroup;
import net.labymod.utils.Consumer;
import net.labymod.utils.ModUtils;
import net.labymod.utils.ServerData;

public class AddonRecommendationListener
implements ServerMessageEvent,
Consumer<ServerData> {
    private LabyMod labymod;

    public AddonRecommendationListener(LabyMod labymod) {
        this.labymod = labymod;
    }

    @Override
    public void accept(ServerData serverData) {
        ServerGroup group = LabyMod.getInstance().getServerGroupProvider().detectGroup(serverData);
        if (group == null || group.getAddons() == null) {
            return;
        }
        this.loadRecommendedAddons(group.getDisplayName(), group.getAddons(), false);
    }

    private void loadRecommendedAddons(String serverName, JsonArray array, boolean notifyServer) {
        ArrayList<GuiAddonRecommendation.RecommendedAddon> addons = new ArrayList<GuiAddonRecommendation.RecommendedAddon>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject addonObject = array.get(i).getAsJsonObject();
            UUID uuid = UUID.fromString(addonObject.get("uuid").getAsString());
            boolean required = addonObject.get("required").getAsBoolean();
            GuiAddonRecommendation.RecommendedAddon addon = new GuiAddonRecommendation.RecommendedAddon(uuid, required, null);
            addons.add(addon);
        }
        this.loadRecommendedAddons(serverName, addons, notifyServer);
    }

    private void loadRecommendedAddons(String serverName, List<GuiAddonRecommendation.RecommendedAddon> addons, boolean notifyServer) {
        List<String> list;
        for (GuiAddonRecommendation.RecommendedAddon addon : addons) {
            addon.bindAddon(AddonInfoManager.getInstance());
        }
        if (!addons.isEmpty() && this.labymod.getCurrentServerData() != null && (list = Arrays.asList(LabyMod.getSettings().ignoredAddonRecommendationServers)).contains(ModUtils.getProfileNameByIp(this.labymod.getCurrentServerData().getIp()))) {
            if (notifyServer) {
                AddonRecommendationListener.sendMissingStatus(addons, true);
            }
            return;
        }
        this.openGui(serverName, addons, notifyServer);
    }

    @Override
    public void onServerMessage(String messageKey, JsonElement serverMessage) {
        if (!serverMessage.isJsonObject()) {
            return;
        }
        JsonObject obj = serverMessage.getAsJsonObject();
        if (messageKey.equals("addon_recommendation") && obj.has("addons")) {
            String serverName = null;
            if (obj.has("server_name")) {
                serverName = obj.get("server_name").getAsString();
            }
            this.loadRecommendedAddons(serverName, obj.getAsJsonArray("addons"), true);
        }
    }

    private void openGui(String serverName, List<GuiAddonRecommendation.RecommendedAddon> addons, boolean notifyServer) {
        AddonInfoManager manager = AddonInfoManager.getInstance();
        manager.init();
        if (AddonRecommendationListener.sendMissingStatus(addons, false)) {
            ave.A().a(() -> ave.A().a((axu)new GuiAddonRecommendation(serverName, addons, notifyServer)));
        }
    }

    public static boolean sendMissingStatus(List<GuiAddonRecommendation.RecommendedAddon> addons, boolean isGuiClosed) {
        AddonInfoManager manager = AddonInfoManager.getInstance();
        JsonArray missingArray = new JsonArray();
        boolean addonIsMissing = false;
        for (GuiAddonRecommendation.RecommendedAddon addon : addons) {
            addon.bindAddon(manager);
            if (addon.getOnlineAddonInfo() == null || AddonLoader.hasInstalled(addon.getOnlineAddonInfo())) continue;
            addonIsMissing = true;
            JsonObject addonObject = new JsonObject();
            addonObject.addProperty("uuid", addon.getUuid().toString());
            addonObject.addProperty("name", addon.getOnlineAddonInfo().getName());
            missingArray.add((JsonElement)addonObject);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("gui_closed", Boolean.valueOf(isGuiClosed));
        jsonObject.addProperty("all_installed", Boolean.valueOf(!addonIsMissing));
        if (addonIsMissing) {
            jsonObject.add("missing", (JsonElement)missingArray);
        }
        LabyMod.getInstance().getLabyModAPI().sendJsonMessageToServer("addon_recommendation", (JsonElement)jsonObject);
        return addonIsMissing;
    }
}

