/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.main;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class QuickInstaller {
    public static Attributes.Name MC_VERSION = new Attributes.Name("MC-VERSION");

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Manifest manifest = QuickInstaller.getManifest(QuickInstaller.class);
            String mcVersion = (String)manifest.getMainAttributes().get(MC_VERSION);
            if (mcVersion == null) {
                JOptionPane.showMessageDialog(null, "Can't find mc version in METAINF", "Quick Installer", 0);
                return;
            }
            File minecraftDirectory = QuickInstaller.getWorkingDirectory();
            File destination = new File(minecraftDirectory, "libraries/net/labymod/LabyMod/3_" + mcVersion + "/LabyMod-3_" + mcVersion + ".jar");
            File source = new File(QuickInstaller.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            Files.copy(source.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            JOptionPane.showMessageDialog(null, "Installed successfully!", "Quick Installer", 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Quick Installer", 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Manifest getManifest(Class<?> clz) {
        String resource = "/" + clz.getName().replace(".", "/") + ".class";
        String fullPath = clz.getResource(resource).toString();
        String archivePath = fullPath.substring(0, fullPath.length() - resource.length());
        if (archivePath.endsWith("\\WEB-INF\\classes") || archivePath.endsWith("/WEB-INF/classes")) {
            archivePath = archivePath.substring(0, archivePath.length() - "/WEB-INF/classes".length());
        }
        try (InputStream input = new URL(archivePath + "/META-INF/MANIFEST.MF").openStream();){
            Manifest manifest = new Manifest(input);
            return manifest;
        }
        catch (Exception e) {
            throw new RuntimeException("Loading MANIFEST for class " + clz + " failed!", e);
        }
    }

    public static File getWorkingDirectory() {
        return QuickInstaller.getWorkingDirectory("minecraft");
    }

    public static File getWorkingDirectory(String applicationName) {
        String userHome = System.getProperty("user.home", ".");
        File workingDirectory = null;
        switch (QuickInstaller.getPlatform()) {
            case LINUX: {
                workingDirectory = new File(userHome, '.' + applicationName + '/');
                break;
            }
            case UNKNOWN: {
                workingDirectory = new File(userHome, "Library/Application Support/" + applicationName);
                break;
            }
            case WINDOWS: {
                String applicationData = System.getenv("APPDATA");
                if (applicationData != null) {
                    workingDirectory = new File(applicationData, "." + applicationName + '/');
                    break;
                }
                workingDirectory = new File(userHome, '.' + applicationName + '/');
                break;
            }
            case MACOS: {
                workingDirectory = new File(userHome, "Library/Application Support/" + applicationName);
                break;
            }
            case SOLARIS: {
                String applicationDataW = System.getenv("APPDATA");
                if (applicationDataW != null) {
                    workingDirectory = new File(applicationDataW, "." + applicationName + '/');
                    break;
                }
                workingDirectory = new File(userHome, '.' + applicationName + '/');
                break;
            }
            default: {
                workingDirectory = new File(userHome, applicationName + '/');
            }
        }
        if (!workingDirectory.exists() && !workingDirectory.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + workingDirectory);
        }
        return workingDirectory;
    }

    public static OS getPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        for (OS os : OS.values()) {
            if (os == OS.UNKNOWN) continue;
            for (String name : os.getOsNames()) {
                if (!osName.contains(name)) continue;
                return os;
            }
        }
        return OS.UNKNOWN;
    }

    public static enum OS {
        LINUX("linux", "unix"),
        SOLARIS("solaris", "sunos"),
        WINDOWS("win"),
        MACOS("mac"),
        UNKNOWN(new String[0]);

        private String[] osNames;

        private OS(String ... osNames) {
            this.osNames = osNames;
        }

        public String[] getOsNames() {
            return this.osNames;
        }
    }
}

