/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.labyplay.gui.elements;

import java.util.List;
import java.util.UUID;
import net.labymod.gui.elements.GuiTextboxPrompt;
import net.labymod.gui.elements.SmallDropDownMenu;
import net.labymod.gui.layout.WindowElement;
import net.labymod.labyplay.gui.GuiPlayLayout;
import net.labymod.labyplay.party.model.PartyMember;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.labymod.utils.manager.TooltipHelper;

public class WinCurrentParty
extends WindowElement<GuiPlayLayout> {
    private PartyMember hoverMember = null;
    private PartyMember dropDownMember = null;
    private SmallDropDownMenu dropDown = null;

    public WinCurrentParty(GuiPlayLayout layout) {
        super(layout);
    }

    @Override
    protected void init(List<avs> buttonlist, int left, int top, int right, int bottom) {
        int padding = 6;
        int space = 2;
        String invitePlayer = "Invite player";
        int invitePlayerWidth = this.draw.getStringWidth(invitePlayer) + padding;
        buttonlist.add(new avs(1, left, bottom - 20, invitePlayerWidth, 20, invitePlayer));
        String leave = "Leave";
        int leaveWidth = this.draw.getStringWidth(leave) + padding;
        buttonlist.add(new avs(2, left + invitePlayerWidth + space, bottom - 20, leaveWidth, 20, leave));
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        super.draw(mouseX, mouseY);
        int paddingX = 2;
        int paddingY = 4;
        int posX = this.left + paddingX;
        int posY = this.top + paddingY + 14;
        int headSize = 18;
        int space = 3;
        this.draw.drawString("Party", this.left + paddingX, this.top + paddingY);
        this.hoverMember = null;
        for (PartyMember member : ((GuiPlayLayout)this.layout).getPartySystem().getMembers()) {
            if (!this.drawMember(member, posX, posY, mouseX, mouseY, headSize)) continue;
            posX += headSize + space;
        }
        if (this.dropDown != null) {
            this.dropDown.renderButton(mouseX, mouseY);
        }
    }

    private boolean drawMember(PartyMember member, int posX, int posY, int mouseX, int mouseY, int headSize) {
        boolean hover = mouseX > posX && mouseX < posX + headSize && mouseY > posY && mouseY < posY + headSize;
        LabyMod.getInstance().getDrawUtils().drawPlayerHead(member.getUuid(), posX, posY, headSize);
        if (!member.isMember()) {
            long inviteAliveDuration = System.currentTimeMillis() - member.getTimestamp();
            if (inviteAliveDuration > 60000L) {
                return false;
            }
            double progress = (double)headSize / 60000.0 * (double)(60000L - inviteAliveDuration);
            DrawUtils.a((int)posX, (int)posY, (int)(posX + headSize), (int)(posY + headSize), (int)ModColor.toRGB(0, 0, 0, 200));
            DrawUtils.a((int)posX, (int)(posY + headSize - 1), (int)(posX + headSize), (int)(posY + headSize), (int)ModColor.toRGB(0, 0, 0, 200));
            this.draw.drawRect(posX, posY + headSize - 1, (double)posX + progress, posY + headSize, ModColor.toRGB(100, 200, 100, 200));
        }
        if (member.isOwner()) {
            int crownSize = 10;
            ave.A().P().a(ModTextures.MISC_CROWN);
            this.draw.drawTexture(posX, posY - crownSize / 2 - 1, 255.0, 255.0, crownSize, crownSize);
        }
        if (hover && this.dropDown == null) {
            TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, member.getName());
            this.hoverMember = member;
        }
        return true;
    }

    @Override
    public void actionPerformed(avs button) {
        if (button.k == 1) {
            ave.A().a((axu)new GuiTextboxPrompt(ave.A().m, "Player to invite:", "Invite", "Cancel", "", new Consumer<String>(){

                @Override
                public void accept(String username) {
                    if (!username.isEmpty()) {
                        ((GuiPlayLayout)WinCurrentParty.this.layout).getPartySystem().invitePlayer(username);
                    }
                }
            }));
        }
        if (button.k == 2) {
            ((GuiPlayLayout)this.layout).getPartySystem().leaveParty();
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.dropDown != null && this.dropDownMember != null) {
            int result = this.dropDown.onClick(mouseX, mouseY);
            if (((GuiPlayLayout)this.layout).getPartySystem().hasParty()) {
                UUID targetUUID = this.dropDownMember.getUuid();
                switch (result) {
                    case 0: {
                        ((GuiPlayLayout)this.layout).getPartySystem().kickPlayer(targetUUID);
                        break;
                    }
                    case 1: {
                        ((GuiPlayLayout)this.layout).getPartySystem().changeOwner(targetUUID);
                    }
                }
            }
            this.dropDown = null;
            this.dropDownMember = null;
        }
        if (this.hoverMember != null && this.dropDown == null && mouseButton == 1) {
            PartyMember clientMember = ((GuiPlayLayout)this.layout).getPartySystem().getClientMember();
            boolean isPartyOwner = clientMember.isOwner();
            boolean isClientMember = this.hoverMember.getUuid().equals(clientMember.getUuid());
            if (isPartyOwner && !isClientMember) {
                this.dropDown = new SmallDropDownMenu(mouseX, mouseY, 0, 0);
                this.dropDown.addDropDownEntry((Object)((Object)ModColor.RED) + "Kick " + this.hoverMember.getName());
                this.dropDown.addDropDownEntry((Object)((Object)ModColor.AQUA) + "Make party leader");
                this.dropDown.setMinecraftStyle(false);
                this.dropDown.setOpen(true);
                this.dropDown.setDropDownX(mouseX);
                this.dropDown.setDropDownY(mouseY - this.dropDown.getMaxY());
                this.dropDownMember = this.hoverMember;
            }
        }
        return false;
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY) {
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void mouseInput() {
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
    }

    @Override
    public void updateScreen() {
    }
}

