/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.labyconnect;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.labymod.main.Source;

public class PinManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private Map<UUID, Pin> pins = new HashMap<UUID, Pin>();

    private PinManager() {
    }

    public void invalidatePinOf(UUID uuid) {
        this.pins.remove(uuid);
    }

    public void update(UUID uuid, String pin, long expiresAt) {
        this.pins.put(uuid, new Pin(pin, expiresAt));
        try {
            FileWriter writer = new FileWriter(Source.FILE_PINS);
            GSON.toJson((Object)this, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean hasValidPin(UUID uuid) {
        return this.getValidPinOf(uuid) != null;
    }

    public String getValidPinOf(UUID uuid) {
        Pin pin = this.pins.get(uuid);
        return pin == null || pin.isExpired() ? null : pin.getPin();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PinManager load() {
        if (!Source.FILE_PINS.exists()) return new PinManager();
        try (JsonReader reader = new JsonReader((Reader)new FileReader(Source.FILE_PINS));){
            PinManager pinManager = (PinManager)GSON.fromJson(reader, PinManager.class);
            return pinManager;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new PinManager();
    }

    public static class Pin {
        private final String pin;
        private final long expiresAt;

        public Pin(String pin, long expiresAt) {
            this.pin = pin;
            this.expiresAt = expiresAt;
        }

        public String getPin() {
            return this.pin;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expiresAt;
        }
    }
}

