/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.labyconnect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.labymod.core.LabyModCore;
import net.labymod.labyconnect.LabyConnect;
import net.labymod.labyconnect.packets.PacketUserTracker;

public class LabyConnectUserTracker {
    private static final long LIST_UPDATE_INTERVAL = 10000L;
    private static final long ENTITY_UPDATE_INTERVAL = 3000L;
    private final LabyConnect labyConnect;
    private final Map<PacketUserTracker.EnumTrackingAction, List<PacketUserTracker.PlayerEntityMeta>> listBuffer = new HashMap<PacketUserTracker.EnumTrackingAction, List<PacketUserTracker.PlayerEntityMeta>>();
    private final Map<PacketUserTracker.EnumTrackingAction, List<PacketUserTracker.PlayerEntityMeta>> entityBuffer = new HashMap<PacketUserTracker.EnumTrackingAction, List<PacketUserTracker.PlayerEntityMeta>>();
    private long nextTimeDrainList = -1L;
    private long nextTimeDrainEntities = -1L;
    private boolean empty = true;

    public LabyConnectUserTracker(LabyConnect labyConnect) {
        this.labyConnect = labyConnect;
        for (PacketUserTracker.EnumTrackingAction action : PacketUserTracker.EnumTrackingAction.values()) {
            this.listBuffer.put(action, new ArrayList());
            this.entityBuffer.put(action, new ArrayList());
        }
    }

    public void onLoadWorld() {
        this.clearBuffers();
    }

    public void onDisconnectServer() {
        this.clearBuffers();
    }

    public void onLabyConnectConnect() {
        bdb world;
        this.clearBuffers();
        bcy connection = LabyModCore.getMinecraft().getConnection();
        if (connection != null) {
            for (bdc playerInfo : connection.d()) {
                if (!this.isPlayerInfoValid(playerInfo)) continue;
                this.listBuffer.get((Object)PacketUserTracker.EnumTrackingAction.ADD).add(new PacketUserTracker.PlayerEntityMeta(playerInfo.a()));
                this.empty = false;
            }
        }
        if ((world = LabyModCore.getMinecraft().getWorld()) != null) {
            for (wn player : world.j) {
                this.entityBuffer.get((Object)PacketUserTracker.EnumTrackingAction.ADD).add(new PacketUserTracker.PlayerEntityMeta(player.aK()));
                this.empty = false;
            }
        }
    }

    public void onGameTick() {
        if (!this.labyConnect.isOnline()) {
            return;
        }
        if (this.nextTimeDrainList < System.currentTimeMillis() || this.listBuffer.get((Object)PacketUserTracker.EnumTrackingAction.ADD).size() > 10) {
            this.nextTimeDrainList = System.currentTimeMillis() + 10000L;
            this.drain(PacketUserTracker.EnumTrackingChannel.LIST, this.listBuffer);
        }
        if (this.nextTimeDrainEntities < System.currentTimeMillis() || this.entityBuffer.get((Object)PacketUserTracker.EnumTrackingAction.ADD).size() > 10) {
            this.nextTimeDrainEntities = System.currentTimeMillis() + 3000L;
            this.drain(PacketUserTracker.EnumTrackingChannel.ENTITIES, this.entityBuffer);
        }
    }

    private void drain(PacketUserTracker.EnumTrackingChannel channel, Map<PacketUserTracker.EnumTrackingAction, List<PacketUserTracker.PlayerEntityMeta>> map) {
        for (Map.Entry<PacketUserTracker.EnumTrackingAction, List<PacketUserTracker.PlayerEntityMeta>> entry : map.entrySet()) {
            List<PacketUserTracker.PlayerEntityMeta> buffer = entry.getValue();
            if (buffer.isEmpty()) continue;
            this.labyConnect.getClientConnection().sendPacket(new PacketUserTracker(channel, entry.getKey(), buffer.toArray(new PacketUserTracker.PlayerEntityMeta[0])));
            buffer.clear();
        }
    }

    public void onPlayerInfoAdd(bdc playerInfo) {
        if (this.isPlayerInfoValid(playerInfo)) {
            this.update(this.listBuffer, new PacketUserTracker.PlayerEntityMeta(playerInfo.a()), PacketUserTracker.EnumTrackingAction.REMOVE, PacketUserTracker.EnumTrackingAction.ADD, true);
        }
    }

    public void onPlayerInfoRemove(UUID uniqueId) {
        if (this.isUniqueIdValid(uniqueId)) {
            this.update(this.listBuffer, new PacketUserTracker.PlayerEntityMeta(uniqueId), PacketUserTracker.EnumTrackingAction.ADD, PacketUserTracker.EnumTrackingAction.REMOVE, false);
        }
    }

    public void onVisiblePlayer(UUID uniqueId) {
        if (this.isUniqueIdValid(uniqueId)) {
            this.update(this.entityBuffer, new PacketUserTracker.PlayerEntityMeta(uniqueId), PacketUserTracker.EnumTrackingAction.REMOVE, PacketUserTracker.EnumTrackingAction.ADD, true);
        }
    }

    public void onEntityDestruct(UUID uniqueId) {
        if (this.isUniqueIdValid(uniqueId)) {
            this.update(this.entityBuffer, new PacketUserTracker.PlayerEntityMeta(uniqueId), PacketUserTracker.EnumTrackingAction.ADD, PacketUserTracker.EnumTrackingAction.REMOVE, false);
        }
    }

    private void update(Map<PacketUserTracker.EnumTrackingAction, List<PacketUserTracker.PlayerEntityMeta>> buffers, PacketUserTracker.PlayerEntityMeta uniqueId, PacketUserTracker.EnumTrackingAction cleanTarget, PacketUserTracker.EnumTrackingAction actionTarget, boolean forceAdd) {
        List<PacketUserTracker.PlayerEntityMeta> target;
        if (!this.labyConnect.isOnline()) {
            return;
        }
        List<PacketUserTracker.PlayerEntityMeta> buffer = buffers.get((Object)cleanTarget);
        if (buffer.contains(uniqueId)) {
            buffer.remove(uniqueId);
            if (!forceAdd) {
                return;
            }
        }
        if (!(target = buffers.get((Object)actionTarget)).contains(uniqueId)) {
            target.add(uniqueId);
        }
        this.empty = false;
    }

    private void clearBuffers() {
        for (List<PacketUserTracker.PlayerEntityMeta> buffer : this.listBuffer.values()) {
            buffer.clear();
        }
        for (List<PacketUserTracker.PlayerEntityMeta> buffer : this.entityBuffer.values()) {
            buffer.clear();
        }
        if (this.labyConnect.isOnline() && !this.empty) {
            this.labyConnect.getClientConnection().sendPacket(new PacketUserTracker(PacketUserTracker.EnumTrackingChannel.LIST, PacketUserTracker.EnumTrackingAction.CLEAR));
            this.labyConnect.getClientConnection().sendPacket(new PacketUserTracker(PacketUserTracker.EnumTrackingChannel.ENTITIES, PacketUserTracker.EnumTrackingAction.CLEAR));
        }
        this.empty = true;
    }

    private boolean isPlayerInfoValid(bdc playerInfo) {
        UUID uuid = playerInfo.a().getId();
        return this.isUniqueIdValid(uuid);
    }

    private boolean isUniqueIdValid(UUID uniqueId) {
        if (uniqueId.getMostSignificantBits() == 0L || uniqueId.getLeastSignificantBits() == 0L) {
            return false;
        }
        return (uniqueId.getMostSignificantBits() >> 12 & 0xFL) == 4L;
    }
}

