/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.labyconnect;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.sun.management.OperatingSystemMXBean;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.concurrent.GenericFutureListener;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import java.net.Proxy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.UnresolvedAddressException;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import net.labymod.addon.AddonLoader;
import net.labymod.addon.ForgeModsScanner;
import net.labymod.api.LabyModAddon;
import net.labymod.core.asm.LabyModCoreMod;
import net.labymod.gui.GuiLabyNet;
import net.labymod.labyconnect.ClientChannelInitializer;
import net.labymod.labyconnect.GameIconHelper;
import net.labymod.labyconnect.IssueCollector;
import net.labymod.labyconnect.LabyConnect;
import net.labymod.labyconnect.gui.GuiFriendsAddFriend;
import net.labymod.labyconnect.gui.GuiFriendsLayout;
import net.labymod.labyconnect.handling.PacketEncryptingDecoder;
import net.labymod.labyconnect.handling.PacketEncryptingEncoder;
import net.labymod.labyconnect.handling.PacketHandler;
import net.labymod.labyconnect.log.MessageChatComponent;
import net.labymod.labyconnect.log.SingleChat;
import net.labymod.labyconnect.packets.CryptManager;
import net.labymod.labyconnect.packets.EnumConnectionState;
import net.labymod.labyconnect.packets.Packet;
import net.labymod.labyconnect.packets.PacketActionBroadcast;
import net.labymod.labyconnect.packets.PacketAddonMessage;
import net.labymod.labyconnect.packets.PacketChatVisibilityChange;
import net.labymod.labyconnect.packets.PacketDisconnect;
import net.labymod.labyconnect.packets.PacketEncryptionRequest;
import net.labymod.labyconnect.packets.PacketEncryptionResponse;
import net.labymod.labyconnect.packets.PacketHelloPing;
import net.labymod.labyconnect.packets.PacketHelloPong;
import net.labymod.labyconnect.packets.PacketKick;
import net.labymod.labyconnect.packets.PacketLoginComplete;
import net.labymod.labyconnect.packets.PacketLoginData;
import net.labymod.labyconnect.packets.PacketLoginFriend;
import net.labymod.labyconnect.packets.PacketLoginOptions;
import net.labymod.labyconnect.packets.PacketLoginRequest;
import net.labymod.labyconnect.packets.PacketLoginTime;
import net.labymod.labyconnect.packets.PacketLoginVersion;
import net.labymod.labyconnect.packets.PacketMessage;
import net.labymod.labyconnect.packets.PacketMojangStatus;
import net.labymod.labyconnect.packets.PacketNotAllowed;
import net.labymod.labyconnect.packets.PacketPing;
import net.labymod.labyconnect.packets.PacketPlayChangeOptions;
import net.labymod.labyconnect.packets.PacketPlayDenyFriendRequest;
import net.labymod.labyconnect.packets.PacketPlayFriendPlayingOn;
import net.labymod.labyconnect.packets.PacketPlayFriendRemove;
import net.labymod.labyconnect.packets.PacketPlayFriendStatus;
import net.labymod.labyconnect.packets.PacketPlayPlayerOnline;
import net.labymod.labyconnect.packets.PacketPlayRequestAddFriend;
import net.labymod.labyconnect.packets.PacketPlayRequestAddFriendResponse;
import net.labymod.labyconnect.packets.PacketPlayRequestRemove;
import net.labymod.labyconnect.packets.PacketPlayServerStatus;
import net.labymod.labyconnect.packets.PacketPlayServerStatusUpdate;
import net.labymod.labyconnect.packets.PacketPlayTyping;
import net.labymod.labyconnect.packets.PacketPong;
import net.labymod.labyconnect.packets.PacketServerMessage;
import net.labymod.labyconnect.packets.PacketUpdateCosmetics;
import net.labymod.labyconnect.packets.PacketUserBadge;
import net.labymod.labyconnect.user.ChatRequest;
import net.labymod.labyconnect.user.ChatUser;
import net.labymod.main.LabyMod;
import net.labymod.main.Source;
import net.labymod.main.lang.LanguageManager;
import net.labymod.support.listener.LabyConnectCommands;
import net.labymod.support.util.Debug;
import net.labymod.user.User;
import net.labymod.user.UserManager;
import net.labymod.user.group.LabyGroup;
import net.labymod.utils.Consumer;
import net.labymod.utils.ModColor;
import net.labymod.utils.ModUtils;
import net.labymod.utils.manager.ConfigManager;
import org.lwjgl.opengl.GL11;
import oshi.SystemInfo;
import oshi.hardware.Processor;

@ChannelHandler.Sharable
public class ClientConnection
extends PacketHandler {
    private NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Chat#%d").build());
    private ExecutorService executorService = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat("Helper#%d").build());
    private NioSocketChannel nioSocketChannel;
    private Bootstrap bootstrap;
    private EnumConnectionState currentConnectionState = EnumConnectionState.OFFLINE;
    private LabyConnect labyConnect;
    private String lastKickMessage = "Unknown";
    private String mojang;
    public String customIp = null;
    public int customPort = -1;
    private long lastPing = System.currentTimeMillis();
    private Consumer<String> dashboardPinConsumer;
    private boolean premium = false;
    private boolean connectionEstablished = false;

    public ClientConnection(LabyConnect labyConnect) {
        this.labyConnect = labyConnect;
        this.premium = LabyMod.getInstance().isPremium();
        if (Debug.isActive()) {
            LabyMod.getInstance().getEventManager().register(new LabyConnectCommands(this));
        }
        Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(() -> {
            long duration = System.currentTimeMillis() - this.lastPing;
            if (this.currentConnectionState != EnumConnectionState.OFFLINE && duration > 60000L) {
                this.disconnect(false);
            }
        }, 0L, 60L, TimeUnit.SECONDS);
    }

    public void connect() {
        String defaultIp = "chat.labymod.net";
        int defaultPort = 30336;
        String customPort = System.getProperty("customChatPort");
        if (customPort != null) {
            defaultPort = Integer.parseInt(customPort);
        }
        if (this.customIp != null) {
            defaultIp = this.customIp;
        }
        if (this.customPort != -1) {
            defaultPort = this.customPort;
        }
        this.connect(defaultIp, defaultPort);
    }

    public void connect(final String ip, final int port) {
        this.connectionEstablished = false;
        if (this.nioSocketChannel != null && this.nioSocketChannel.isOpen()) {
            this.nioSocketChannel.close();
            this.nioSocketChannel = null;
        }
        this.labyConnect.setForcedLogout(false);
        this.labyConnect.getChatlogManager().loadChatlogs(LabyMod.getInstance().getPlayerUUID());
        this.lastPing = System.currentTimeMillis();
        this.premium = LabyMod.getInstance().isPremium();
        this.updateConnectionState(EnumConnectionState.HELLO);
        this.mojang = ave.A().L().d();
        this.bootstrap = new Bootstrap();
        this.bootstrap.group((EventLoopGroup)this.nioEventLoopGroup);
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.handler((ChannelHandler)new ClientChannelInitializer(this.labyConnect, this));
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        Debug.log(Debug.EnumDebugMode.LABYMOD_CHAT, "Connecting to " + ip + ":" + port);
                        ClientConnection.this.bootstrap.connect(ip, port).syncUninterruptibly();
                        ClientConnection.this.sendPacket(new PacketHelloPing(System.currentTimeMillis()));
                    }
                    catch (UnresolvedAddressException error) {
                        ClientConnection.this.updateConnectionState(EnumConnectionState.OFFLINE);
                        ClientConnection.this.lastKickMessage = error.getMessage() == null ? "Unknown error" : error.getMessage();
                        Debug.log(Debug.EnumDebugMode.LABYMOD_CHAT, "UnresolvedAddressException: " + error.getMessage());
                        error.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ConnectTimeoutException || throwable instanceof TimeoutException) {
                            if (ip.equals("chat.labymod.net")) {
                                ClientConnection.this.connect("chat2.labymod.net", port);
                            } else {
                                ClientConnection.this.updateConnectionState(EnumConnectionState.OFFLINE);
                                ClientConnection.this.lastKickMessage = "Could not reach our servers.";
                                throwable.printStackTrace();
                                IssueCollector.handle(ip, port);
                            }
                            return;
                        }
                        ClientConnection.this.updateConnectionState(EnumConnectionState.OFFLINE);
                        ClientConnection.this.lastKickMessage = throwable.getMessage() == null ? "Unknown error" : throwable.getMessage();
                        Debug.log(Debug.EnumDebugMode.LABYMOD_CHAT, "Throwable: " + throwable.getMessage());
                        throwable.printStackTrace();
                        if (!ClientConnection.this.lastKickMessage.contains("no further information") && throwable.getMessage() != null) break block6;
                        ClientConnection.this.lastKickMessage = LanguageManager.translate("chat_not_reachable");
                    }
                }
            }
        });
    }

    public void disconnect(final boolean kicked) {
        if (this.currentConnectionState == EnumConnectionState.OFFLINE) {
            return;
        }
        this.updateConnectionState(EnumConnectionState.OFFLINE);
        LabyMod.getInstance().getUserManager().resetFamiliars();
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                ClientConnection.this.labyConnect.getChatlogManager().saveChatlogs(LabyMod.getInstance().getPlayerUUID());
                if (ClientConnection.this.nioSocketChannel != null && !kicked) {
                    ClientConnection.this.nioSocketChannel.writeAndFlush((Object)new PacketDisconnect("Logout")).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture arg0) throws Exception {
                            if (ClientConnection.this.nioSocketChannel != null) {
                                ClientConnection.this.nioSocketChannel.close();
                            }
                        }
                    });
                }
            }
        });
    }

    public void updateConnectionState(EnumConnectionState connectionState) {
        this.currentConnectionState = connectionState;
    }

    public void enableEncryption(SecretKey key) {
        this.nioSocketChannel.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new PacketEncryptingDecoder(CryptManager.createNetCipherInstance(2, key)));
        this.nioSocketChannel.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new PacketEncryptingEncoder(CryptManager.createNetCipherInstance(1, key)));
        Debug.log(Debug.EnumDebugMode.LABYMOD_CHAT, "Enabled LabyConnect encryption!");
    }

    @Override
    public void handle(PacketLoginData packet) {
    }

    @Override
    public void handle(PacketHelloPing packet) {
    }

    @Override
    public void handle(PacketHelloPong packet) {
        this.connectionEstablished = true;
        this.sendPacket(new PacketLoginVersion(27, Source.ABOUT_MC_VERSION + "_" + "3.9.62"));
        if (LabyMod.getInstance().isPremium()) {
            this.updateConnectionState(EnumConnectionState.LOGIN);
            this.sendPacket(new PacketLoginData(LabyMod.getInstance().getPlayerUUID(), LabyMod.getInstance().getPlayerName(), LabyMod.getSettings().motd));
            this.sendPacket(new PacketLoginOptions(LabyMod.getSettings().showConnectedIp, this.labyConnect.getClientProfile().getUserStatus(), this.labyConnect.getClientProfile().getTimeZone()));
            this.labyConnect.getFriends().clear();
            this.labyConnect.getRequests().clear();
        }
        this.lastPing = System.currentTimeMillis();
    }

    @Override
    public void handle(PacketPlayPlayerOnline packet) {
        ChatUser chatUser = this.labyConnect.getChatUserByUUID(packet.getPlayer().getGameProfile().getId());
        chatUser.setStatus(packet.getPlayer().getStatus());
        chatUser.setStatusMessage(packet.getPlayer().getStatusMessage());
        if (LabyMod.getSettings().alertsOnlineStatus) {
            if (packet.getPlayer().isOnline()) {
                LabyMod.getInstance().notifyMessageProfile(packet.getPlayer().getGameProfile(), ModColor.cl("a") + LanguageManager.translate("chat_user_now_online"));
            } else {
                LabyMod.getInstance().notifyMessageProfile(packet.getPlayer().getGameProfile(), ModColor.cl("c") + LanguageManager.translate("chat_user_now_offline"));
            }
        }
        this.labyConnect.sortFriendList(LabyMod.getSettings().friendSortType);
    }

    @Override
    public void handle(PacketLoginComplete packet) {
        this.updateConnectionState(EnumConnectionState.PLAY);
        if (packet.getDashboardPin() != null && !packet.getDashboardPin().isEmpty()) {
            try {
                JsonObject jsonObject = (JsonObject)new JsonParser().parse(packet.getDashboardPin());
                if (jsonObject.has("pin")) {
                    String pin = jsonObject.get("pin").getAsString();
                    long expiresAt = jsonObject.get("expires_at").getAsLong();
                    LabyMod.getInstance().getPinManager().update(LabyMod.getInstance().getPlayerUUID(), pin, expiresAt);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LabyMod.getInstance().getUserManager().resetFamiliars();
        this.sendStatistics();
        this.labyConnect.getTracker().onLabyConnectConnect();
    }

    @Override
    public void handle(PacketChatVisibilityChange packet) {
    }

    @Override
    public void handle(PacketKick packet) {
        this.disconnect(true);
        this.lastKickMessage = packet.getReason() == null ? LanguageManager.translate("chat_unknown_kick_reason") : packet.getReason();
        LabyMod.getInstance().notifyMessageRaw(LanguageManager.translate("chat_disconnected_title"), this.lastKickMessage);
    }

    @Override
    public void handle(PacketDisconnect packet) {
        this.disconnect(true);
        this.lastKickMessage = packet.getReason() == null ? LanguageManager.translate("chat_unknown_disconnect_reason") : packet.getReason();
        LabyMod.getInstance().notifyMessageRaw(LanguageManager.translate("chat_disconnected_title"), this.lastKickMessage);
    }

    @Override
    public void handle(PacketPlayRequestAddFriend packet) {
    }

    @Override
    public void handle(PacketLoginFriend packet) {
        this.labyConnect.getFriends().addAll(packet.getFriends());
        this.labyConnect.sortFriendList(LabyMod.getSettings().friendSortType);
    }

    @Override
    public void handle(PacketLoginRequest packet) {
        if (LabyMod.getSettings().ignoreRequests) {
            for (ChatRequest chatRequest : packet.getRequests()) {
                this.sendPacket(new PacketPlayDenyFriendRequest(chatRequest));
            }
        } else {
            this.labyConnect.getRequests().addAll(packet.getRequests());
            for (ChatRequest chatRequest : this.labyConnect.getRequests()) {
                LabyMod.getInstance().notifyMessageProfile(chatRequest.getGameProfile(), ModColor.cl("f") + LanguageManager.translate("chat_user_friend_request"));
            }
        }
        if (ave.A().m instanceof GuiFriendsLayout) {
            ((GuiFriendsLayout)ave.A().m).getChatElementMyProfile().updateButtons();
        }
    }

    @Override
    public void handle(PacketNotAllowed packet) {
    }

    @Override
    public void handle(PacketPing packet) {
        this.sendPacket(new PacketPong());
        this.lastPing = System.currentTimeMillis();
    }

    @Override
    public void handle(PacketPong packet) {
    }

    @Override
    public void handle(PacketServerMessage packet) {
        LabyMod.getInstance().notifyMessageRaw(LanguageManager.translate("chat_server_message_title"), packet.getMessage());
    }

    @Override
    public void handle(final PacketMessage packet) {
        ChatUser chatUser = this.labyConnect.getChatUserByUUID(packet.getSender().getGameProfile().getId());
        if (chatUser != null) {
            chatUser.setLastTyping(0L);
            final SingleChat singleChat = this.labyConnect.getChatlogManager().getChat(chatUser);
            ave.A().a(new Runnable(){

                @Override
                public void run() {
                    singleChat.addMessage(new MessageChatComponent(packet.getSender().getGameProfile().getName(), System.currentTimeMillis(), packet.getMessage()));
                }
            });
            LabyMod.getInstance().notifyMessageProfile(packet.getSender().getGameProfile(), packet.getMessage());
        }
    }

    @Override
    public void handle(PacketPlayTyping packet) {
        ChatUser chatUser = this.labyConnect.getChatUserByUUID(packet.getPlayer().getGameProfile().getId());
        if (chatUser != null) {
            chatUser.setLastTyping(System.currentTimeMillis());
        }
    }

    @Override
    public void handle(PacketPlayRequestAddFriendResponse packet) {
        GuiFriendsAddFriend.response = packet.isRequestSent() ? "true" : packet.getReason();
    }

    @Override
    public void handle(PacketPlayRequestRemove packet) {
        Iterator<ChatRequest> iterator = this.labyConnect.getRequests().iterator();
        while (iterator.hasNext()) {
            ChatRequest next = iterator.next();
            if (!next.getGameProfile().getName().equalsIgnoreCase(packet.getPlayerName())) continue;
            iterator.remove();
        }
    }

    @Override
    public void handle(PacketPlayDenyFriendRequest packet) {
    }

    @Override
    public void handle(PacketPlayFriendRemove packet) {
        Iterator<ChatUser> iterator = this.labyConnect.getFriends().iterator();
        while (iterator.hasNext()) {
            ChatUser next = iterator.next();
            if (!next.equals(packet.getToRemove())) continue;
            iterator.remove();
            if (GuiFriendsLayout.selectedUser == null || !GuiFriendsLayout.selectedUser.equals(next)) continue;
            GuiFriendsLayout.selectedUser = null;
        }
        this.labyConnect.sortFriendList(LabyMod.getSettings().friendSortType);
        GameIconHelper.updateIcon(true, false);
    }

    @Override
    public void handle(PacketLoginOptions packet) {
    }

    @Override
    public void handle(PacketPlayServerStatus packet) {
    }

    @Override
    public void handle(PacketPlayServerStatusUpdate packet) {
    }

    @Override
    public void handle(PacketPlayFriendStatus packet) {
        ChatUser chatUser = this.labyConnect.getChatUser(packet.getPlayer());
        chatUser.setCurrentServerInfo(packet.getPlayerInfo());
    }

    @Override
    public void handle(PacketPlayFriendPlayingOn packet) {
        if (!LabyMod.getSettings().alertsPlayingOn) {
            return;
        }
        if (packet.getGameModeName() == null || packet.getGameModeName().isEmpty()) {
            return;
        }
        String message = null;
        message = packet.getGameModeName().contains(".") ? LanguageManager.translate("chat_user_now_playing_on", packet.getGameModeName()) : LanguageManager.translate("chat_user_now_playing", packet.getGameModeName());
        LabyMod.getInstance().notifyMessageProfile(packet.getPlayer().getGameProfile(), message);
    }

    @Override
    public void handle(PacketPlayChangeOptions packet) {
    }

    @Override
    public void handle(PacketLoginTime packet) {
        this.labyConnect.getClientProfile().setFirstJoined(packet.getDateJoined());
    }

    @Override
    public void handle(PacketLoginVersion packet) {
    }

    @Override
    public void handle(PacketEncryptionRequest encryptionRequest) {
        UUID uuid = ave.A().L().e().getId();
        PublicKey publicKey = CryptManager.decodePublicKey(encryptionRequest.getPublicKey());
        final SecretKey secretKey = CryptManager.createNewSharedKey();
        if (uuid == null) {
            this.lastKickMessage = LanguageManager.translate("chat_invalid_session");
            Debug.log(Debug.EnumDebugMode.LABYMOD_CHAT, this.lastKickMessage);
            this.disconnect(false);
            return;
        }
        String pin = LabyMod.getInstance().getPinManager().getValidPinOf(uuid);
        if (pin != null) {
            this.sendPacket(new PacketEncryptionResponse(secretKey, publicKey, encryptionRequest.getVerifyToken(), pin), channel -> this.enableEncryption(secretKey));
            return;
        }
        try {
            String serverId = encryptionRequest.getServerId();
            String hash = new BigInteger(CryptManager.getServerIdHash(serverId, publicKey, secretKey)).toString(16);
            MinecraftSessionService minecraftSessionService = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString()).createMinecraftSessionService();
            minecraftSessionService.joinServer(ave.A().L().e(), this.mojang, hash);
            this.sendPacket(new PacketEncryptionResponse(secretKey, publicKey, encryptionRequest.getVerifyToken()), new Consumer<NioSocketChannel>(){

                @Override
                public void accept(NioSocketChannel channel) {
                    ClientConnection.this.enableEncryption(secretKey);
                }
            });
            return;
        }
        catch (AuthenticationUnavailableException e1) {
            this.lastKickMessage = LanguageManager.translate("chat_authentication_unavaileable");
        }
        catch (InvalidCredentialsException e2) {
            this.lastKickMessage = LanguageManager.translate("chat_invalid_session");
        }
        catch (AuthenticationException e3) {
            this.lastKickMessage = LanguageManager.translate("chat_login_failed");
        }
        Debug.log(Debug.EnumDebugMode.LABYMOD_CHAT, this.lastKickMessage);
        this.updateConnectionState(EnumConnectionState.HELLO);
        this.premium = false;
    }

    @Override
    public void handle(PacketEncryptionResponse packet) {
    }

    @Override
    public void handle(PacketMojangStatus packet) {
    }

    @Override
    public void handle(PacketUpdateCosmetics packet) {
        UUID uuid = LabyMod.getInstance().getPlayerUUID();
        if (uuid == null) {
            return;
        }
        String json = packet.getJson();
        UserManager userManager = LabyMod.getInstance().getUserManager();
        if (json == null) {
            userManager.removeCheckedUser(uuid);
            userManager.getUser(uuid).unloadCosmeticTextures();
            return;
        }
        userManager.updateUsersJson(uuid, json, new Consumer<Boolean>(){

            @Override
            public void accept(Boolean accepted) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void handle(PacketUserBadge packetUserStatus) {
        byte[] ranks;
        UserManager userManager = LabyMod.getInstance().getUserManager();
        UUID[] uuids = packetUserStatus.getUuids();
        boolean validRanks = uuids.length == (ranks = packetUserStatus.getRanks()).length;
        for (int i = 0; i < packetUserStatus.getUuids().length; ++i) {
            byte rank;
            UUID uuid = uuids[i];
            User user = userManager.getUser(uuid);
            user.setFamiliar(true);
            if (!validRanks || (rank = ranks[i]) <= 0) continue;
            try {
                LabyGroup group = userManager.getGroupManager().getGroupById(ranks[i]);
                user.setGroup(group);
                continue;
            }
            catch (Exception error) {
                Debug.log(Debug.EnumDebugMode.LABYMOD_CHAT, "Error on updating user rank of " + uuid.toString() + ": " + ranks[i]);
            }
        }
    }

    @Override
    public void handle(PacketActionBroadcast packet) {
        switch (packet.getType()) {
            case EMOTE: {
                short emoteId = ByteBuffer.wrap(packet.getData()).order(ByteOrder.LITTLE_ENDIAN).getShort();
                LabyMod.getInstance().getEmoteRegistry().handleEmote(packet.getUniqueId(), emoteId);
                break;
            }
            case COSMETIC_CHANGE: {
                String json = new String(packet.getData());
                LabyMod.getInstance().getUserManager().updateUsersJson(packet.getUniqueId(), json, null);
                break;
            }
            case STICKER: {
                short stickerId = ByteBuffer.wrap(packet.getData()).order(ByteOrder.LITTLE_ENDIAN).getShort();
                UserManager userManager = LabyMod.getInstance().getUserManager();
                LabyMod.getInstance().getStickerRegistry().handleSticker(userManager.getUser(packet.getUniqueId()), stickerId);
            }
        }
    }

    @Override
    public void handle(PacketAddonMessage packet) {
        JsonObject jsonObject;
        LabyMod.getInstance().getEventManager().callAddonMessage(packet);
        String key = packet.getKey();
        if (key.equals("UPDATE")) {
            LabyMod.getInstance().getUpdater().setForceUpdate(true);
        }
        if (key.equals("refresh_labymod")) {
            LabyMod.getInstance().getUserManager().refresh();
        }
        if (key.equals("UPDATE-BACKUP")) {
            LabyMod.getInstance().getUpdater().setBackupMethod(true);
            LabyMod.getInstance().getUpdater().setForceUpdate(true);
        }
        if (key.equals("invalidate_pin")) {
            LabyMod.getInstance().getPinManager().invalidatePinOf(LabyMod.getInstance().getPlayerUUID());
        }
        if (key.equals("dashboard_pin") && (jsonObject = (JsonObject)new JsonParser().parse(packet.getJson())).has("pin")) {
            String pin = jsonObject.get("pin").getAsString();
            if (this.dashboardPinConsumer != null) {
                this.dashboardPinConsumer.accept(pin);
            }
        }
        if (key.equals("server_message")) {
            jsonObject = (JsonObject)new JsonParser().parse(packet.getJson());
            LabyMod.getInstance().displayMessageInChat(ModColor.createColors(jsonObject.get("message").getAsString()));
        }
        if (key.equals("language_flags")) {
            JsonObject map = (JsonObject)new JsonParser().parse(packet.getJson());
            try {
                Map<UUID, jy> flags = LabyMod.getInstance().getPriorityOverlayRenderer().getLanguageFlags();
                for (Map.Entry entry : map.entrySet()) {
                    UUID uuid = UUID.fromString((String)entry.getKey());
                    String code = ((JsonElement)entry.getValue()).getAsString();
                    if (code.contains(".") || code.contains("/") || code.contains("\\") || code.equals("??")) continue;
                    flags.put(uuid, new jy(String.format("labymod/textures/flags/%s.png", code)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (key.equals("labynet")) {
            try {
                jsonObject = (JsonObject)new JsonParser().parse(packet.getJson());
                JsonObject settings = jsonObject.get("settings").getAsJsonObject();
                if (!settings.entrySet().isEmpty() && !LabyMod.getInstance().isInGame()) {
                    ave.A().a(() -> ave.A().a((axu)new GuiLabyNet(settings, settingsOut -> {
                        JsonObject response = new JsonObject();
                        response.add("settings", (JsonElement)settingsOut);
                        this.sendPacket(new PacketAddonMessage("labynet", response.toString()));
                    })));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (key.equals("unauthenticated")) {
            this.updateConnectionState(EnumConnectionState.HELLO);
            this.premium = false;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.disconnect(false);
        if (!(cause instanceof IOException)) {
            cause.printStackTrace();
            ctx.close();
        }
    }

    public void sendPacket(final Packet packet, final Consumer<NioSocketChannel> consumer) {
        if (this.nioSocketChannel == null) {
            return;
        }
        if (!this.nioSocketChannel.isOpen() || !this.nioSocketChannel.isWritable() || this.currentConnectionState == EnumConnectionState.OFFLINE) {
            return;
        }
        if (this.nioSocketChannel.eventLoop().inEventLoop()) {
            this.nioSocketChannel.writeAndFlush((Object)packet).addListeners(new GenericFutureListener[]{ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE});
            if (consumer != null) {
                consumer.accept(this.nioSocketChannel);
            }
        } else {
            this.nioSocketChannel.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    ClientConnection.this.nioSocketChannel.writeAndFlush((Object)packet).addListeners(new GenericFutureListener[]{ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE});
                    if (consumer != null) {
                        consumer.accept(ClientConnection.this.nioSocketChannel);
                    }
                }
            });
        }
    }

    public void sendPacket(Packet packet) {
        this.sendPacket(packet, null);
    }

    private void sendStatistics() {
        if (LabyMod.getSettings().sendAnonymousStatistics) {
            try {
                final JsonObject obj = new JsonObject();
                JsonObject minecraft = new JsonObject();
                JsonObject labymod = new JsonObject();
                JsonArray addons = new JsonArray();
                for (LabyModAddon addonInfo : AddonLoader.getAddons()) {
                    if (addonInfo.about == null || addonInfo.about.uuid == null) continue;
                    JsonObject entry = new JsonObject();
                    entry.addProperty("uuid", addonInfo.about.uuid.toString());
                    entry.addProperty("name", addonInfo.about.name);
                    addons.add((JsonElement)entry);
                }
                labymod.add("addons", (JsonElement)addons);
                labymod.add("settings", ConfigManager.GSON.toJsonTree((Object)LabyMod.getSettings()));
                labymod.addProperty("version", "3.9.62");
                minecraft.add("labymod", (JsonElement)labymod);
                JsonObject forge = new JsonObject();
                forge.addProperty("installed", Boolean.valueOf(LabyModCoreMod.isForge()));
                forge.add("mods", (JsonElement)ForgeModsScanner.getInstance().getJsonArray());
                minecraft.add("forge", (JsonElement)forge);
                minecraft.addProperty("version", Source.ABOUT_MC_VERSION);
                minecraft.addProperty("protocol_version", (Number)Source.ABOUT_MC_PROTOCOL_VERSION);
                obj.add("minecraft", (JsonElement)minecraft);
                JsonObject operatingSystem = new JsonObject();
                operatingSystem.addProperty("name", System.getProperty("os.name"));
                operatingSystem.addProperty("version", System.getProperty("os.version"));
                obj.add("os", (JsonElement)operatingSystem);
                Processor[] processors = new Processor[]{};
                try {
                    processors = new SystemInfo().getHardware().getProcessors();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                long memorySize = 0L;
                try {
                    memorySize = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                JsonObject hardware = new JsonObject();
                hardware.addProperty("cpu", processors.length == 0 && processors[0] != null ? "None" : processors[0].toString());
                hardware.addProperty("memory", (Number)memorySize);
                hardware.addProperty("hashed_mac", ModUtils.sha1(ModUtils.getMAC()));
                JsonArray monitors = new JsonArray();
                try {
                    GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    if (graphicsEnvironment != null) {
                        GraphicsDevice[] graphicsDevices;
                        for (GraphicsDevice graphicsDevice : graphicsDevices = graphicsEnvironment.getScreenDevices()) {
                            DisplayMode displayMode = graphicsDevice.getDisplayMode();
                            if (displayMode == null) continue;
                            JsonObject monitor = new JsonObject();
                            monitor.addProperty("width", (Number)displayMode.getWidth());
                            monitor.addProperty("height", (Number)displayMode.getHeight());
                            monitor.addProperty("refresh_rate", (Number)displayMode.getRefreshRate());
                            monitors.add((JsonElement)monitor);
                        }
                    }
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
                hardware.add("monitors", (JsonElement)monitors);
                obj.add("hardware", (JsonElement)hardware);
                JsonObject java = new JsonObject();
                java.addProperty("version", System.getProperty("java.version"));
                obj.add("java", (JsonElement)java);
                ave.A().a(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JsonObject opengl = new JsonObject();
                            opengl.addProperty("version", GL11.glGetString((int)7938));
                            opengl.addProperty("vendor", GL11.glGetString((int)7936));
                            opengl.addProperty("renderer", GL11.glGetString((int)7937));
                            obj.add("opengl", (JsonElement)opengl);
                            ClientConnection.this.sendPacket(new PacketAddonMessage("anonymous_statistics", obj.toString()));
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public boolean isPinAvailable() {
        return LabyMod.getInstance().getPinManager().hasValidPin(LabyMod.getInstance().getPlayerUUID());
    }

    @Deprecated
    public void requestPin(Consumer<String> consumer) {
        String pin = LabyMod.getInstance().getPinManager().getValidPinOf(LabyMod.getInstance().getPlayerUUID());
        if (pin != null) {
            consumer.accept(pin);
        }
    }

    public void requestDashboardPin(Consumer<String> consumer) {
        this.dashboardPinConsumer = consumer;
        this.sendPacket(new PacketAddonMessage("dashboard_pin", new JsonObject().toString()));
    }

    public void setNioSocketChannel(NioSocketChannel nioSocketChannel) {
        this.nioSocketChannel = nioSocketChannel;
    }

    public EnumConnectionState getCurrentConnectionState() {
        return this.currentConnectionState;
    }

    public String getLastKickMessage() {
        return this.lastKickMessage;
    }

    public String getCustomIp() {
        return this.customIp;
    }

    public boolean isPremium() {
        return this.premium;
    }

    public boolean isConnectionEstablished() {
        return this.connectionEstablished;
    }
}

