/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.moduletypes;

import java.util.ArrayList;
import java.util.List;
import net.labymod.ingamegui.ModuleConfig;
import net.labymod.ingamegui.enums.EnumModuleFormatting;
import net.labymod.ingamegui.moduletypes.ColoredTextModule;
import net.labymod.settings.DefaultElementsCreator;
import net.labymod.settings.elements.SettingsElement;

public abstract class TextModule
extends ColoredTextModule {
    protected int prefixColor = -1;
    protected int bracketsColor = -1;
    protected int valueColor = -1;
    protected boolean bold;
    protected boolean italic;
    protected boolean underline;
    protected boolean keyVisible = true;
    private EnumModuleFormatting formatting = EnumModuleFormatting.DEFAULT;

    public List<List<ColoredTextModule.Text>> getCustomTextLines() {
        return null;
    }

    public abstract String[] getKeys();

    public abstract List<List<ColoredTextModule.Text>> getTextValues();

    public abstract String[] getDefaultKeys();

    public abstract List<List<ColoredTextModule.Text>> getDefaultTextValues();

    @Override
    public void fillSubSettings(List<SettingsElement> settingsElements) {
        super.fillSubSettings(settingsElements);
        DefaultElementsCreator.createFormatting(this, false, settingsElements);
        DefaultElementsCreator.createColorPicker(this, false, settingsElements);
        DefaultElementsCreator.createKeyVisible(this, false, settingsElements);
        DefaultElementsCreator.createBackgroundVisible(this, false, settingsElements);
        DefaultElementsCreator.createPadding(this, false, settingsElements);
    }

    @Override
    public void init() {
        super.init();
        if (this.getModuleConfigElement().isUsingExtendedSettings()) {
            boolean bl = this.keyVisible = this.getAttributes().containsKey("keyVisible") ? Boolean.parseBoolean(this.getAttributes().get("keyVisible")) : true;
            if (this.getAttributes().containsKey("formatting")) {
                this.formatting = EnumModuleFormatting.values()[Integer.parseInt(this.getAttributes().get("formatting"))];
            }
        }
    }

    @Override
    public List<List<ColoredTextModule.Text>> getTexts() {
        List<List<ColoredTextModule.Text>> customLines = this.getCustomTextLines();
        if (customLines != null) {
            return customLines;
        }
        this.setColors();
        if (!this.getModuleConfigElement().isUsingExtendedSettings()) {
            this.keyVisible = ModuleConfig.getConfig().isKeyVisible();
        }
        this.setFormattings();
        String[] keys = this.isShown() ? this.getKeys() : this.getDefaultKeys();
        List<List<ColoredTextModule.Text>> values = this.isShown() ? this.getTextValues() : this.getDefaultTextValues();
        EnumModuleFormatting displayFormatting = this.getDisplayFormatting();
        ArrayList<List<ColoredTextModule.Text>> texts = new ArrayList<List<ColoredTextModule.Text>>();
        try {
            for (int i = 0; i < keys.length; ++i) {
                texts.add(displayFormatting.getTexts(keys[i], values.get(i), this.bracketsColor, this.prefixColor, this.valueColor, this.keyVisible, this.bold, this.italic, this.underline));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return texts;
    }

    @Override
    public int getLines() {
        List<List<ColoredTextModule.Text>> customLines = this.getCustomTextLines();
        return customLines != null ? customLines.size() : (this.isShown() ? this.getKeys() : this.getDefaultKeys()).length;
    }

    public void setColors() {
        int dumpColor = 0;
        this.prefixColor = !this.getAttributes().containsKey("prefixColor") || !this.getModuleConfigElement().isUsingExtendedSettings() || (dumpColor = Integer.parseInt(this.getAttributes().get("prefixColor"))) == -1 ? ModuleConfig.getConfig().getPrefixColor() : dumpColor;
        this.bracketsColor = !this.getAttributes().containsKey("bracketsColor") || !this.getModuleConfigElement().isUsingExtendedSettings() || (dumpColor = Integer.parseInt(this.getAttributes().get("bracketsColor"))) == -1 ? ModuleConfig.getConfig().getBracketsColor() : dumpColor;
        this.valueColor = !this.getAttributes().containsKey("valueColor") || !this.getModuleConfigElement().isUsingExtendedSettings() || (dumpColor = Integer.parseInt(this.getAttributes().get("valueColor"))) == -1 ? ModuleConfig.getConfig().getValuesColor() : dumpColor;
    }

    public void setFormattings() {
        int dumpFormatting = 0;
        int boldMode = !this.getAttributes().containsKey("boldFormatting") || !this.getModuleConfigElement().isUsingExtendedSettings() || (dumpFormatting = Integer.parseInt(this.getAttributes().get("boldFormatting"))) == -1 ? ModuleConfig.getConfig().getFormattingBold() : dumpFormatting;
        int italicMode = !this.getAttributes().containsKey("italicFormatting") || !this.getModuleConfigElement().isUsingExtendedSettings() || (dumpFormatting = Integer.parseInt(this.getAttributes().get("italicFormatting"))) == -1 ? ModuleConfig.getConfig().getFormattingItalic() : dumpFormatting;
        int underlineMode = !this.getAttributes().containsKey("underlineFormatting") || !this.getModuleConfigElement().isUsingExtendedSettings() || (dumpFormatting = Integer.parseInt(this.getAttributes().get("underlineFormatting"))) == -1 ? ModuleConfig.getConfig().getFormattingUnderline() : dumpFormatting;
        this.bold = boldMode == 1;
        this.italic = italicMode == 1;
        this.underline = underlineMode == 1;
    }

    public void drawLine(EnumModuleFormatting formatting, int x, int y, String key, List<ColoredTextModule.Text> value) {
        TextModule.drawTextLine(formatting, x, y, key, value, this.bracketsColor, this.prefixColor, this.valueColor, this.bold, this.italic, this.underline);
    }

    protected EnumModuleFormatting getDisplayFormatting() {
        return this.formatting == EnumModuleFormatting.DEFAULT || !this.getModuleConfigElement().isUsingExtendedSettings() || this.formatting == null ? ModuleConfig.getConfig().getDefaultFormatting() : this.formatting;
    }

    public static void drawTextLine(EnumModuleFormatting formatting, int x, int y, String key, List<ColoredTextModule.Text> value, int bracketsColor, int prefixColor, int valueColor, boolean bold, boolean italic, boolean underline) {
        formatting.draw(x, y, key, value, bracketsColor, prefixColor, valueColor, bold, italic, underline);
    }

    public boolean isKeyVisible() {
        return this.keyVisible;
    }

    public void setKeyVisible(boolean keyVisible) {
        this.keyVisible = keyVisible;
    }
}

