/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.modules;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.ColorPicker;
import net.labymod.ingamegui.ModuleCategory;
import net.labymod.ingamegui.ModuleCategoryRegistry;
import net.labymod.ingamegui.moduletypes.ColoredTextModule;
import net.labymod.ingamegui.moduletypes.TextModule;
import net.labymod.settings.elements.BooleanElement;
import net.labymod.settings.elements.ColorPickerCheckBoxBulkElement;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.Consumer;
import net.labymod.utils.Material;
import net.labymod.utils.ModColor;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PingModule
extends TextModule {
    private int averageColor;
    private boolean displayAverage;
    private boolean coloredPing;
    private List<Integer> storedPing = new ArrayList<Integer>();
    private long lastStoredPing = 0L;
    private double averagePing = 0.0;
    private int currentPing = 0;

    @Override
    public String[] getKeys() {
        return new String[]{"Ping"};
    }

    @Override
    public String[] getDefaultKeys() {
        return this.getKeys();
    }

    @Override
    public List<List<ColoredTextModule.Text>> getTextValues() {
        ArrayList<ColoredTextModule.Text> texts = new ArrayList<ColoredTextModule.Text>();
        int color = this.valueColor;
        if (this.coloredPing) {
            if (this.currentPing < 80) {
                color = ModColor.GREEN.getColor().getRGB();
            } else if (this.currentPing < 120) {
                color = ModColor.YELLOW.getColor().getRGB();
            } else if (this.currentPing < 250) {
                color = ModColor.RED.getColor().getRGB();
            } else if (this.currentPing < 400) {
                color = ModColor.DARK_RED.getColor().getRGB();
            }
        }
        texts.add(ColoredTextModule.Text.getText(String.valueOf(this.currentPing <= 0 ? "?" : Integer.valueOf(this.currentPing)), color));
        if (this.displayAverage) {
            texts.add(ColoredTextModule.Text.getText(" " + String.valueOf((int)this.averagePing), this.averageColor));
        }
        return Collections.singletonList(texts);
    }

    @Override
    public List<List<ColoredTextModule.Text>> getDefaultTextValues() {
        return Collections.singletonList(Collections.singletonList(ColoredTextModule.Text.getText("?", -1)));
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.isShown() && this.lastStoredPing < System.currentTimeMillis()) {
            this.lastStoredPing = System.currentTimeMillis() + 5000L;
            this.updateCurrentPing();
            if (this.currentPing != 0 && this.displayAverage) {
                this.storedPing.add(this.currentPing);
                if (this.storedPing.size() > 12) {
                    this.storedPing.remove(0);
                }
                int total = 0;
                for (int ping : this.storedPing) {
                    total += ping;
                }
                this.averagePing = total / this.storedPing.size();
            }
        }
    }

    private void updateCurrentPing() {
        bdc networkPlayerInfo = LabyModCore.getMinecraft().getConnection().a(LabyModCore.getMinecraft().getPlayer().aK());
        this.currentPing = networkPlayerInfo == null ? 0 : networkPlayerInfo.c();
    }

    @Override
    public void loadSettings() {
        this.coloredPing = Boolean.valueOf(this.getAttribute("coloredPing", "true"));
        this.displayAverage = Boolean.valueOf(this.getAttribute("displayAverage", "false"));
        this.averageColor = Integer.valueOf(this.getAttribute("averageColor", "-1"));
    }

    @Override
    public void fillSubSettings(List<SettingsElement> settingsElements) {
        super.fillSubSettings(settingsElements);
        settingsElements.add(new BooleanElement(this, this.getModuleIcon(this.getSettingName(), "coloredping"), "Colored Ping", "coloredPing"));
        settingsElements.add(new BooleanElement(this, new ControlElement.IconData(Material.EMERALD), "Display Average", "displayAverage"));
        ColorPickerCheckBoxBulkElement colorPickerBulkElement = new ColorPickerCheckBoxBulkElement("Average color");
        settingsElements.add(colorPickerBulkElement);
        ColorPicker nameColorPicker = new ColorPicker("Average", ModColor.getColorByString(this.getAttributes().get("averageColor")), new ColorPicker.DefaultColorCallback(){

            @Override
            public Color getDefaultColor() {
                return Color.WHITE;
            }
        }, 0, 0, 0, 0);
        nameColorPicker.setHasAdvanced(true);
        nameColorPicker.setHasDefault(false);
        nameColorPicker.setUpdateListener(new Consumer<Color>(){

            @Override
            public void accept(Color color) {
                PingModule.this.getAttributes().put("averageColor", String.valueOf(color == null ? -1 : color.getRGB()));
                PingModule.this.loadSettings();
            }
        });
        colorPickerBulkElement.addColorPicker(nameColorPicker);
    }

    @Override
    public ControlElement.IconData getIconData() {
        return this.getModuleIcon(this.getSettingName());
    }

    @Override
    public String getSettingName() {
        return "ping";
    }

    @Override
    public String getDescription() {
        return "The ping to the current server";
    }

    @Override
    public int getSortingId() {
        return 7;
    }

    @Override
    public boolean isShown() {
        return LabyModCore.getMinecraft().getPlayer() != null && !ave.A().F();
    }

    @Override
    public ModuleCategory getCategory() {
        return ModuleCategoryRegistry.CATEGORY_INFO;
    }
}

