/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.modules;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.labymod.gui.elements.DropDownMenu;
import net.labymod.ingamegui.ModuleCategory;
import net.labymod.ingamegui.ModuleCategoryRegistry;
import net.labymod.ingamegui.moduletypes.SimpleModule;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.DropDownElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.settings.elements.StringElement;
import net.labymod.utils.Material;

public class DateModule
extends SimpleModule {
    private String selectedDateFormat;
    private SimpleDateFormat dateFormat;
    private Date date = new Date();
    private long lastUpdate = -1L;
    private String lastRenderedString = "";

    @Override
    public String getDisplayName() {
        return "Date";
    }

    @Override
    public String getDisplayValue() {
        if (this.lastUpdate + 10000L < System.currentTimeMillis()) {
            this.lastUpdate = System.currentTimeMillis();
            this.date.setTime(System.currentTimeMillis());
            this.lastRenderedString = this.dateFormat == null ? "Invalid date format: " + this.selectedDateFormat : this.dateFormat.format(this.date);
        }
        return this.lastRenderedString;
    }

    @Override
    public String getDefaultValue() {
        return "Unknown";
    }

    private void updateSimpleDateFormat() {
        try {
            this.dateFormat = new SimpleDateFormat(this.selectedDateFormat);
        }
        catch (IllegalArgumentException error) {
            this.dateFormat = null;
        }
    }

    @Override
    public void loadSettings() {
        this.selectedDateFormat = this.getAttribute("dateFormat", "MM/dd/yyyy");
        if (this.selectedDateFormat.equals("Use Custom Format")) {
            this.selectedDateFormat = this.getAttribute("customFormat", "MM/dd/yyyy");
        }
        this.updateSimpleDateFormat();
    }

    @Override
    public void fillSubSettings(List<SettingsElement> settingsElements) {
        super.fillSubSettings(settingsElements);
        DropDownMenu<String> dropDownMenu = new DropDownMenu<String>("Date format", 0, 0, 0, 0);
        dropDownMenu.addOption("MM/dd/yyyy");
        dropDownMenu.addOption("MM/dd/yy");
        dropDownMenu.addOption("MM/dd");
        dropDownMenu.addOption("dd.MM.yyyy");
        dropDownMenu.addOption("dd.MM.yy");
        dropDownMenu.addOption("dd.MM");
        dropDownMenu.addOption("Use Custom Format");
        dropDownMenu.setSelected(this.selectedDateFormat);
        DropDownElement dropDownElement = new DropDownElement(this, "Date format", "dateFormat", dropDownMenu, null);
        settingsElements.add(dropDownElement);
        settingsElements.add(new StringElement(this, new ControlElement.IconData(Material.ANVIL), "Custom format", "customFormat"));
    }

    @Override
    public ControlElement.IconData getIconData() {
        return this.getModuleIcon(this.getSettingName());
    }

    @Override
    public String getSettingName() {
        return "date";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public ModuleCategory getCategory() {
        return ModuleCategoryRegistry.CATEGORY_INFO;
    }

    @Override
    public int getSortingId() {
        return 4;
    }
}

