/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.modules;

import net.labymod.core.LabyModCore;
import net.labymod.ingamegui.ModuleCategory;
import net.labymod.ingamegui.ModuleCategoryRegistry;
import net.labymod.ingamegui.moduletypes.SimpleModule;
import net.labymod.main.LabyMod;
import net.labymod.settings.elements.ControlElement;
import net.labymod.utils.Consumer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ComboModule
extends SimpleModule {
    private int lastEntityId = -1;
    private long lastHit = 0L;
    private int comboCount = 0;
    private float lastHealth;

    public ComboModule() {
        LabyMod.getInstance().getLabyModAPI().getEventManager().registerOnAttack(new Consumer<pk>(){

            @Override
            public void accept(pk entity) {
                if (!(entity instanceof wn)) {
                    return;
                }
                wn entityPlayer = (wn)entity;
                if (entityPlayer.au > 1) {
                    return;
                }
                if (entity.F() == ComboModule.this.lastEntityId) {
                    ComboModule.this.comboCount++;
                } else {
                    ComboModule.this.comboCount = 1;
                }
                ComboModule.this.lastEntityId = entity.F();
                ComboModule.this.lastHit = System.currentTimeMillis();
            }
        });
    }

    @Override
    public String getDisplayName() {
        return "Combo";
    }

    @Override
    public String getDisplayValue() {
        return String.valueOf(this.comboCount);
    }

    @Override
    public boolean isShown() {
        return this.comboCount != 0 && super.isShown();
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (LabyModCore.getMinecraft().getPlayer() == null) {
            return;
        }
        if (LabyModCore.getMinecraft().getPlayer().bn() < this.lastHealth) {
            this.comboCount = 0;
        }
        this.lastHealth = LabyModCore.getMinecraft().getPlayer().bn();
        if (this.lastHit + 2000L < System.currentTimeMillis()) {
            this.comboCount = 0;
        }
    }

    @Override
    public void loadSettings() {
    }

    @Override
    public String getDefaultValue() {
        return "?";
    }

    @Override
    public ControlElement.IconData getIconData() {
        return this.getModuleIcon(this.getSettingName());
    }

    @Override
    public String getSettingName() {
        return "combo";
    }

    @Override
    public String getDescription() {
        return "Counts the number of hits you distribute while comboing your opponent.";
    }

    @Override
    public int getSortingId() {
        return 12;
    }

    @Override
    public ModuleCategory getCategory() {
        return ModuleCategoryRegistry.CATEGORY_INFO;
    }
}

