/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamechat;

import java.io.IOException;
import java.util.ArrayList;
import net.labymod.api.events.MessageSendEvent;
import net.labymod.api.permissions.Permissions;
import net.labymod.core.LabyModCore;
import net.labymod.ingamechat.IngameChatManager;
import net.labymod.ingamechat.namehistory.NameHistory;
import net.labymod.ingamechat.namehistory.NameHistoryUtil;
import net.labymod.ingamechat.renderer.EnumMouseAction;
import net.labymod.ingamechat.tabs.GuiChatAutoText;
import net.labymod.ingamechat.tabs.GuiChatFilter;
import net.labymod.ingamechat.tabs.GuiChatNameHistory;
import net.labymod.ingamechat.tabs.GuiChatPlayerMenu;
import net.labymod.ingamechat.tabs.GuiChatShortcuts;
import net.labymod.ingamechat.tabs.GuiChatSymbols;
import net.labymod.ingamechat.tools.shortcuts.Shortcuts;
import net.labymod.ingamegui.Module;
import net.labymod.ingamegui.ModuleGui;
import net.labymod.ingamegui.enums.EnumDisplayType;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.main.lang.LanguageManager;
import net.labymod.settings.LabyModModuleEditorGui;
import net.labymod.settings.elements.ControlElement;
import net.labymod.utils.Material;
import net.labymod.utils.ModColor;
import net.labymod.utils.ModUtils;
import net.labymod.utils.UUIDFetcher;
import net.labymod.utils.manager.TooltipHelper;
import org.lwjgl.input.Mouse;

public class GuiChatCustom
extends awv {
    private static final ModuleGui moduleGui = new ModuleGui(false, false, EnumDisplayType.INGAME);
    public static int activeTab = -1;
    private ChatButton[] chatButtons;
    private String defaultText;
    private IngameChatManager ingameChatManager = IngameChatManager.INSTANCE;

    public GuiChatCustom(String defaultText) {
        super(defaultText);
        this.defaultText = defaultText;
    }

    public GuiChatCustom() {
    }

    public static ModuleGui getModuleGui() {
        return moduleGui;
    }

    public void b() {
        super.b();
        if (this.j.m != null && this.j.m.getClass() == GuiChatCustom.class) {
            activeTab = -1;
        }
        boolean chatFeaturesAllowed = LabyMod.getInstance().getServerManager().isAllowed(Permissions.Permission.CHAT);
        Module.setCurrentModuleGui(moduleGui);
        moduleGui.b();
        ArrayList<ChatButton> chatButtonList = new ArrayList<ChatButton>();
        if (LabyMod.getSettings().chatSymbols) {
            chatButtonList.add(new ChatButton(0, "symbols", new ControlElement.IconData(ModTextures.CHAT_TAB_SYMBOLS), chatFeaturesAllowed));
        }
        if (LabyMod.getSettings().autoText) {
            chatButtonList.add(new ChatButton(1, "autotext", new ControlElement.IconData(ModTextures.CHAT_TAB_AUTOTEXT), chatFeaturesAllowed));
        }
        if (LabyMod.getSettings().chatShortcuts) {
            chatButtonList.add(new ChatButton(2, "shortcut", new ControlElement.IconData(ModTextures.CHAT_TAB_SHORTCUT), chatFeaturesAllowed));
        }
        if (LabyMod.getSettings().playerMenu && LabyMod.getSettings().playerMenuEditor) {
            chatButtonList.add(new ChatButton(3, "playermenu", new ControlElement.IconData(ModTextures.CHAT_TAB_PLAYERMENU), chatFeaturesAllowed));
        }
        if (LabyMod.getSettings().chatFilter) {
            chatButtonList.add(new ChatButton(4, "filter", new ControlElement.IconData(ModTextures.CHAT_TAB_FILTER), true));
        }
        if (LabyMod.getSettings().nameHistory) {
            chatButtonList.add(new ChatButton(5, "namehistory", new ControlElement.IconData(Material.BOOK_AND_QUILL), true));
        }
        if (LabyMod.getSettings().showModuleEditorShortcut) {
            chatButtonList.add(new ChatButton(6, "module_editor", new ControlElement.IconData(ModTextures.CHAT_TAB_GUI_EDITOR), true));
        }
        this.chatButtons = new ChatButton[chatButtonList.size()];
        chatButtonList.toArray(this.chatButtons);
        this.a.a(this.defaultText == null ? "" : this.defaultText);
    }

    protected void a(avs button) throws IOException {
        super.a(button);
        switch (button.k) {
            case 4: {
                this.j.a((axu)new GuiChatNameHistory(this.a.b()));
            }
        }
    }

    public void drawButtons(int mouseX, int mouseY, float partialTicks) {
        int slot = 0;
        for (ChatButton chatButton : this.chatButtons) {
            boolean hoverSymbols;
            boolean enabled = chatButton.isEnabled();
            int x = this.l - 2 - 13 - slot * 14;
            int y = this.m - 14;
            if (slot == activeTab) {
                GuiChatCustom.a((int)x, (int)(y - 2), (int)(x + 13), (int)y, (int)Integer.MIN_VALUE);
            }
            GuiChatCustom.a((int)x, (int)y, (int)(x + 13), (int)(y + 12), (int)Integer.MIN_VALUE);
            boolean bl = hoverSymbols = mouseX >= x && mouseX < x + 13 && mouseY > y && mouseY < y + 12;
            if (chatButton.getIconData().hasMaterialIcon()) {
                bfl.E();
                double scale = hoverSymbols ? 0.7 : 0.6;
                bfl.a((double)scale, (double)scale, (double)1.0);
                LabyMod.getInstance().getDrawUtils().renderItemIntoGUI(chatButton.getItem(), ((double)x + 5.5 - scale * 6.0) / scale, ((double)(y + 5) - scale * 6.0) / scale);
                bfl.F();
            } else if (chatButton.getIconData().hasTextureIcon()) {
                ave.A().P().a(chatButton.getIconData().getTextureIcon());
                LabyMod.getInstance().getDrawUtils().drawTexture(x + 2 - (hoverSymbols ? 1 : 0), y + 2 - (hoverSymbols ? 1 : 0), 255.0, 255.0, hoverSymbols ? 11.0 : 9.0, hoverSymbols ? 11.0 : 9.0);
            }
            if (hoverSymbols) {
                TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, enabled ? chatButton.getDisplayName() : LanguageManager.translate("ingame_chat_feature_not_allowed", chatButton.getDisplayName()));
            }
            ++slot;
        }
    }

    public void onButtonClick(int mouseX, int mouseY, int mouseButton) {
        block9: for (int slot = 0; slot < this.chatButtons.length; ++slot) {
            boolean hoverSymbols;
            ChatButton chatButton = this.chatButtons[slot];
            boolean bl = hoverSymbols = mouseX > this.l - 2 - 13 - slot * 14 && mouseX < this.l - 2 - slot * 14 && mouseY > this.m - 14 && mouseY < this.m - 2;
            if (!hoverSymbols || !chatButton.isEnabled()) continue;
            switch (chatButton.getId()) {
                case 0: {
                    activeTab = slot;
                    this.j.a((axu)(this.j.m instanceof GuiChatSymbols ? new GuiChatCustom(this.a.b()) : new GuiChatSymbols(this.a.b())));
                    continue block9;
                }
                case 1: {
                    activeTab = slot;
                    this.j.a((axu)(this.j.m instanceof GuiChatAutoText ? new GuiChatCustom(this.a.b()) : new GuiChatAutoText(this.a.b())));
                    continue block9;
                }
                case 2: {
                    activeTab = slot;
                    this.j.a((axu)(this.j.m instanceof GuiChatShortcuts ? new GuiChatCustom(this.a.b()) : new GuiChatShortcuts(this.a.b())));
                    continue block9;
                }
                case 3: {
                    activeTab = slot;
                    this.j.a((axu)(this.j.m instanceof GuiChatPlayerMenu ? new GuiChatCustom(this.a.b()) : new GuiChatPlayerMenu(this.a.b())));
                    continue block9;
                }
                case 4: {
                    activeTab = slot;
                    this.j.a((axu)(this.j.m instanceof GuiChatFilter ? new GuiChatCustom(this.a.b()) : new GuiChatFilter(this.a.b())));
                    continue block9;
                }
                case 5: {
                    activeTab = slot;
                    this.j.a((axu)(this.j.m instanceof GuiChatNameHistory ? new GuiChatCustom(this.a.b()) : new GuiChatNameHistory(this.a.b())));
                    continue block9;
                }
                case 6: {
                    activeTab = slot;
                    this.j.a((axu)new LabyModModuleEditorGui((axu)new GuiChatCustom(this.a.b())));
                }
            }
        }
    }

    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        String name;
        String value;
        this.ingameChatManager.handleMouse(mouseX, mouseY, mouseButton, EnumMouseAction.CLICKED);
        super.a(mouseX, mouseY, mouseButton);
        moduleGui.a(mouseX, mouseY, mouseButton);
        this.onButtonClick(mouseX, mouseY, mouseButton);
        if (mouseButton == 1 && (value = LabyModCore.getMinecraft().getClickEventValue(Mouse.getX(), Mouse.getY())) != null && value.startsWith("/msg ") && !NameHistoryUtil.isInCache(name = value.replace("/msg ", "").replace(" ", ""))) {
            NameHistoryUtil.getNameHistory(name);
        }
    }

    protected void b(int mouseX, int mouseY, int state) {
        this.ingameChatManager.handleMouse(mouseX, mouseY, state, EnumMouseAction.RELEASED);
        super.b(mouseX, mouseY, state);
        moduleGui.b(mouseX, mouseY, state);
    }

    protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        this.ingameChatManager.handleMouse(mouseX, mouseY, clickedMouseButton, EnumMouseAction.DRAGGING);
        super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        moduleGui.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    public void k() throws IOException {
        super.k();
        moduleGui.k();
    }

    protected void a(char typedChar, int keyCode) throws IOException {
        super.a(typedChar, keyCode);
        moduleGui.a(typedChar, keyCode);
    }

    public void m() {
        super.m();
        moduleGui.m();
        Module.setCurrentModuleGui(null);
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.drawModifiedSuperScreen(mouseX, mouseY, partialTicks);
        this.ingameChatManager.handleMouse(mouseX, mouseY, -1, EnumMouseAction.RENDER);
        moduleGui.a(mouseX, mouseY, partialTicks);
        this.drawButtons(mouseX, mouseY, partialTicks);
        String value = LabyModCore.getMinecraft().getClickEventValue(Mouse.getX(), Mouse.getY());
        if (LabyMod.getSettings().hoverNameHistory && value != null && value.startsWith("/msg ")) {
            String name = value.replace("/msg ", "").replace(" ", "");
            if (NameHistoryUtil.isInCache(name)) {
                NameHistory history = NameHistoryUtil.getNameHistory(name);
                ArrayList<String> lines = new ArrayList<String>();
                boolean currentName = true;
                if (history != null) {
                    for (UUIDFetcher change : history.getChanges()) {
                        if (change.changedToAt != 0L) {
                            String date = ModUtils.getTimeDiff(change.changedToAt);
                            String c2 = "7";
                            if (currentName) {
                                c2 = "6";
                            }
                            currentName = false;
                            lines.add(ModColor.cl(c2) + (change.hidden ? "<hidden>" : change.username) + ModColor.cl("8") + " - " + ModColor.cl("8") + date);
                            continue;
                        }
                        lines.add(ModColor.cl("a") + (change.hidden ? "<hidden>" : change.username));
                    }
                    this.a(lines, mouseX, mouseY);
                }
                bfl.f();
            } else {
                ArrayList<String> lines = new ArrayList<String>();
                lines.add(LanguageManager.translate("ingame_chat_rightclick_for_namechanges"));
                this.a(lines, mouseX, mouseY);
                bfl.f();
            }
        }
    }

    private void drawModifiedSuperScreen(int mouseX, int mouseY, float partialTicks) {
        GuiChatCustom.a((int)2, (int)(this.m - 14), (int)(this.l - 2 - this.chatButtons.length * 14), (int)(this.m - 2), (int)Integer.MIN_VALUE);
        this.a.g();
        this.a(this.j.q.d().a(Mouse.getX(), Mouse.getY()), mouseX, mouseY);
        for (int i = 0; i < this.n.size(); ++i) {
            LabyModCore.getMinecraft().drawButton((avs)this.n.get(i), mouseX, mouseY);
        }
        for (int j = 0; j < this.o.size(); ++j) {
            ((avy)this.o.get(j)).a(this.j, mouseX, mouseY);
        }
    }

    public void b(String msg, boolean addToChat) {
        boolean cancelled = false;
        for (Shortcuts.Shortcut shortcut : LabyMod.getInstance().getChatToolManager().getShortcuts()) {
            try {
                msg = msg.replace(shortcut.getShortcut(), String.format(shortcut.getReplacement(), LabyMod.getInstance().getPlayerName()));
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
        for (MessageSendEvent messageSend : LabyMod.getInstance().getEventManager().getMessageSend()) {
            if (!messageSend.onSend(msg) || cancelled) continue;
            cancelled = true;
        }
        if (cancelled) {
            if (addToChat) {
                this.j.q.d().a(msg);
            }
            return;
        }
        super.b(msg, addToChat);
    }

    private class ChatButton {
        private int id;
        private String displayName;
        private boolean enabled;
        private zx item;
        private ControlElement.IconData iconData;

        public ChatButton(int id, String languageKey, ControlElement.IconData iconData, boolean enabled) {
            this.id = id;
            this.displayName = LanguageManager.translate("ingame_chat_tab_" + languageKey);
            this.item = iconData.hasMaterialIcon() ? iconData.getMaterialIcon().createItemStack() : null;
            this.iconData = iconData;
            this.enabled = enabled;
        }

        public int getId() {
            return this.id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public zx getItem() {
            return this.item;
        }

        public ControlElement.IconData getIconData() {
            return this.iconData;
        }
    }
}

