/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.gui.elements;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.labymod.core.LabyModCore;
import net.labymod.gui.GuiServerList;
import net.labymod.gui.ModGuiIngameMenu;
import net.labymod.gui.ModGuiMultiplayer;
import net.labymod.gui.account.GuiAccountManager;
import net.labymod.gui.elements.DropDownMenu;
import net.labymod.gui.elements.MultiplayerTabs;
import net.labymod.gui.elements.TabbedGuiButton;
import net.labymod.labyconnect.gui.GuiFriendsLayout;
import net.labymod.labyconnect.gui.GuiFriendsNotConnected;
import net.labymod.labyconnect.user.ChatUser;
import net.labymod.labyplay.gui.GuiPlayLayout;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.main.lang.LanguageManager;
import net.labymod.settings.LabyModAddonsGui;
import net.labymod.settings.LabyModModuleEditorGui;
import net.labymod.settings.LabyModSettingsGui;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;

public class Tabs {
    private static Map<String, Class<? extends axu>[]> guiMap = new LinkedHashMap<String, Class<? extends axu>[]>();
    private static Map<String, jy> iconMap = new LinkedHashMap<String, jy>();
    public static String lastOpenScreen = null;
    private static List<Consumer<Map<String, Class<? extends axu>[]>>> tabUpdateListener = new ArrayList<Consumer<Map<String, Class<? extends axu>[]>>>();
    private static Class<? extends axu> lastInitializedScreen;
    private static List<avs> buttonList;
    private static avs hoverButton;
    private static final avs BUTTON_ARROW_RIGHT;
    private static final DropDownMenu<avs> DROPDOWN;

    public static void registerTab(String title, Class<? extends axu> screen) {
        Tabs.registerTab(title, null, screen);
    }

    public static void registerTab(final String title, final jy icon, final Class<? extends axu> screen) {
        tabUpdateListener.add(new Consumer<Map<String, Class<? extends axu>[]>>(){

            @Override
            public void accept(Map<String, Class<? extends axu>[]> accepted) {
                guiMap.put(title, new Class[]{screen});
                if (icon != null && LabyMod.getSettings().tabIcons) {
                    iconMap.put(title, icon);
                }
            }
        });
    }

    private static void init(axu screen) {
        buttonList.clear();
        guiMap.clear();
        iconMap.clear();
        if (LabyMod.getInstance().isInGame()) {
            guiMap.put("tab_menu", new Class[]{ModGuiIngameMenu.class});
        }
        if (LabyMod.getSettings().multiplayerIngame || !LabyMod.getInstance().isInGame()) {
            guiMap.put("tab_multiplayer", new Class[]{ModGuiMultiplayer.class, GuiServerList.class, GuiPlayLayout.class});
        }
        guiMap.put("tab_chat", new Class[]{GuiFriendsLayout.class, GuiFriendsNotConnected.class});
        if (LabyMod.getSettings().labymodSettingsInTabs) {
            guiMap.put("tab_labymod", new Class[]{LabyModSettingsGui.class});
            guiMap.put("tab_gui", new Class[]{LabyModModuleEditorGui.class});
            guiMap.put("tab_addons", new Class[]{LabyModAddonsGui.class});
        }
        if (LabyMod.getSettings().tabIcons) {
            iconMap.put("tab_multiplayer", ModTextures.TAB_MULTIPLAYER);
            iconMap.put("tab_labymod", ModTextures.LOGO_LABYMOD_LOGO);
            iconMap.put("tab_gui", ModTextures.TAB_GUI);
            iconMap.put("tab_addons", ModTextures.TAB_ADDONS);
            iconMap.put("tab_chat", ModTextures.TAB_CHAT);
        }
        for (Consumer<Map<String, Class<? extends axu>[]>> consumer : tabUpdateListener) {
            consumer.accept(guiMap);
        }
        int positionX = 0;
        int index = 0;
        final DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        for (Map.Entry<String, Class<? extends axu>[]> guiEntry : guiMap.entrySet()) {
            String displayString = LanguageManager.translate(guiEntry.getKey());
            boolean isSelected = false;
            for (Class<? extends axu> guiClass : guiEntry.getValue()) {
                Class<? extends axu> screenClass;
                if (screen == null || !(screenClass = screen.getClass()).isAssignableFrom(guiClass)) continue;
                isSelected = true;
                break;
            }
            if (!isSelected && guiEntry.getKey().equals("tab_chat")) {
                int count = 0;
                for (ChatUser chatUser : LabyMod.getInstance().getLabyConnect().getFriends()) {
                    count += chatUser.getUnreadMessages();
                }
                if (count != 0) {
                    displayString = displayString + ModColor.cl('c') + " (" + count + ")";
                }
            }
            jy icon = iconMap.get(guiEntry.getKey());
            int nameWidth = draw.getStringWidth(displayString) + (icon == null ? 0 : 15);
            TabbedGuiButton button = new TabbedGuiButton(icon, 100 + index, 5 + positionX, 5, 10 + nameWidth, 20, displayString);
            button.l = !isSelected;
            buttonList.add(button);
            if (lastOpenScreen != null && lastOpenScreen.equals(guiEntry.getKey()) && !isSelected) {
                Tabs.actionPerformed(button);
                break;
            }
            positionX += nameWidth + 12;
            ++index;
        }
        if (!LabyMod.getInstance().getLabyPlay().getPartySystem().hasParty() && screen != null) {
            String displayString = LanguageManager.translate("tab_account");
            int nameWidth = draw.getStringWidth(displayString) + 15;
            double screenWidth = screen.l;
            if (screen instanceof LabyModModuleEditorGui) {
                avr scaled = new avr(ave.A());
                double rescale = (double)scaled.e() / LabyMod.getInstance().getDrawUtils().getCustomScaling();
                screenWidth = (double)screen.l / rescale;
            }
            TabbedGuiButton button = new TabbedGuiButton(ModTextures.MISC_HEAD_QUESTION, 200, (int)(screenWidth - (double)nameWidth - 12.0), 5, 10 + nameWidth, 20, displayString);
            button.setRightBound(true);
            button.setIconRenderCallback(new TabbedGuiButton.IconRenderCallback(){

                @Override
                public void render(int x, int y, int iconSize) {
                    if (ave.A().L() != null && ave.A().L().e() != null) {
                        draw.drawPlayerHead(ave.A().L().e(), x, y, iconSize);
                    } else {
                        draw.drawTexture(x, y, 255.0, 255.0, iconSize, iconSize);
                    }
                }
            });
            buttonList.add(button);
        }
    }

    public static void initGui(axu screen) {
        Tabs.init(screen);
    }

    public static void drawScreen(axu screen, int mouseX, int mouseY) {
        bfl.E();
        if (screen instanceof LabyModModuleEditorGui) {
            avr scaled = LabyMod.getInstance().getDrawUtils().getScaledResolution();
            double rescale = (double)scaled.e() / LabyMod.getInstance().getDrawUtils().getCustomScaling();
            bfl.a((double)rescale, (double)rescale, (double)1.0);
        }
        Tabs.drawScreen(0, 0, mouseX, mouseY);
        bfl.F();
    }

    public static void drawScreen(int x, int y, int mouseX, int mouseY) {
        if (lastInitializedScreen == null) {
            lastInitializedScreen = ave.A().m.getClass();
            Tabs.init(ave.A().m);
        }
        bfl.E();
        bfl.b((float)x, (float)y, (float)0.0f);
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        int rightBoundWidth = 30;
        for (avs button : buttonList) {
            if (!(button instanceof TabbedGuiButton) || !((TabbedGuiButton)button).isRightBound()) continue;
            rightBoundWidth += button.b();
        }
        boolean prevOpen = DROPDOWN.isOpen();
        hoverButton = null;
        DROPDOWN.clear();
        DROPDOWN.setOpen(prevOpen);
        double rescale = 1.0;
        if (ave.A().m != null && ave.A().m instanceof LabyModModuleEditorGui) {
            avr scaled = LabyMod.getInstance().getDrawUtils().getScaledResolution();
            rescale = (double)scaled.e() / LabyMod.getInstance().getDrawUtils().getCustomScaling();
        }
        int lastLeftBoundButtonX = -1;
        int maxDropdownWidth = 0;
        for (avs button : buttonList) {
            int buttonX;
            if (!(button instanceof TabbedGuiButton && ((TabbedGuiButton)button).isRightBound() || !((double)((buttonX = LabyModCore.getMinecraft().getXPosition(button)) + button.b()) > (double)draw.getWidth() / rescale - (double)rightBoundWidth))) {
                if (lastLeftBoundButtonX == -1) {
                    lastLeftBoundButtonX = buttonX;
                }
                DROPDOWN.addOption(button);
                maxDropdownWidth = Math.max(button.b(), maxDropdownWidth);
                continue;
            }
            LabyModCore.getMinecraft().drawButton(button, mouseX, mouseY);
            if (!button.a()) continue;
            hoverButton = button;
        }
        if (lastLeftBoundButtonX != -1) {
            LabyModCore.getMinecraft().setButtonXPosition(BUTTON_ARROW_RIGHT, lastLeftBoundButtonX);
            LabyModCore.getMinecraft().drawButton(BUTTON_ARROW_RIGHT, mouseX, mouseY);
            if (BUTTON_ARROW_RIGHT.a()) {
                hoverButton = BUTTON_ARROW_RIGHT;
            }
            if (DROPDOWN.isOpen()) {
                DROPDOWN.setWidth(maxDropdownWidth);
                double scaledMouseX = (double)mouseX / rescale;
                double scaledMouseY = (double)mouseY / rescale;
                bfl.j();
                bfl.a((boolean)true);
                bfl.b((float)0.0f, (float)0.0f, (float)1.0f);
                DROPDOWN.drawMenuDirect(lastLeftBoundButtonX + 1, 4, (int)scaledMouseX, (int)scaledMouseY);
                bfl.b((float)0.0f, (float)0.0f, (float)-1.0f);
            }
        }
        bfl.F();
        LabyMod.getInstance().getGuiCustomAchievement().updateAchievementWindow();
    }

    public static boolean mouseClicked(axu screen) {
        if (hoverButton != null) {
            Tabs.actionPerformed(hoverButton);
        } else if (DROPDOWN.isOpen()) {
            DROPDOWN.setOpen(false);
            if (DROPDOWN.getHoverSelected() != null) {
                Tabs.actionPerformed(DROPDOWN.getHoverSelected());
                return true;
            }
        }
        return false;
    }

    private static void actionPerformed(avs button) {
        int index = 0;
        for (Map.Entry<String, Class<? extends axu>[]> guiEntry : guiMap.entrySet()) {
            if (button.k == 100 + index) {
                axu screen = Tabs.getGuiScreenByClass(guiEntry.getValue());
                if (screen == null) break;
                lastOpenScreen = LabyMod.getInstance().isInGame() ? guiEntry.getKey() : null;
                ave.A().a(screen);
                break;
            }
            ++index;
        }
        if (button.k == 200) {
            ave.A().a((axu)new GuiAccountManager(ave.A().m));
        }
        if (button.k == Tabs.BUTTON_ARROW_RIGHT.k) {
            DROPDOWN.setOpen(!DROPDOWN.isOpen());
        } else {
            DROPDOWN.setOpen(false);
        }
    }

    private static axu getGuiScreenByClass(Class<? extends axu>[] guiScreenClasses) {
        for (Class<? extends axu> guiClass : guiScreenClasses) {
            if (!azh.class.isAssignableFrom(guiClass)) continue;
            return new ModGuiMultiplayer((axu)(LabyMod.getInstance().isInGame() ? new axp() : new aya()));
        }
        try {
            return guiScreenClasses[0].newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Deprecated
    public static void initGuiScreen(List<avs> list, axu screen) {
        Tabs.init(screen);
        list.addAll(buttonList);
    }

    @Deprecated
    public static void drawParty(int mouseX, int mouseY, int width) {
        MultiplayerTabs.drawParty(mouseX, mouseY, width);
    }

    @Deprecated
    public static void actionPerformedButton(avs button) {
        Tabs.actionPerformed(button);
    }

    @Deprecated
    public static Map<String, Class<? extends axu>[]> getGuiMap() {
        return guiMap;
    }

    @Deprecated
    public static List<Consumer<Map<String, Class<? extends axu>[]>>> getTabUpdateListener() {
        return tabUpdateListener;
    }

    static {
        buttonList = new ArrayList<avs>();
        BUTTON_ARROW_RIGHT = new TabbedGuiButton(1337, 0, 5, 20, 20, "...");
        DROPDOWN = new DropDownMenu("", 0, 5, 100, 20);
        DROPDOWN.setEntryDrawer(new DropDownMenu.DropDownEntryDrawer(){

            @Override
            public void draw(Object object, int x, int y, String trimmedEntry) {
                LabyMod.getInstance().getDrawUtils().drawString(((avs)object).j, x, y);
            }
        });
    }
}

