/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.gui.elements;

import net.labymod.main.LabyMod;

public class GuiImageButton
extends avp {
    private jy imageResource;
    private jy hoverImageResource;
    private int offsetX;
    private int offsetY;
    private int hoverOffsetX;
    private int hoverOffsetY;
    private int textureSizeX;
    private int textureSizeY;
    private double x;
    private double y;
    private double width;
    private double height;
    private double imageHoverZoom = 0.5;
    private float imageAlpha = 1.0f;
    private float imageAlphaHover = 1.0f;
    private boolean enabled = true;

    public GuiImageButton(jy imageResource, jy hoverImageResource) {
        this.imageResource = imageResource;
        this.hoverImageResource = hoverImageResource;
    }

    public GuiImageButton(jy imageResource) {
        this(imageResource, imageResource);
    }

    public GuiImageButton(jy imageResource, int offsetX, int offsetY, int hoverOffsetX, int hoverOffsetY, int textureSizeX, int textureSizeY) {
        this.imageResource = imageResource;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.hoverOffsetX = hoverOffsetX;
        this.hoverOffsetY = hoverOffsetY;
        this.textureSizeX = textureSizeX;
        this.textureSizeY = textureSizeY;
    }

    public GuiImageButton(jy imageResource, int offsetX, int offsetY, int textureSizeX, int textureSizeY) {
        this(imageResource, offsetX, offsetY, offsetX, offsetY, textureSizeX, textureSizeY);
    }

    public void init(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void init(double x, double y, double size) {
        this.init(x, y, size, size);
    }

    public void draw(double x, double y, double width, double height, int mouseX, int mouseY) {
        this.init(x, y, width, height);
        this.draw(mouseX, mouseY);
    }

    public void draw(double x, double y, double size, int mouseX, int mouseY) {
        this.init(x, y, size);
        this.draw(mouseX, mouseY);
    }

    public void draw(int mouseX, int mouseY) {
        boolean mouseOver = this.isMouseOver(mouseX, mouseY);
        double zoom = mouseOver ? this.imageHoverZoom : 0.0;
        boolean usingTextureMap = this.hoverImageResource == null;
        ave.A().P().a(mouseOver && !usingTextureMap ? this.hoverImageResource : this.imageResource);
        if (usingTextureMap) {
            LabyMod.getInstance().getDrawUtils().drawTexture(this.x - zoom, this.y - zoom, mouseOver ? (double)this.hoverOffsetX : (double)this.offsetX, mouseOver ? (double)this.hoverOffsetY : (double)this.offsetY, this.textureSizeX, this.textureSizeY, this.width + zoom * 2.0, this.height + zoom * 2.0, mouseOver ? this.imageAlphaHover : this.imageAlpha);
        } else {
            LabyMod.getInstance().getDrawUtils().drawTexture(this.x - zoom, this.y - zoom, 255.0, 255.0, this.width + zoom * 2.0, this.height + zoom * 2.0, mouseOver ? this.imageAlphaHover : this.imageAlpha);
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return (double)mouseX > this.x && (double)mouseX < this.x + this.width && (double)mouseY > this.y && (double)mouseY < this.y + this.height && this.enabled;
    }

    public void setImageHoverZoom(double imageHoverZoom) {
        this.imageHoverZoom = imageHoverZoom;
    }

    public void setImageAlpha(float imageAlpha) {
        this.imageAlpha = imageAlpha;
    }

    public void setImageAlphaHover(float imageAlphaHover) {
        this.imageAlphaHover = imageAlphaHover;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

