/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.gui.elements;

import java.awt.Color;
import java.io.IOException;
import net.labymod.core.LabyModCore;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.settings.LabyModModuleEditorGui;
import net.labymod.settings.PreviewRenderer;
import net.labymod.utils.Consumer;
import net.labymod.utils.ModColor;
import net.labymod.utils.manager.TooltipHelper;

public class ColorPicker
extends avp {
    private static final int[] ADVANCED_COLORS = new int[]{-4842468, -7795121, -11922292, -13624430, -15064194, -15841375, -16754788, -16687004, -16757697, -14918112, -13407970, -8292586, -753898, -37120, -1683200, -4246004, -12704222, -14606047, -14208456};
    private String title;
    private int x;
    private int y;
    private int width;
    private int height;
    private Color selectedColor;
    private Color colorForPreview;
    private boolean openedSelector;
    private boolean hoverSlider = false;
    private boolean hasAdvanced = false;
    private boolean hoverAdvancedButton = false;
    private boolean hoverDefaultButton;
    private boolean hasDefault = false;
    private boolean isDefault = true;
    private DefaultColorCallback defaultColor;
    private Consumer<Color> updateListener;

    public ColorPicker(String title, Color selectedColor, DefaultColorCallback defaultColorCallback, int x, int y, int width, int height) {
        this.title = title;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.selectedColor = selectedColor;
        this.colorForPreview = selectedColor;
        this.defaultColor = defaultColorCallback;
    }

    public void onGuiClosed() {
        if (this.colorForPreview != this.selectedColor && this.updateListener != null) {
            this.updateListener.accept(this.selectedColor);
        }
    }

    public void drawColorPicker(int mouseX, int mouseY) {
        LabyMod.getInstance().getDrawUtils().drawCenteredString(this.title, this.x + this.width / 2, this.y - 5, 0.5);
        ColorPicker.a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)(this.openedSelector ? -1 : Integer.MAX_VALUE));
        int bgColor = this.colorForPreview == null ? (this.defaultColor == null ? (this.openedSelector ? Integer.MIN_VALUE : Integer.MAX_VALUE) : this.defaultColor.getDefaultColor().getRGB()) : this.colorForPreview.getRGB();
        ColorPicker.a((int)(this.x + 1), (int)(this.y + 1), (int)(this.x + this.width - 1), (int)(this.y + this.height - 1), (int)bgColor);
        if (this.hasDefault && this.selectedColor == null && this.isDefault) {
            ave.A().P().a(ModTextures.BUTTON_HOVER_DEFAULT);
            Color color = new Color(bgColor);
            int luma = (int)(0.2126f * (float)color.getRed() + 0.7152f * (float)color.getGreen() + 0.0722f * (float)color.getBlue());
            luma = 255 - luma;
            if (luma < 80) {
                bfl.c((float)((float)luma / 255.0f), (float)((float)luma / 255.0f), (float)((float)luma / 255.0f), (float)1.0f);
                LabyMod.getInstance().getDrawUtils().drawTexture(this.x + 2, this.y + 2, 256.0, 256.0, this.width - 4, this.height - 4, 1.1f);
            } else {
                LabyMod.getInstance().getDrawUtils().drawTexture(this.x + 2, this.y + 2, 256.0, 256.0, this.width - 4, this.height - 4);
            }
            if (this.isMouseOver(mouseX, mouseY)) {
                TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 200L, "Default");
            }
        }
        if (this.openedSelector) {
            this.drawColorsAndButtons(mouseX, mouseY);
        }
    }

    private Color getContrastColor(int r, int g2, int b2) {
        double y = (299 * r + 587 * g2 + 114 * b2) / 1000;
        return y >= 128.0 ? Color.black : Color.white;
    }

    private void drawColorsAndButtons(int mouseX, int mouseY) {
        int widthPerColor = 13;
        int sliderHeight = 13;
        int sliderWidth = 0;
        for (ModColor color : ModColor.values()) {
            if (color.getColor() == null) continue;
            sliderWidth += widthPerColor;
        }
        int sliderX = this.x - sliderWidth / 2 + this.width / 2;
        int sliderY = this.y + this.height + 4;
        if (this.hasAdvanced) {
            sliderX -= 20;
        }
        int minX = this.hasDefault && this.selectedColor != null ? 20 : 5;
        int maxX = LabyMod.getInstance().getDrawUtils().getWidth() - 5;
        int maxY = LabyMod.getInstance().getDrawUtils().getHeight() - 5;
        if (sliderX + sliderWidth > maxX) {
            sliderX -= sliderX + sliderWidth - maxX;
        }
        if (sliderX < minX) {
            sliderX = minX;
        }
        if (sliderY > maxY) {
            sliderY = maxY - sliderHeight - this.height;
        } else {
            ColorPicker.a((int)(this.x + this.width / 2 - 1), (int)(sliderY - 3), (int)(this.x + this.width / 2 + 1), (int)(sliderY - 2), (int)Integer.MAX_VALUE);
            ColorPicker.a((int)(this.x + this.width / 2 - 2), (int)(sliderY - 2), (int)(this.x + this.width / 2 + 2), (int)(sliderY - 1), (int)Integer.MAX_VALUE);
        }
        if (!(ave.A().m instanceof AdvancedColorSelectorGui)) {
            this.drawSlider(mouseX, mouseY, sliderX, sliderY, sliderWidth, sliderHeight, widthPerColor);
            this.drawButtons(mouseX, mouseY, sliderX, sliderY, sliderWidth, sliderHeight, widthPerColor);
        }
        this.hoverAdvancedButton = mouseX > sliderX + sliderWidth + 3 - 1 && mouseX < sliderX + sliderWidth + 3 + widthPerColor + 1 && mouseY > sliderY - 1 && mouseY < sliderY + sliderHeight + 1;
        this.hoverSlider = mouseX > sliderX && mouseX < sliderX + sliderWidth + widthPerColor && mouseY > sliderY && mouseY < sliderY + sliderHeight;
        this.hoverDefaultButton = mouseX > sliderX - 3 - widthPerColor - 1 && mouseX < sliderX - 3 + 1 && mouseY > sliderY - 1 && mouseY < sliderY + sliderHeight + 1;
    }

    private void drawSlider(int mouseX, int mouseY, int sliderX, int sliderY, int sliderWidth, int sliderHeight, int widthPerColor) {
        ColorPicker.a((int)(sliderX - 1), (int)(sliderY - 1), (int)(sliderX + sliderWidth + 1), (int)(sliderY + sliderHeight + 1), (int)Integer.MAX_VALUE);
        int pos = 0;
        int hoverPos = -1;
        int selectedPos = -1;
        ModColor hoverColorType = null;
        ModColor selectedColorType = null;
        for (ModColor color : ModColor.values()) {
            boolean hoverColor;
            if (color.getColor() == null) continue;
            ColorPicker.a((int)(sliderX + pos), (int)sliderY, (int)(sliderX + pos + widthPerColor), (int)(sliderY + sliderHeight), (int)color.getColor().getRGB());
            boolean bl = hoverColor = mouseX > sliderX + pos && mouseX < sliderX + pos + widthPerColor + 1 && mouseY > sliderY && mouseY < sliderY + sliderHeight;
            if (hoverPos == -1 && hoverColorType == null && hoverColor) {
                hoverPos = pos;
                hoverColorType = color;
            }
            if (color.getColor() == this.selectedColor) {
                selectedPos = pos;
                selectedColorType = color;
            }
            pos += widthPerColor;
        }
        if (hoverColorType != null) {
            ColorPicker.a((int)(sliderX + hoverPos - 1), (int)(sliderY - 1), (int)(sliderX + hoverPos + widthPerColor + 1), (int)(sliderY + sliderHeight + 1), (int)hoverColorType.getColor().getRGB());
            this.colorForPreview = hoverColorType.getColor();
            if (this.updateListener != null) {
                this.updateListener.accept(this.colorForPreview);
            }
        } else {
            this.colorForPreview = this.selectedColor;
            if (this.updateListener != null) {
                this.updateListener.accept(this.selectedColor);
            }
        }
        if (selectedColorType != null) {
            ColorPicker.a((int)(sliderX + selectedPos - 1), (int)(sliderY - 1), (int)(sliderX + selectedPos + widthPerColor + 1), (int)(sliderY + sliderHeight + 1), (int)-1);
            ColorPicker.a((int)(sliderX + selectedPos), (int)sliderY, (int)(sliderX + selectedPos + widthPerColor), (int)(sliderY + sliderHeight), (int)selectedColorType.getColor().getRGB());
        }
    }

    private void drawAdvanced(int mouseX, int mouseY, int advancedX, int advancedY, int advancedWidth) {
        double widthPerColor;
        int alphaCount = 12;
        double heightPerColor = widthPerColor = (double)advancedWidth / (double)ADVANCED_COLORS.length;
        ColorPicker.a((int)(advancedX - 1), (int)(advancedY - 1), (int)((int)((double)advancedX + widthPerColor * (double)ADVANCED_COLORS.length + 1.0)), (int)((int)((double)advancedY + heightPerColor * (double)alphaCount + 1.0)), (int)Integer.MAX_VALUE);
        double hoverPosX = -1.0;
        double hoverPosY = -1.0;
        Color hoveredColorType = null;
        double selectedPosX = -1.0;
        double selectedPosY = -1.0;
        Color selectedColorType = null;
        double posX = 0.0;
        for (int color : ADVANCED_COLORS) {
            for (int posY = 0; posY < alphaCount; ++posY) {
                boolean hoverColor;
                int rgb = ModColor.changeBrightness(new Color(color), 0.07f * (float)posY).getRGB();
                ColorPicker.a((int)((int)((double)advancedX + posX)), (int)((int)((double)advancedY + (double)posY * heightPerColor)), (int)((int)((double)advancedX + posX + widthPerColor)), (int)((int)((double)advancedY + (double)posY * heightPerColor + heightPerColor)), (int)rgb);
                boolean bl = hoverColor = (double)mouseX > (double)advancedX + posX && (double)mouseX < (double)advancedX + posX + widthPerColor + 1.0 && (double)mouseY > (double)advancedY + (double)posY * heightPerColor && (double)mouseY < (double)advancedY + (double)posY * heightPerColor + heightPerColor + 1.0;
                if (hoverColor) {
                    hoverPosX = posX;
                    hoverPosY = posY;
                    hoveredColorType = new Color(rgb);
                }
                if (this.selectedColor == null || rgb != this.selectedColor.getRGB()) continue;
                selectedPosX = posX;
                selectedPosY = posY;
                selectedColorType = this.selectedColor;
            }
            posX += widthPerColor;
        }
        if (hoveredColorType != null) {
            ColorPicker.a((int)((int)((double)advancedX + hoverPosX - 1.0)), (int)((int)((double)advancedY + hoverPosY * heightPerColor - 1.0)), (int)((int)((double)advancedX + hoverPosX + widthPerColor + 1.0)), (int)((int)((double)advancedY + hoverPosY * heightPerColor + heightPerColor + 1.0)), (int)hoveredColorType.getRGB());
            this.colorForPreview = hoveredColorType;
            if (this.updateListener != null) {
                this.updateListener.accept(this.colorForPreview);
            }
        } else {
            this.colorForPreview = this.selectedColor;
            if (this.updateListener != null) {
                this.updateListener.accept(this.selectedColor);
            }
        }
        if (selectedColorType != null) {
            ColorPicker.a((int)((int)((double)advancedX + selectedPosX - 1.0)), (int)((int)((double)advancedY + selectedPosY * heightPerColor - 1.0)), (int)((int)((double)advancedX + selectedPosX + widthPerColor + 1.0)), (int)((int)((double)advancedY + selectedPosY * heightPerColor + heightPerColor + 1.0)), (int)-1);
            ColorPicker.a((int)((int)((double)advancedX + selectedPosX)), (int)((int)((double)advancedY + selectedPosY * heightPerColor)), (int)((int)((double)advancedX + selectedPosX + widthPerColor)), (int)((int)((double)advancedY + selectedPosY * heightPerColor + heightPerColor)), (int)selectedColorType.getRGB());
        }
    }

    private void drawButtons(int mouseX, int mouseY, int sliderX, int sliderY, int sliderWidth, int sliderHeight, int widthPerColor) {
        if (this.hasDefault && this.selectedColor != null) {
            ColorPicker.a((int)(sliderX - 3 - widthPerColor - 1), (int)(sliderY - 1), (int)(sliderX - 3 + 1), (int)(sliderY + sliderHeight + 1), (int)(this.hoverDefaultButton ? -1 : Integer.MAX_VALUE));
            ColorPicker.a((int)(sliderX - 3 - widthPerColor), (int)sliderY, (int)(sliderX - 3), (int)(sliderY + sliderHeight), (int)Integer.MIN_VALUE);
            LabyMod.getInstance().getDrawUtils().fontRenderer.a("D", (float)(sliderX - 3 - widthPerColor / 2 - 3), (float)(sliderY + sliderHeight / 2 - 3), -1, false);
            if (this.hoverDefaultButton) {
                this.updateListener.accept(null);
                this.colorForPreview = this.defaultColor.getDefaultColor();
            }
        }
        if (this.hasAdvanced) {
            ColorPicker.a((int)(sliderX + sliderWidth + 3 - 1), (int)(sliderY - 1), (int)(sliderX + sliderWidth + 3 + widthPerColor + 1), (int)(sliderY + sliderHeight + 1), (int)(this.hoverAdvancedButton ? -1 : Integer.MAX_VALUE));
            ColorPicker.a((int)(sliderX + sliderWidth + 3), (int)sliderY, (int)(sliderX + sliderWidth + 3 + widthPerColor), (int)(sliderY + sliderHeight), (int)-1);
            int iconX = sliderX + sliderWidth + 3;
            int iconY = sliderY;
            double pxlX = iconX;
            for (int color : ADVANCED_COLORS) {
                int pxlY = iconY;
                for (int i = 0; i < 13; ++i) {
                    Color theColor = new Color(color + i * 2000);
                    int rgb = ModColor.toRGB(theColor.getRed(), theColor.getGreen(), theColor.getBlue(), 255 - i * 18);
                    ColorPicker.a((int)((int)pxlX), (int)pxlY, (int)((int)pxlX + 1), (int)(pxlY + 1), (int)rgb);
                    ++pxlY;
                }
                pxlX += 0.7;
            }
            if (this.hoverAdvancedButton) {
                TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, "More colors");
            }
        }
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.openedSelector = !this.openedSelector;
            return true;
        }
        if (this.openedSelector) {
            if (this.hoverSlider) {
                this.selectedColor = this.colorForPreview;
                if (this.updateListener != null) {
                    this.updateListener.accept(this.selectedColor);
                }
            }
            if (this.hasDefault && this.selectedColor != null && this.hoverDefaultButton) {
                this.selectedColor = null;
                this.colorForPreview = this.defaultColor.getDefaultColor();
                if (this.updateListener != null) {
                    this.updateListener.accept(this.selectedColor);
                }
                return true;
            }
            if (this.hasAdvanced && this.hoverAdvancedButton) {
                ave.A().a((axu)new AdvancedColorSelectorGui(this, ave.A().m, new Consumer<axu>(){

                    @Override
                    public void accept(axu lastScreen) {
                        ave.A().a(lastScreen);
                    }
                }));
                return true;
            }
        }
        boolean flag = this.openedSelector;
        this.openedSelector = false;
        return flag != this.openedSelector;
    }

    public boolean mouseDragging(int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    public boolean mouseReleased(int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    public void setSelectedColor(Color selectedColor) {
        this.selectedColor = selectedColor;
        this.colorForPreview = selectedColor;
    }

    public boolean isHoverAdvancedButton() {
        return this.hoverAdvancedButton;
    }

    public boolean isHoverDefaultButton() {
        return this.hoverDefaultButton;
    }

    public boolean isHoverSlider() {
        return this.hoverSlider;
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX > this.x && mouseX < this.x + this.width && mouseY > this.y && mouseY < this.y + this.height;
    }

    public String getTitle() {
        return this.title;
    }

    public Color getColorForPreview() {
        return this.colorForPreview;
    }

    public void setHasDefault(boolean hasDefault) {
        this.hasDefault = hasDefault;
    }

    public void setDefault(boolean aDefault) {
        this.isDefault = aDefault;
    }

    public void setHasAdvanced(boolean hasAdvanced) {
        this.hasAdvanced = hasAdvanced;
    }

    public void setUpdateListener(Consumer<Color> updateListener) {
        this.updateListener = updateListener;
    }

    public static interface DefaultColorCallback {
        public Color getDefaultColor();
    }

    public class AdvancedColorSelectorGui
    extends axu {
        private axu backgroundScreen;
        private Consumer<axu> callback;
        private ColorPicker colorPicker;
        private avw fieldHexColor;
        private Color lastColor = null;
        private boolean validHex = true;

        public AdvancedColorSelectorGui(ColorPicker colorPicker, axu backgroundScreen, Consumer<axu> callback) {
            this.backgroundScreen = backgroundScreen;
            this.callback = callback;
            this.colorPicker = colorPicker;
        }

        public void b() {
            super.b();
            this.backgroundScreen.l = this.l;
            this.backgroundScreen.m = this.m;
            if (this.backgroundScreen instanceof LabyModModuleEditorGui) {
                PreviewRenderer.getInstance().init(AdvancedColorSelectorGui.class);
            }
            this.fieldHexColor = new avw(0, LabyModCore.getMinecraft().getFontRenderer(), this.l / 2 - 70, this.m / 4 + 115, 100, 16);
            this.fieldHexColor.f(7);
            this.lastColor = null;
            this.n.add(new avs(1, this.l / 2 + 40, this.m / 4 + 113, 60, 20, "Done"));
        }

        public void m() {
            this.backgroundScreen.m();
            super.m();
        }

        public void a(int mouseX, int mouseY, float partialTicks) {
            this.backgroundScreen.a(mouseX, mouseY, partialTicks);
            AdvancedColorSelectorGui.a((int)0, (int)0, (int)this.l, (int)this.m, (int)Integer.MIN_VALUE);
            this.colorPicker.drawColorPicker(mouseX, mouseY);
            AdvancedColorSelectorGui.a((int)(this.l / 2 - 105), (int)(this.m / 4 - 25), (int)(this.l / 2 + 105), (int)(this.m / 4 + 140), (int)Integer.MIN_VALUE);
            this.colorPicker.drawAdvanced(mouseX, mouseY, this.l / 2 - 100, this.m / 4 - 20, 200);
            AdvancedColorSelectorGui.a((int)(LabyModCore.getMinecraft().getXPosition(this.fieldHexColor) - 2), (int)(LabyModCore.getMinecraft().getYPosition(this.fieldHexColor) - 2), (int)(LabyModCore.getMinecraft().getXPosition(this.fieldHexColor) + 100 + 2), (int)(LabyModCore.getMinecraft().getYPosition(this.fieldHexColor) + 16 + 2), (int)(this.validHex ? ModColor.toRGB(85, 255, 85, 100) : ModColor.toRGB(255, 85, 85, 100)));
            this.fieldHexColor.g();
            if (this.colorPicker.colorForPreview == null) {
                this.colorPicker.colorForPreview = this.colorPicker.defaultColor.getDefaultColor();
            }
            AdvancedColorSelectorGui.a((int)(this.l / 2 - 100), (int)(this.m / 4 + 113), (int)(this.l / 2 - 100 + 20), (int)(this.m / 4 + 113 + 20), (int)Integer.MAX_VALUE);
            AdvancedColorSelectorGui.a((int)(this.l / 2 - 100 + 1), (int)(this.m / 4 + 113 + 1), (int)(this.l / 2 - 100 + 20 - 1), (int)(this.m / 4 + 113 + 20 - 1), (int)this.colorPicker.colorForPreview.getRGB());
            if (this.lastColor == null || !this.lastColor.equals(this.colorPicker.colorForPreview)) {
                this.lastColor = this.colorPicker.colorForPreview;
                String hex = String.format("#%02x%02x%02x", this.lastColor.getRed(), this.lastColor.getGreen(), this.lastColor.getBlue());
                this.fieldHexColor.a(hex);
                this.validHex = true;
            }
            this.a(LabyModCore.getMinecraft().getFontRenderer(), "Advanced colors", this.l / 2, this.m / 4 - 35, -1);
            super.a(mouseX, mouseY, partialTicks);
        }

        protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
            super.a(mouseX, mouseY, mouseButton);
            this.colorPicker.selectedColor = this.colorPicker.colorForPreview;
            if (this.colorPicker.updateListener != null) {
                this.colorPicker.updateListener.accept(this.colorPicker.selectedColor);
            }
            this.fieldHexColor.a(mouseX, mouseY, mouseButton);
        }

        protected void a(char typedChar, int keyCode) throws IOException {
            if (keyCode == 1) {
                ave.A().a(this.backgroundScreen);
            }
            if (this.fieldHexColor.a(typedChar, keyCode)) {
                String hex = this.fieldHexColor.b();
                if (hex.length() == 7) {
                    try {
                        this.colorPicker.selectedColor = new Color(Integer.valueOf(hex.substring(1, 3), 16), Integer.valueOf(hex.substring(3, 5), 16), Integer.valueOf(hex.substring(5, 7), 16));
                        this.colorPicker.colorForPreview = this.colorPicker.selectedColor;
                        this.validHex = true;
                    }
                    catch (Exception error) {
                        this.validHex = false;
                    }
                } else {
                    this.validHex = false;
                }
            }
        }

        public void e() {
            this.backgroundScreen.e();
            this.fieldHexColor.a();
        }

        protected void a(avs button) throws IOException {
            super.a(button);
            if (button.k == 1) {
                this.colorPicker.openedSelector = false;
                ave.A().a(this.backgroundScreen);
            }
        }

        public axu getBackgroundScreen() {
            return this.backgroundScreen;
        }
    }
}

