/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.gui.account;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import net.labymod.accountmanager.AsyncAccountManager;
import net.labymod.accountmanager.authentication.AsyncAccountAuthentication;
import net.labymod.accountmanager.authentication.microsoft.oauth.OAuthServer;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.loader.external.model.ExternalAccount;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.main.lang.LanguageManager;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;

public class GuiMicrosoftLogin
extends axu {
    private final axu lastScreen;
    private final boolean saveAccount;
    private String lastStatusMessage;
    private OAuthServer oAuth;

    public GuiMicrosoftLogin(axu lastScreen, boolean saveAccount) {
        this.lastScreen = lastScreen;
        this.saveAccount = saveAccount;
        this.lastStatusMessage = ModColor.cl('a') + LanguageManager.translate("microsoft_login_state_new_window");
        try {
            this.oAuth = new OAuthServer();
            LabyMod.getInstance().openWebpage(this.oAuth.getUrl().toString(), false);
            this.oAuth.listenForCodeAsync(code -> {
                if (code == null) {
                    this.lastStatusMessage = ModColor.cl('c') + "Login cancelled";
                } else {
                    this.authUsingCode((String)code);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.lastStatusMessage = ModColor.cl('c') + "Login process already started? Maybe restart your computer...";
        }
    }

    public void m() {
        super.m();
        this.oAuth.close();
    }

    public void b() {
        super.b();
        this.n.add(new avs(0, this.l / 2 - 100, this.m / 2 + 10, LanguageManager.translate("button_cancel")));
    }

    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.a(mouseX, mouseY, mouseButton);
    }

    protected void a(avs button) throws IOException {
        super.a(button);
        if (button.k == 0) {
            ave.A().a(this.lastScreen);
        }
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.c();
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        int listY = 0;
        if (this.lastStatusMessage != null) {
            List<String> list = draw.listFormattedStringToWidth(this.lastStatusMessage, this.l / 2);
            for (String line : list) {
                draw.drawCenteredString(line, (int)((float)this.l / 2.0f), (int)((float)this.m / 2.0f - 30.0f + (float)listY));
                listY += 10;
            }
        }
        int size = 20;
        ave.A().P().a(ModTextures.MISC_MICROSOFT);
        draw.drawTexture((float)this.l / 2.0f - (float)size / 2.0f - 70.0f + 20.0f, 40.0f - (float)size / 2.0f, 256.0, 256.0, size, size);
        draw.drawCenteredString("Microsoft", (float)this.l / 2.0f + 20.0f, 40.0f - (float)size / 2.0f + 3.0f, 2.0);
        super.a(mouseX, mouseY, partialTicks);
    }

    protected void a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            ave.A().a(this.lastScreen);
            return;
        }
        super.a(typedChar, keyCode);
    }

    private void authUsingCode(String code) {
        AsyncAccountManager accountManager = LabyMod.getInstance().getAccountManager();
        AsyncAccountAuthentication auth = (AsyncAccountAuthentication)accountManager.getStorage().getAuthentication();
        auth.getMicrosoftService().setCallback(stateId -> {
            this.lastStatusMessage = ModColor.cl('e') + LanguageManager.translate("microsoft_login_state_" + stateId.name().toLowerCase(Locale.ROOT));
        });
        auth.authenticateMicrosoftAsync(code, account -> {
            try {
                if (this.saveAccount) {
                    accountManager.getStorage().addAccount((ExternalAccount)account);
                    accountManager.saveAsync(new Runnable[0]);
                }
                LabyMod.getInstance().setSession((Account)account);
                ave.A().a(this.lastScreen);
            }
            catch (Exception e) {
                this.lastStatusMessage = ModColor.cl('c') + e.getMessage();
            }
        }, e -> {
            this.lastStatusMessage = ModColor.cl('c') + e.getMessage();
        });
    }
}

