/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.gui.account;

import java.io.IOException;
import java.util.function.Consumer;
import net.labymod.accountmanager.AsyncAccountManager;
import net.labymod.accountmanager.storage.StorageType;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.account.AccountSessionState;
import net.labymod.accountmanager.storage.loader.external.model.ExternalAccount;
import net.labymod.gui.account.GuiAccountChoose;
import net.labymod.gui.elements.Scrollbar;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.main.lang.LanguageManager;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.labymod.utils.manager.TooltipHelper;
import org.lwjgl.opengl.GL11;

public class GuiAccountManager
extends axu {
    private static boolean launcherSessionsRefreshed = false;
    private final AsyncAccountManager accountManager;
    private final axu lastScreen;
    private avs buttonSwitch;
    private avs buttonRemove;
    private final Scrollbar scrollbar;
    private Account selectedAccount;
    private Account hoveredAccount;
    private long lastLoginClick = 0L;

    public GuiAccountManager(axu lastScreen) {
        this.lastScreen = lastScreen;
        this.accountManager = LabyMod.getInstance().getAccountManager();
        if (!launcherSessionsRefreshed) {
            launcherSessionsRefreshed = true;
            this.accountManager.refreshLauncherSessionsAsync(new Consumer<Account>(){

                @Override
                public void accept(Account account) {
                    if (!account.isMicrosoft()) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, new Runnable[0]);
        }
        this.scrollbar = new Scrollbar(21);
        this.scrollbar.setSpeed(15);
    }

    public void b() {
        super.b();
        this.n.clear();
        this.n.add(new avs(0, this.l / 2 - 180, this.m - 25, 60, 20, LanguageManager.translate("button_add")));
        this.buttonRemove = new avs(1, this.l / 2 - 110, this.m - 25, 60, 20, LanguageManager.translate("button_remove"));
        this.n.add(this.buttonRemove);
        this.buttonSwitch = new avs(2, this.l / 2 - 40, this.m - 25, 60, 20, LanguageManager.translate("button_switch"));
        this.n.add(this.buttonSwitch);
        this.n.add(new avs(3, this.l / 2 + 30, this.m - 25, 80, 20, LanguageManager.translate("button_direct_login")));
        this.n.add(new avs(4, this.l / 2 + 120, this.m - 25, 60, 20, LanguageManager.translate("button_cancel")));
        this.scrollbar.setPosition(this.l / 2 + 80, 35, this.l / 2 + 84, this.m - 35);
    }

    protected void a(avs button) throws IOException {
        super.a(button);
        switch (button.k) {
            case 0: {
                ave.A().a((axu)new GuiAccountChoose(this, true));
                break;
            }
            case 1: {
                if (this.selectedAccount == null || this.selectedAccount.getStorageType() != StorageType.EXTERNAL) break;
                this.accountManager.getStorage().removeAccount((ExternalAccount)this.selectedAccount);
                this.accountManager.saveAsync(new Runnable[0]);
                break;
            }
            case 2: {
                this.switchAccount();
                break;
            }
            case 3: {
                ave.A().a((axu)new GuiAccountChoose(this, false));
                break;
            }
            case 4: {
                ave.A().a(this.lastScreen);
            }
        }
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        boolean accountExternal;
        Account[] accounts;
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        this.c();
        draw.drawOverlayBackground(0, 30, this.l, this.m - 20, 32);
        double y = 35.0 + this.scrollbar.getScrollY();
        double x = (float)this.l / 2.0f - 75.0f;
        this.hoveredAccount = null;
        for (Account account : accounts = this.accountManager.getAccounts()) {
            if (account.isDemo()) continue;
            this.drawProfile(account, x, y, mouseX, mouseY);
            y += 21.0;
        }
        this.scrollbar.update(accounts.length);
        this.scrollbar.draw();
        draw.drawOverlayBackground(0, 30);
        draw.drawOverlayBackground(this.m - 30, this.m);
        draw.drawGradientShadowTop(30.0, 0.0, this.l);
        draw.drawGradientShadowBottom(this.m - 30, 0.0, this.l);
        boolean accountSelected = this.selectedAccount != null;
        this.buttonRemove.l = accountExternal = accountSelected && this.selectedAccount.getStorageType() == StorageType.EXTERNAL;
        this.buttonSwitch.l = accountSelected;
        if (this.buttonRemove.a() && accountSelected && !accountExternal) {
            TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, ModColor.cl('c') + LanguageManager.translate("account_manager_account_can_not_remove"));
        }
        draw.drawCenteredString(LanguageManager.translate("title_account_manager") + " (" + accounts.length + " " + LanguageManager.translate(accounts.length == 1 ? "account" : "accounts") + ")", (float)this.l / 2.0f, 12.0);
        super.a(mouseX, mouseY, partialTicks);
    }

    private void drawProfile(Account account, double x, double y, int mouseX, int mouseY) {
        boolean iconSizeOffset;
        float hoverOffset;
        LabyMod laby = LabyMod.getInstance();
        DrawUtils draw = laby.getDrawUtils();
        float width = 150.0f;
        float height = 20.0f;
        float avatarPadding = 2.0f;
        float avatarSize = height - avatarPadding * 2.0f;
        boolean hoverProfile = y < (double)(this.m - 30) && (double)mouseX > x && (double)mouseX < x + (double)width && (double)mouseY > y && (double)mouseY < y + (double)height;
        float f2 = hoverOffset = hoverProfile ? 1.0f : 0.0f;
        if (account == this.selectedAccount) {
            draw.drawRectBorder(x, y, x + (double)width, y + (double)height, Integer.MAX_VALUE, 1.0);
        }
        boolean loggedIn = LabyMod.getInstance().isSession(account);
        boolean hoverChecked = (double)mouseX > x - 15.0 && (double)mouseX < x - 15.0 + 10.0 && (double)mouseY > y + 5.0 && (double)mouseY < y + 5.0 + 10.0;
        boolean bl = iconSizeOffset = hoverChecked;
        if (loggedIn) {
            ave.A().P().a(ModTextures.BUTTON_CHECKBOX);
            draw.drawTexture(x - 15.0 - (double)iconSizeOffset, y + 5.0 - (double)iconSizeOffset, 255.0, 255.0, 10.0f + (float)iconSizeOffset * 2.0f, 10.0f + (float)iconSizeOffset * 2.0f);
        }
        float headBrightness = 0.7f;
        GL11.glColor4f((float)headBrightness, (float)headBrightness, (float)headBrightness, (float)1.0f);
        if (account.isMicrosoft()) {
            jy resourceLocation = laby.getDynamicTextureManager().getTexture("microsoft_avatar/" + account.getStorageType().name() + "/" + account.getUUID().toString(), account.getAvatarImage());
            ave.A().P().a(resourceLocation);
            draw.drawTexture(x + (double)avatarPadding - (double)hoverOffset, y + (double)avatarPadding - (double)hoverOffset, 256.0, 256.0, avatarSize + hoverOffset * 2.0f, avatarSize + hoverOffset * 2.0f);
        } else {
            draw.drawPlayerHead(account.getUUID(), (int)(x + (double)avatarPadding - (double)hoverOffset), (int)(y + (double)avatarPadding - (double)hoverOffset), (int)((float)((int)avatarSize) + hoverOffset * 2.0f));
        }
        float textX = (float)(x + (double)avatarSize + (double)(avatarPadding * 2.0f));
        AccountSessionState state = account.getSessionState();
        char color = state == AccountSessionState.VALID ? (char)'a' : (state == AccountSessionState.VALIDATING || state == AccountSessionState.REFRESHING ? (char)'e' : 'c');
        String stateName = LanguageManager.translate("account_manager_account_" + state.name().toLowerCase());
        draw.drawString(ModColor.cl(hoverProfile ? (char)'f' : '7') + account.getUsername(), textX, y + (double)avatarPadding);
        draw.drawString(ModColor.cl(color) + stateName, textX, y + (double)avatarPadding + 10.0, 0.7);
        boolean hoverAccountType = (double)mouseX > x + 120.0 + 15.0 && (double)mouseX < x + 120.0 + 15.0 + 10.0 && (double)mouseY > y + 5.0 && (double)mouseY < y + 5.0 + 10.0;
        ave.A().P().a(account.isMicrosoft() ? ModTextures.MISC_MICROSOFT : ModTextures.MISC_MOJANGSTUDIOS);
        draw.drawTexture(x + 120.0 + 15.0 - (double)(hoverAccountType ? 1 : 0), y + 5.0 - (double)(hoverAccountType ? 1 : 0), 255.0, 255.0, hoverAccountType ? 12.0 : 10.0, hoverAccountType ? 12.0 : 10.0);
        jy storageTypeIcon = null;
        String storageName = "Unknown";
        switch (account.getStorageType()) {
            case JAVA: {
                storageName = "Java";
                storageTypeIcon = ModTextures.MISC_JAVA;
                break;
            }
            case EXTERNAL: {
                storageName = "LabyMod";
                storageTypeIcon = ModTextures.LOGO_LABYMOD_LOGO;
                break;
            }
            case MICROSOFT: {
                storageName = "Microsoft";
                break;
            }
            case MICROSOFT_STORE: {
                storageName = "Microsoft Store";
                storageTypeIcon = ModTextures.MISC_MICROSOFT_STORE;
            }
        }
        if (storageTypeIcon != null) {
            ave.A().P().a(storageTypeIcon);
            draw.drawTexture(x + 120.0 + 15.0 - (double)(hoverAccountType ? 1 : 0) + 5.0, y + 5.0 - (double)(hoverAccountType ? 1 : 0) + 5.0, 255.0, 255.0, hoverAccountType ? 10.0 : 8.0, hoverAccountType ? 10.0 : 8.0);
        }
        if (hoverAccountType) {
            String accountType = account.isMicrosoft() ? "Microsoft" : "Mojang";
            TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, ModColor.createColors(LanguageManager.translate("account_manager_account_type", accountType, storageName)));
        }
        if (hoverChecked && loggedIn) {
            TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, ModColor.cl('a') + LanguageManager.translate("account_manager_logged_in"));
        }
        if (hoverProfile) {
            this.hoveredAccount = account;
        }
    }

    private void switchAccount() {
        if (this.selectedAccount != null) {
            try {
                LabyMod.getInstance().setSession(this.selectedAccount);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void a(int mouseX, int mouseY, int button) throws IOException {
        if (this.hoveredAccount != null) {
            this.selectedAccount = this.hoveredAccount;
        }
        if (this.selectedAccount != null && this.hoveredAccount != null) {
            if (this.lastLoginClick + 300L > System.currentTimeMillis()) {
                this.a(this.buttonSwitch);
            }
            this.lastLoginClick = System.currentTimeMillis();
        }
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.CLICKED);
        super.a(mouseX, mouseY, button);
    }

    public void b(int mouseX, int mouseY, int button) {
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.RELEASED);
        super.b(mouseX, mouseY, button);
    }

    protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.DRAGGING);
    }

    public void k() throws IOException {
        super.k();
        this.scrollbar.mouseInput();
    }

    protected void a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            ave.A().a(this.lastScreen);
            return;
        }
        super.a(typedChar, keyCode);
    }
}

