/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.core_implementation.mc18.gui;

import java.beans.ConstructorProperties;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.labymod.api.events.MessageReceiveEvent;
import net.labymod.core.LabyModCore;
import net.labymod.ingamechat.IngameChatManager;
import net.labymod.ingamechat.renderer.ChatLine;
import net.labymod.ingamechat.renderer.ChatRenderer;
import net.labymod.ingamechat.renderer.MessageData;
import net.labymod.ingamechat.renderer.types.ChatRendererMain;
import net.labymod.ingamechat.renderer.types.ChatRendererSecond;
import net.labymod.ingamechat.tools.filter.Filters;
import net.labymod.main.LabyMod;
import net.labymod.servermanager.ChatDisplayAction;
import net.labymod.utils.ModColor;
import net.labymod.utils.manager.TagManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiChatAdapter
extends avt {
    private static final Logger logger = LogManager.getLogger();
    private IngameChatManager manager = IngameChatManager.INSTANCE;
    private ChatRendererMain chatMain = this.manager.getMain();
    private ChatRendererSecond chatSecond = this.manager.getSecond();
    private ChatRenderer[] chatRenderers = this.manager.getChatRenderers();
    private Queue<QueuedMessage> queuedMessages = new ConcurrentLinkedQueue<QueuedMessage>();

    public GuiChatAdapter(ave mcIn) {
        super(mcIn);
    }

    public void a(String message) {
        this.manager.addToSentMessages(message);
    }

    public List<String> c() {
        return this.manager.getSentMessages();
    }

    public void a(int updateCounter) {
        if (LabyMod.getInstance() == null) {
            return;
        }
        int offset = LabyMod.getInstance().getDrawUtils().getHeight() - 48;
        bfl.b((float)0.0f, (float)(-offset), (float)0.0f);
        if (ave.A().t.m == wn.b.c) {
            return;
        }
        for (ChatRenderer chatRenderer : this.chatRenderers) {
            chatRenderer.renderChat(updateCounter);
        }
        if (this.queuedMessages.size() != 0) {
            QueuedMessage queuedMessage = null;
            while ((queuedMessage = this.queuedMessages.poll()) != null) {
                this.setChatLine(queuedMessage.getComponent(), queuedMessage.getChatLineId(), ave.A().q.e(), false, false, "Global", null);
            }
        }
    }

    public void c(int id) {
    }

    public void deleteChatLine(ChatRenderer chatRenderer, int id) {
        chatRenderer.deleteChatLine(id);
    }

    public void a() {
        for (ChatRenderer chatRenderer : this.chatRenderers) {
            chatRenderer.clearChatMessages(true);
        }
    }

    public void b(int amount) {
        if (LabyMod.getInstance() == null) {
            return;
        }
        if (amount != 1 && amount != -1) {
            amount = (int)((double)amount / 7.0 * (double)LabyMod.getSettings().chatScrollSpeed);
        }
        for (ChatRenderer chatRenderer : this.chatRenderers) {
            if (!chatRenderer.isMouseOver()) continue;
            chatRenderer.scroll(amount);
        }
    }

    public void a(eu component, int chatLineId) {
        if (LabyMod.getInstance() == null) {
            return;
        }
        boolean cancel = false;
        for (MessageReceiveEvent event : LabyMod.getInstance().getEventManager().getMessageReceive()) {
            if (!event.onReceive(component.d(), component.c())) continue;
            cancel = true;
        }
        if (!cancel) {
            this.queuedMessages.add(new QueuedMessage(component, chatLineId));
        }
    }

    private void setChatLine(eu component, int chatLineId, int updateCounter, boolean refresh, boolean secondChat, String room, Integer highlightColor) {
        if (component == null || LabyMod.getInstance() == null) {
            return;
        }
        ChatRenderer target = null;
        if (!refresh) {
            ChatDisplayAction serverDisplayActionResponse = LabyMod.getInstance().getServerManager().handleChatMessage(component.c(), component.d());
            MessageData messageData = this.manager.handleSwap(serverDisplayActionResponse, LabyModCore.getMinecraft().getChatComponent(component));
            if (messageData == null) {
                return;
            }
            secondChat = messageData.isDisplayInSecondChat();
            component = (eu)TagManager.tagComponent(component);
            Filters.Filter filter = messageData.getFilter();
            if (filter != null) {
                room = filter.getRoom();
                if (filter.isHighlightMessage()) {
                    highlightColor = ModColor.toRGB(filter.getHighlightColorR(), filter.getHighlightColorG(), filter.getHighlightColorB(), 120);
                }
            }
        }
        ChatRenderer chatRenderer = target = secondChat ? this.chatSecond : this.chatMain;
        if (chatLineId != 0) {
            this.deleteChatLine(target, chatLineId);
        }
        int width = target.getVisualWidth();
        List list = avu.a((eu)component, (int)width, (avn)LabyModCore.getMinecraft().getFontRenderer(), (boolean)false, (boolean)false);
        for (eu ichatcomponent : list) {
            target.addChatLine(ichatcomponent.d(), secondChat, room, ichatcomponent, updateCounter, chatLineId, highlightColor, refresh);
        }
        target.checkLimit();
        if (!refresh) {
            target.handleBackendLines(component.d(), secondChat, room, component, chatLineId, updateCounter, highlightColor);
            this.manager.handleUnread(room);
            logger.info("[" + target.getLogPrefix() + "] " + component.c());
        }
    }

    public void b() {
        for (ChatRenderer chatRenderer : this.chatRenderers) {
            chatRenderer.clearChatMessages(false);
            for (int i = chatRenderer.getBackendComponents().size() - 1; i >= 0; --i) {
                ChatLine chatLine = chatRenderer.getBackendComponents().get(i);
                this.setChatLine((eu)chatLine.getComponent(), chatLine.getChatLineId(), chatLine.getUpdateCounter(), true, chatLine.isSecondChat(), chatLine.getRoom(), chatLine.getHighlightColor());
            }
        }
    }

    public eu a(int mouseX, int mouseY) {
        for (ChatRenderer chatRenderer : this.chatRenderers) {
            Object component = this.getHoveringComponent(chatRenderer);
            if (component == null) continue;
            return (eu)component;
        }
        return null;
    }

    private Object getHoveringComponent(ChatRenderer chatRenderer) {
        if (!chatRenderer.isChatOpen() || !chatRenderer.isMouseOver()) {
            return null;
        }
        float mouseX = chatRenderer.isRightBound() ? (float)chatRenderer.lastMouseX - chatRenderer.getChatPositionX() + chatRenderer.getChatWidth() + 3.0f : -(chatRenderer.getChatPositionX() - (float)chatRenderer.lastMouseX);
        float mouseY = (float)(-chatRenderer.lastMouseY) + chatRenderer.getChatPositionY();
        mouseX /= this.h();
        mouseY /= this.h();
        LinkedList<ChatLine> list = new LinkedList<ChatLine>();
        for (ChatLine chatline : chatRenderer.getChatLines()) {
            if (chatline == null || !chatline.getRoom().equals(this.manager.getSelectedRoom())) continue;
            list.add(chatline);
        }
        int hoveredLine = (int)mouseY / ave.A().k.a + chatRenderer.getScrollPos();
        if (hoveredLine < 0 || hoveredLine >= list.size()) {
            return null;
        }
        int x = 0;
        ChatLine chatline = (ChatLine)list.get(hoveredLine);
        for (eu ichatcomponent : (eu)chatline.getComponent()) {
            if (!(ichatcomponent instanceof fa) || !((float)(x += ave.A().k.a(avu.a((String)((fa)ichatcomponent).g(), (boolean)false))) > mouseX)) continue;
            return ichatcomponent;
        }
        return null;
    }

    private class QueuedMessage {
        private eu component;
        private int chatLineId;

        public eu getComponent() {
            return this.component;
        }

        public int getChatLineId() {
            return this.chatLineId;
        }

        @ConstructorProperties(value={"component", "chatLineId"})
        public QueuedMessage(eu component, int chatLineId) {
            this.component = component;
            this.chatLineId = chatLineId;
        }
    }
}

