/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.core.asm.global;

import java.util.HashMap;
import java.util.Map;
import net.labymod.core.asm.LabyModCoreMod;
import net.labymod.core.asm.LabyModTransformer;
import net.labymod.core.asm.global.ClassEditor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class GuiIngameVisitor
extends ClassEditor {
    private final boolean MC18 = LabyModTransformer.getVersion().startsWith("1.8");
    private Map<String, String> constructorRemapper = new HashMap<String, String>();
    private String guiNewChatName;
    private String guiPlayerTabOverlayName;
    private String guiIngameName;
    private String showCrosshairName;
    private String glStateManagerName;
    private String enableAlphaName;
    private String scaledResolutionName;
    private String entityPlayerName;
    private String renderPlayerStatsName;

    public GuiIngameVisitor() {
        super(ClassEditor.ClassEditorType.CLASS_VISITOR);
        String packageName = this.MC18 ? "mc18" : "mc112";
        this.guiNewChatName = LabyModTransformer.getMappingImplementation().getGuiNewChatName();
        this.guiPlayerTabOverlayName = LabyModTransformer.getMappingImplementation().getGuiPlayerTabOverlayName();
        this.guiIngameName = LabyModTransformer.getMappingImplementation().getGuiIngameName();
        this.entityPlayerName = LabyModTransformer.getMappingImplementation().getEntityPlayerName();
        this.scaledResolutionName = LabyModTransformer.getMappingImplementation().getScaledResolutionName();
        this.renderPlayerStatsName = LabyModTransformer.getMappingImplementation().getRenderPlayerStatsName();
        this.constructorRemapper.put(this.guiNewChatName, String.format("net/labymod/core_implementation/%s/gui/GuiChatAdapter", packageName));
        this.constructorRemapper.put(this.guiPlayerTabOverlayName, String.format("net/labymod/core_implementation/%s/gui/ModPlayerTabOverlay", packageName));
        if (this.MC18) {
            this.showCrosshairName = LabyModCoreMod.isObfuscated() ? "b" : "showCrosshair";
        } else {
            this.glStateManagerName = LabyModTransformer.getMappingImplementation().getGlStateManagerName();
            this.enableAlphaName = LabyModTransformer.getMappingImplementation().getEnableAlphaName();
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("<init>")) {
            return new MethodVisitor(262144, mv){

                public void visitTypeInsn(int opcode, String type) {
                    super.visitTypeInsn(opcode, opcode == 187 ? (String)GuiIngameVisitor.this.firstNonNull(GuiIngameVisitor.this.constructorRemapper.get(type), type) : type);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    super.visitMethodInsn(opcode, opcode == 183 ? (String)GuiIngameVisitor.this.firstNonNull(GuiIngameVisitor.this.constructorRemapper.get(owner), owner) : owner, name, desc, itf);
                }
            };
        }
        if (desc.equals("(F)V")) {
            return new MethodVisitor(262144, mv){
                private boolean nextIsScoreboard;
                {
                    this.nextIsScoreboard = false;
                }

                public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                    super.visitFrame(type, nLocal, local, nStack, stack);
                    if (type == 4) {
                        this.nextIsScoreboard = true;
                    }
                }

                public void visitJumpInsn(int opcode, Label label) {
                    super.visitJumpInsn(opcode, label);
                    if (opcode == 198 && this.nextIsScoreboard) {
                        this.nextIsScoreboard = false;
                        super.visitMethodInsn(184, "BytecodeMethods", "canRenderScoreboard", "()Z", false);
                        super.visitJumpInsn(153, label);
                    }
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    if (GuiIngameVisitor.this.MC18 && opcode == 182 && owner.equals(GuiIngameVisitor.this.guiIngameName) && name.equals(GuiIngameVisitor.this.showCrosshairName) && desc.equals("()Z")) {
                        super.visitMethodInsn(184, "BytecodeMethods", "onRenderCrosshair18", "(Z)Z", false);
                    }
                }

                public void visitInsn(int opcode) {
                    if (opcode == 177) {
                        super.visitMethodInsn(184, "BytecodeMethods", "onRenderIngameOverlay", "()V", false);
                    }
                    super.visitInsn(opcode);
                }
            };
        }
        if (name.equals(this.renderPlayerStatsName) && desc.equals("(L" + this.scaledResolutionName + ";)V")) {
            return new MethodVisitor(262144, mv){
                private int modeHeart;
                private boolean patchedHeart;
                private int modeSaturation;
                private int airBubbleVarToModify;
                private boolean nextVirtual;
                {
                    this.modeHeart = 0;
                    this.patchedHeart = false;
                    this.modeSaturation = 0;
                    this.airBubbleVarToModify = -1;
                    this.nextVirtual = false;
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    super.visitFieldInsn(opcode, owner, name, desc);
                    this.modeHeart = 0;
                    if (opcode == 180 && owner.equals(GuiIngameVisitor.this.entityPlayerName) && desc.endsWith(";")) {
                        this.modeHeart = 1;
                    }
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    if (this.modeHeart == 1 && opcode == 182) {
                        this.modeHeart = 2;
                    } else if (this.modeHeart == 2 && opcode == 182) {
                        this.modeHeart = 3;
                    } else if (this.modeHeart != 4 || opcode != 182) {
                        this.modeHeart = 0;
                    }
                    if (this.nextVirtual && this.airBubbleVarToModify != -1) {
                        this.nextVirtual = false;
                        super.visitVarInsn(21, this.airBubbleVarToModify);
                        super.visitMethodInsn(184, "BytecodeMethods", "renderSaturationBarAndModifyAirOffset", "(I)I", false);
                        super.visitVarInsn(54, this.airBubbleVarToModify);
                    }
                }

                public void visitJumpInsn(int opcode, Label label) {
                    if (this.modeHeart == 3 && opcode == 153) {
                        this.modeHeart = 4;
                    } else if (this.modeHeart == 4 && opcode == 153 && !this.patchedHeart) {
                        this.patchedHeart = true;
                        super.visitMethodInsn(184, "BytecodeMethods", "shouldRender18HeartAnimation", "(Z)Z", false);
                    } else {
                        this.modeHeart = 0;
                    }
                    super.visitJumpInsn(opcode, label);
                }

                public void visitVarInsn(int opcode, int var) {
                    super.visitVarInsn(opcode, var);
                    if (this.modeSaturation == 2 && opcode == 54) {
                        this.airBubbleVarToModify = var;
                    }
                    this.modeSaturation = 0;
                }

                public void visitIntInsn(int opcode, int operand) {
                    super.visitIntInsn(opcode, operand);
                    this.modeSaturation = 0;
                    if (opcode == 16 && operand == 10) {
                        this.modeSaturation = 1;
                    }
                }

                public void visitInsn(int opcode) {
                    super.visitInsn(opcode);
                    this.modeSaturation = this.modeSaturation == 1 && opcode == 100 ? 2 : 0;
                }

                public void visitLdcInsn(Object cst) {
                    super.visitLdcInsn(cst);
                    if (cst instanceof String && ((String)cst).equals("air")) {
                        this.nextVirtual = true;
                    }
                }
            };
        }
        if (!this.MC18 && desc.equals("(FL" + this.scaledResolutionName + ";)V")) {
            return new MethodVisitor(262144, mv){
                private boolean crosshair;
                private int count;
                {
                    this.crosshair = false;
                    this.count = 0;
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    if (opcode == 184 && owner.equals(GuiIngameVisitor.this.glStateManagerName) && name.equals(GuiIngameVisitor.this.enableAlphaName)) {
                        this.crosshair = true;
                    }
                }

                public void visitIntInsn(int opcode, int operand) {
                    super.visitIntInsn(opcode, operand);
                    if (this.crosshair && opcode == 16 && operand == 16) {
                        ++this.count;
                        if (this.count == 2) {
                            this.crosshair = false;
                            super.visitMethodInsn(184, "BytecodeMethods", "onRenderCrosshair112", "(I)I", false);
                        }
                    }
                }
            };
        }
        return mv;
    }

    private <T> T firstNonNull(T first, T second) {
        return first != null ? first : second;
    }
}

