/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.core.asm.global;

import net.labymod.core.asm.global.ClassEditor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class GuiIngameForgeVisitor
extends ClassEditor {
    public GuiIngameForgeVisitor() {
        super(ClassEditor.ClassEditorType.CLASS_VISITOR);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (!name.equals("renderCrosshairs") && desc.equals("(F)V")) {
            return new MethodVisitor(262144, mv){
                private boolean nextIsScoreboard;
                {
                    this.nextIsScoreboard = false;
                }

                public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                    super.visitFrame(type, nLocal, local, nStack, stack);
                    if (type == 4) {
                        this.nextIsScoreboard = true;
                    }
                }

                public void visitJumpInsn(int opcode, Label label) {
                    super.visitJumpInsn(opcode, label);
                    if (opcode == 198 && this.nextIsScoreboard) {
                        this.nextIsScoreboard = false;
                        super.visitMethodInsn(184, "BytecodeMethods", "canRenderScoreboard", "()Z", false);
                        super.visitJumpInsn(153, label);
                    }
                }

                public void visitInsn(int opcode) {
                    if (opcode == 177) {
                        super.visitMethodInsn(184, "BytecodeMethods", "onRenderIngameOverlay", "()V", false);
                    }
                    super.visitInsn(opcode);
                }
            };
        }
        if (name.equals("renderHealth") && desc.equals("(II)V")) {
            return new MethodVisitor(262144, mv){
                private int varCounter;
                private int highlightVar;
                {
                    this.varCounter = 0;
                    this.highlightVar = -1;
                }

                public void visitVarInsn(int opcode, int var) {
                    super.visitVarInsn(opcode, var);
                    if (opcode == 21 && this.highlightVar != -1 && var == this.highlightVar) {
                        ++this.varCounter;
                        if (this.varCounter == 2) {
                            super.visitMethodInsn(184, "BytecodeMethods", "shouldRender18HeartAnimation", "(Z)Z", false);
                        }
                    }
                    if (opcode == 54 && this.highlightVar == -1) {
                        ++this.varCounter;
                        if (this.varCounter == 2) {
                            this.highlightVar = var;
                            this.varCounter = 0;
                        }
                    }
                }
            };
        }
        if (name.equals("renderAir") && desc.equals("(II)V")) {
            return new MethodVisitor(262144, mv){
                private int varCounter;
                {
                    this.varCounter = 0;
                }

                public void visitVarInsn(int opcode, int var) {
                    if (opcode == 54) {
                        ++this.varCounter;
                        if (this.varCounter == 2) {
                            super.visitMethodInsn(184, "BytecodeMethods", "renderSaturationBarAndModifyAirOffset", "(I)I", false);
                        }
                    }
                    super.visitVarInsn(opcode, var);
                }
            };
        }
        if (name.equals("renderCrosshairs")) {
            return new MethodVisitor(262144, mv){
                private boolean crosshair;
                private int count;
                {
                    this.crosshair = true;
                    this.count = 0;
                }

                public void visitIntInsn(int opcode, int operand) {
                    super.visitIntInsn(opcode, operand);
                    if (this.crosshair && opcode == 16 && operand == 16) {
                        ++this.count;
                        if (this.count == 2) {
                            this.crosshair = false;
                            super.visitMethodInsn(184, "BytecodeMethods", "onRenderCrosshair112", "(I)I", false);
                        }
                    }
                }
            };
        }
        return mv;
    }
}

