/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.core;

import java.beans.ConstructorProperties;

public class BoundingBox {
    private final double epsilon = 0.0;
    public double minX;
    public double minY;
    public double minZ;
    public double maxX;
    public double maxY;
    public double maxZ;

    public BoundingBox expand(double x, double y, double z) {
        double minX = this.minX;
        double minY = this.minY;
        double minZ = this.minZ;
        double maxX = this.maxX;
        double maxY = this.maxY;
        double maxZ = this.maxZ;
        if (x < 0.0) {
            minX += x;
        } else {
            maxX += x;
        }
        if (y < 0.0) {
            minY += y;
        } else {
            maxY += y;
        }
        if (z < 0.0) {
            minZ += z;
        } else {
            maxZ += z;
        }
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void move(double x, double y, double z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
    }

    public double clipXCollide(BoundingBox otherBoundingBox, double x) {
        double max;
        if (otherBoundingBox.maxY <= this.minY || otherBoundingBox.minY >= this.maxY) {
            return x;
        }
        if (otherBoundingBox.maxZ <= this.minZ || otherBoundingBox.minZ >= this.maxZ) {
            return x;
        }
        if (x > 0.0 && otherBoundingBox.maxX <= this.minX && (max = this.minX - otherBoundingBox.maxX - this.epsilon) < x) {
            x = max;
        }
        if (x < 0.0 && otherBoundingBox.minX >= this.maxX && (max = this.maxX - otherBoundingBox.minX + this.epsilon) > x) {
            x = max;
        }
        return x;
    }

    public double clipYCollide(BoundingBox otherBoundingBox, double y) {
        double max;
        if (otherBoundingBox.maxX <= this.minX || otherBoundingBox.minX >= this.maxX) {
            return y;
        }
        if (otherBoundingBox.maxZ <= this.minZ || otherBoundingBox.minZ >= this.maxZ) {
            return y;
        }
        if (y > 0.0 && otherBoundingBox.maxY <= this.minY && (max = this.minY - otherBoundingBox.maxY - this.epsilon) < y) {
            y = max;
        }
        if (y < 0.0 && otherBoundingBox.minY >= this.maxY && (max = this.maxY - otherBoundingBox.minY + this.epsilon) > y) {
            y = max;
        }
        return y;
    }

    public double clipZCollide(BoundingBox otherBoundingBox, double z) {
        double max;
        if (otherBoundingBox.maxX <= this.minX || otherBoundingBox.minX >= this.maxX) {
            return z;
        }
        if (otherBoundingBox.maxY <= this.minY || otherBoundingBox.minY >= this.maxY) {
            return z;
        }
        if (z > 0.0 && otherBoundingBox.maxZ <= this.minZ && (max = this.minZ - otherBoundingBox.maxZ - this.epsilon) < z) {
            z = max;
        }
        if (z < 0.0 && otherBoundingBox.minZ >= this.maxZ && (max = this.maxZ - otherBoundingBox.minZ + this.epsilon) > z) {
            z = max;
        }
        return z;
    }

    @ConstructorProperties(value={"minX", "minY", "minZ", "maxX", "maxY", "maxZ"})
    public BoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }
}

