/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.api.protocol.screen.render.components.widgets;

import net.labymod.api.protocol.screen.render.components.RenderWidget;
import net.labymod.api.protocol.screen.render.util.IInteractionCallback;
import net.labymod.api.protocol.screen.render.util.IScreenAccessor;
import net.labymod.core.LabyModCore;
import net.labymod.main.LabyMod;
import net.labymod.serverapi.common.widgets.components.widgets.LabelWidget;
import net.labymod.utils.DrawUtils;

public class RenderLabelWidget
extends RenderWidget<LabelWidget> {
    private String string = "";

    public RenderLabelWidget(LabelWidget widget, IInteractionCallback callback) {
        super(widget, callback);
    }

    @Override
    public void initScreen(IScreenAccessor accessor) {
        super.initScreen(accessor);
        if (((LabelWidget)this.widget).getValue().isJsonPrimitive()) {
            this.string = ((LabelWidget)this.widget).getValue().getAsString();
        } else {
            try {
                this.string = LabyModCore.getMinecraft().rawTextToString(((LabelWidget)this.widget).getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.string = "";
            }
        }
        if (this.string == null) {
            this.string = "";
        }
    }

    @Override
    public void renderScreen(IScreenAccessor accessor, int mouseX, int mouseY) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        switch (((LabelWidget)this.widget).getAlignment()) {
            case 0: {
                draw.drawString(this.string, this.getX(accessor), this.getY(accessor), (float)((LabelWidget)this.widget).getScale());
                break;
            }
            case 1: {
                draw.drawCenteredString(this.string, this.getX(accessor), this.getY(accessor), (float)((LabelWidget)this.widget).getScale());
                break;
            }
            case 2: {
                draw.drawRightString(this.string, this.getX(accessor), this.getY(accessor), (float)((LabelWidget)this.widget).getScale());
            }
        }
    }
}

