/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.api.protocol.screen.render.components;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.labymod.api.protocol.screen.render.components.WidgetGui;
import net.labymod.api.protocol.screen.render.components.widgets.RenderButtonWidget;
import net.labymod.api.protocol.screen.render.components.widgets.RenderColorPickerWidget;
import net.labymod.api.protocol.screen.render.components.widgets.RenderImageWidget;
import net.labymod.api.protocol.screen.render.components.widgets.RenderLabelWidget;
import net.labymod.api.protocol.screen.render.components.widgets.RenderTextFieldWidget;
import net.labymod.api.protocol.screen.render.util.IInteractionCallback;
import net.labymod.api.protocol.screen.render.util.IScreenAccessor;
import net.labymod.serverapi.common.widgets.components.Widget;
import net.labymod.serverapi.common.widgets.components.widgets.ButtonWidget;
import net.labymod.serverapi.common.widgets.components.widgets.ColorPickerWidget;
import net.labymod.serverapi.common.widgets.components.widgets.ImageWidget;
import net.labymod.serverapi.common.widgets.components.widgets.LabelWidget;
import net.labymod.serverapi.common.widgets.components.widgets.TextFieldWidget;
import net.labymod.serverapi.common.widgets.util.EnumResponse;
import net.labymod.serverapi.common.widgets.util.EnumWidget;
import net.labymod.utils.ModColor;

public abstract class RenderWidget<T extends Widget>
extends WidgetGui {
    protected T widget;
    protected IInteractionCallback callback;

    public RenderWidget(T widget, IInteractionCallback callback) {
        this.widget = widget;
        this.callback = callback;
    }

    protected void fillResponsePayload(JsonObject state) {
    }

    protected void sendResponse(IScreenAccessor accessor) {
        this.callback.sendResponse(accessor.getScreenId(), EnumResponse.INTERACT, ((Widget)this.widget).getId(), this::putState);
    }

    public void putState(JsonObject states) {
        String key = String.valueOf(((Widget)this.widget).getId());
        JsonObject state = new JsonObject();
        this.fillResponsePayload(state);
        if (!state.entrySet().isEmpty()) {
            states.add(key, (JsonElement)state);
        }
    }

    protected int getX(IScreenAccessor accessor) {
        return (int)((double)accessor.getWidth() / 100.0 * ((Widget)this.widget).getAnchor().getX() + ((Widget)this.widget).getOffsetX());
    }

    protected int getY(IScreenAccessor accessor) {
        return (int)((double)accessor.getHeight() / 100.0 * ((Widget)this.widget).getAnchor().getY() + ((Widget)this.widget).getOffsetY());
    }

    public T getWidget() {
        return this.widget;
    }

    public static RenderWidget<? extends Widget> from(Widget widget, IInteractionCallback callback) {
        EnumWidget type = EnumWidget.getTypeOf(widget.getClass());
        if (type == null) {
            return null;
        }
        switch (type) {
            case BUTTON: {
                return new RenderButtonWidget((ButtonWidget)widget, callback);
            }
            case TEXT_FIELD: {
                return new RenderTextFieldWidget((TextFieldWidget)widget, callback);
            }
            case LABEL: {
                return new RenderLabelWidget((LabelWidget)widget, callback);
            }
            case COLOR_PICKER: {
                return new RenderColorPickerWidget((ColorPickerWidget)widget, callback);
            }
            case IMAGE: {
                return new RenderImageWidget((ImageWidget)widget, callback);
            }
        }
        LabelWidget label = new LabelWidget(widget, ModColor.cl('c') + "Widget not implemented: " + type.name(), 1, 1.0);
        return new RenderLabelWidget(label, callback);
    }
}

