/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.api.protocol.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.labymod.api.events.ServerMessageEvent;
import net.labymod.api.protocol.screen.render.GuiScreenProtocol;
import net.labymod.api.protocol.screen.render.GuiWrappedInventory;
import net.labymod.api.protocol.screen.render.components.RenderWidget;
import net.labymod.api.protocol.screen.render.util.IInteractionCallback;
import net.labymod.api.protocol.screen.render.util.IStateCollector;
import net.labymod.main.LabyMod;
import net.labymod.serverapi.common.widgets.WidgetScreen;
import net.labymod.serverapi.common.widgets.components.Widget;
import net.labymod.serverapi.common.widgets.util.EnumResponse;
import net.labymod.serverapi.common.widgets.util.EnumScreenAction;
import net.labymod.support.util.Debug;

public class ScreenProtocol
implements IInteractionCallback,
ServerMessageEvent {
    public ScreenProtocol() {
        LabyMod.getInstance().getEventManager().register(this);
    }

    @Override
    public void onServerMessage(String messageKey, JsonElement serverMessage) {
        if (messageKey.equals("screen")) {
            try {
                JsonObject screenObject = serverMessage.getAsJsonObject();
                WidgetScreen widgetScreen = WidgetScreen.from(screenObject);
                EnumScreenAction screenAction = EnumScreenAction.values()[screenObject.get("action").getAsInt()];
                ave minecraft = ave.A();
                switch (screenAction) {
                    case OPEN: {
                        minecraft.a(() -> {
                            try {
                                axu currentScreen = minecraft.m;
                                minecraft.a((axu)new GuiScreenProtocol(currentScreen, widgetScreen.getId(), this, this.getRenderWidgets(widgetScreen)));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        });
                        break;
                    }
                    case UPDATE: {
                        axu currentScreen = minecraft.m;
                        if (!(currentScreen instanceof GuiScreenProtocol)) break;
                        ((GuiScreenProtocol)currentScreen).setWidgets(this.getRenderWidgets(widgetScreen));
                        break;
                    }
                    case WRAP_INVENTORY: {
                        minecraft.a(() -> {
                            try {
                                axu currentScreen2 = minecraft.m;
                                if (currentScreen2 instanceof ayl) {
                                    ayl containerScreen = (ayl)currentScreen2;
                                    minecraft.a((axu)new GuiWrappedInventory(containerScreen, widgetScreen.getId(), this, this.getRenderWidgets(widgetScreen), widgetScreen.getLayout()));
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        });
                        break;
                    }
                    case CLOSE: {
                        minecraft.a(() -> {
                            axu currentScreen2 = minecraft.m;
                            if (currentScreen2 instanceof GuiScreenProtocol) {
                                GuiScreenProtocol screenProtocol = (GuiScreenProtocol)currentScreen2;
                                screenProtocol.closeProperly();
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                Debug.log(Debug.EnumDebugMode.API, "Can't parse screen: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private List<RenderWidget<? extends Widget>> getRenderWidgets(WidgetScreen screen) {
        ArrayList<RenderWidget<? extends Widget>> renderWidgets = new ArrayList<RenderWidget<? extends Widget>>();
        if (!screen.getWidgets().isEmpty()) {
            for (Widget widget : screen.getWidgets()) {
                RenderWidget<Widget> renderWidget = RenderWidget.from(widget, this);
                if (renderWidget == null) continue;
                renderWidgets.add(renderWidget);
            }
        }
        return renderWidgets;
    }

    @Override
    public void sendResponse(int screenId, EnumResponse responseType, int widgetId, IStateCollector collector) {
        JsonObject response = new JsonObject();
        response.addProperty("id", (Number)screenId);
        response.addProperty("type", (Number)responseType.ordinal());
        if (responseType == EnumResponse.INTERACT) {
            response.addProperty("widget_id", (Number)widgetId);
        }
        JsonObject states = new JsonObject();
        collector.collect(states);
        response.add("states", (JsonElement)states);
        LabyMod.getInstance().getLabyModAPI().sendJsonMessageToServer("screen", (JsonElement)response);
    }
}

