/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.api.protocol.liquid;

import io.netty.buffer.Unpooled;
import net.labymod.api.permissions.Permissions;
import net.labymod.core.LabyModCore;
import net.labymod.main.LabyMod;
import net.labymod.support.util.Debug;

public class FixedLiquidBucketProtocol {
    public static void handleBucketAction(Action bucketAction, int x, int y, int z) {
        if (!Permissions.isAllowed(Permissions.Permission.IMPROVED_LAVA)) {
            Debug.log(Debug.EnumDebugMode.PLUGINMESSAGE, "Can't handle LAVA_UPDATE with action " + bucketAction.name() + " - not allowed!");
            return;
        }
        em packetBuffer = new em(Unpooled.buffer());
        packetBuffer.writeInt(bucketAction.ordinal());
        if (bucketAction == Action.FILL_BUCKET || bucketAction == Action.EMPTY_BUCKET) {
            packetBuffer.writeInt(x);
            packetBuffer.writeInt(y);
            packetBuffer.writeInt(z);
            Debug.log(Debug.EnumDebugMode.PLUGINMESSAGE, "LAVA_UPDATE with action " + bucketAction.name() + " at " + x + " " + y + " " + z);
        } else {
            Debug.log(Debug.EnumDebugMode.PLUGINMESSAGE, "LAVA_UPDATE with action " + bucketAction.name());
        }
        LabyModCore.getMinecraft().sendPluginMessage("LAVA_UPDATE", packetBuffer);
        LabyModCore.getMinecraft().sendPluginMessage("labymod3:lava_update", packetBuffer);
    }

    public static void onPermissionUpdate(boolean allowed) {
        if (!allowed) {
            return;
        }
        if (LabyMod.getSettings().improvedLavaFixedGhostBlocks) {
            FixedLiquidBucketProtocol.handleBucketAction(Action.ENABLE, 0, 0, 0);
        }
    }

    public static enum Action {
        FILL_BUCKET,
        EMPTY_BUCKET,
        ENABLE,
        DISABLE;

    }
}

