/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.api.permissions;

import java.util.HashMap;
import java.util.Map;
import net.labymod.api.permissions.Permissions;
import net.labymod.main.LabyMod;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;

public class PermissionNotifyRenderer {
    private Map<Permissions.Permission, Boolean> updateValues = new HashMap<Permissions.Permission, Boolean>();
    private Map<Permissions.Permission, Boolean> lastRenderedPermissions = new HashMap<Permissions.Permission, Boolean>();
    private long lastCheckCalled;

    public void checkChangedPermissions() {
        boolean equals;
        if (!LabyMod.getSettings().notifyPermissionChanges) {
            return;
        }
        HashMap<Permissions.Permission, Boolean> updateValues = new HashMap<Permissions.Permission, Boolean>();
        for (Permissions.Permission permission : Permissions.Permission.values()) {
            boolean serverValue;
            boolean defaultValue = permission.isDefaultEnabled();
            if (defaultValue == (serverValue = Permissions.isAllowed(permission))) continue;
            updateValues.put(permission, serverValue);
        }
        this.updateValues = updateValues;
        boolean bl = equals = this.updateValues.size() == this.lastRenderedPermissions.size();
        if (!this.lastRenderedPermissions.isEmpty()) {
            for (Map.Entry<Permissions.Permission, Boolean> set : this.updateValues.entrySet()) {
                Boolean value = this.lastRenderedPermissions.get((Object)set.getKey());
                if (value != null && value == set.getValue()) continue;
                equals = false;
                break;
            }
        }
        this.lastRenderedPermissions.putAll(this.updateValues);
        if (!this.updateValues.isEmpty() && !equals) {
            this.lastCheckCalled = System.currentTimeMillis();
        }
    }

    public void quit() {
        if (!this.lastRenderedPermissions.isEmpty() && LabyMod.getSettings().notifyPermissionChanges) {
            this.lastRenderedPermissions.clear();
        }
    }

    public void render(int screenWidth) {
        int maxDisplayTime = 5000;
        if (this.lastCheckCalled + (long)maxDisplayTime > System.currentTimeMillis() && !ave.A().F()) {
            DrawUtils draw = LabyMod.getInstance().getDrawUtils();
            bfl.E();
            bfl.b((float)0.0f, (float)0.0f, (float)10.0f);
            int y = 5;
            int fadeInAnimation = (int)(System.currentTimeMillis() - (this.lastCheckCalled + 1000L));
            int fadeOutAnimation = (int)(System.currentTimeMillis() - (this.lastCheckCalled + (long)maxDisplayTime - 1000L));
            if ((fadeInAnimation /= 5) > 0) {
                fadeInAnimation = 0;
            }
            for (Map.Entry<Permissions.Permission, Boolean> permissionEntry : this.updateValues.entrySet()) {
                boolean value = permissionEntry.getValue();
                String displayName = (value ? ModColor.cl("a") : ModColor.cl("4")) + permissionEntry.getKey().getDisplayName() + " " + (value ? "\u2714" : "\u2716");
                int width = draw.getStringWidth(displayName);
                fadeOutAnimation -= y * 2;
                if ((fadeOutAnimation = (int)((double)fadeOutAnimation / 1.2)) < 0) {
                    fadeOutAnimation = 0;
                }
                draw.drawRectangle(screenWidth - 5 - width - 2 + fadeOutAnimation, y + fadeInAnimation, screenWidth - 5 + fadeOutAnimation, y + 12 + fadeInAnimation, Integer.MIN_VALUE);
                draw.drawRectBorder(screenWidth - 5 - width - 2 + fadeOutAnimation, y + fadeInAnimation, screenWidth - 5 + fadeOutAnimation, y + 12 + fadeInAnimation, Integer.MIN_VALUE, 1.0);
                draw.drawRightString(displayName, screenWidth - 5 - 1 + fadeOutAnimation, y + 2 + fadeInAnimation);
                y += 13;
            }
            bfl.b((float)0.0f, (float)0.0f, (float)-10.0f);
            bfl.F();
        }
    }
}

