/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.utils;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import net.labymod.accountmanager.utils.CertificateLoader;
import net.labymod.accountmanager.utils.IOUtil;

public class RestUtil {
    private static final Gson GSON = new Gson();

    public static <T> T performGetJson(String url, String bearer, Class<T> response) throws Exception {
        String json = RestUtil.performGetJson(url, bearer);
        return (T)GSON.fromJson(json, response);
    }

    public static <T> T performPostFormRequest(String url, String content, Class<T> response) throws Exception {
        String json = RestUtil.performPostRequest(url, content, "application/x-www-form-urlencoded");
        return (T)GSON.fromJson(json, response);
    }

    public static String performPostJsonRequest(String url, String json) throws Exception {
        return RestUtil.performPostRequest(url, json, "application/json");
    }

    public static <T> T performPostObjectRequest(String url, Object request, Class<T> response) throws Exception {
        String json = RestUtil.performPostRequest(url, GSON.toJson(request), "application/json");
        return (T)GSON.fromJson(json, response);
    }

    private static String performPostRequest(String url, String content, String contentType) throws Exception {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
        byte[] data = content.getBytes(StandardCharsets.UTF_8);
        connection.setSSLSocketFactory(CertificateLoader.getSocketFactory());
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Content-Type", contentType);
        connection.setRequestProperty("Content-Length", "" + data.length);
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            IOUtil.write(data, outputStream);
        }
        catch (SSLHandshakeException e) {
            throw new RuntimeException("Invalid certificate for " + url);
        }
        return RestUtil.readInputStream(connection);
    }

    public static String performGetJson(String url, String bearer) throws Exception {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
        connection.setSSLSocketFactory(CertificateLoader.getSocketFactory());
        if (bearer != null) {
            connection.addRequestProperty("Authorization", "Bearer " + bearer);
        }
        return RestUtil.readInputStream(connection);
    }

    public static <T> T performGetContract(String url, String hash, String token, Class<T> response) throws Exception {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
        connection.setSSLSocketFactory(CertificateLoader.getSocketFactory());
        connection.addRequestProperty("Authorization", "XBL3.0 x=" + hash + ";" + token);
        connection.addRequestProperty("x-xbl-contract-version", "2");
        connection.addRequestProperty("Accept", "application/json");
        String json = RestUtil.readInputStream(connection);
        return (T)GSON.fromJson(json, response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readInputStream(HttpURLConnection connection) throws IOException {
        try (InputStream inputStream = connection.getInputStream();){
            String throwable3 = IOUtil.toString(inputStream, StandardCharsets.UTF_8);
            return throwable3;
        }
        catch (IOException exception) {
            try (InputStream errorStream = connection.getErrorStream();){
                if (errorStream == null) {
                    throw new RuntimeException("Response code: " + connection.getResponseCode());
                }
                String string = IOUtil.toString(errorStream, StandardCharsets.UTF_8);
                return string;
            }
        }
    }
}

