/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import net.labymod.accountmanager.utils.RestUtil;

public class CertificateLoader {
    private static final String URL_CERTIFICATES_ROOT = "https://dl.labymod.net/latest/certificates/";
    private static final String URL_CERTIFICATES_INDEX = "https://dl.labymod.net/latest/certificates/index.json";
    private static boolean initialize = false;
    private static SSLSocketFactory socketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();

    public static boolean isCertificateSupported() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion != null && javaVersion.startsWith("1.8.0_")) {
            try {
                if (Integer.parseInt(javaVersion.substring("1.8.0_".length())) < 101) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static SSLSocketFactory getSocketFactory() throws Exception {
        if (!initialize && !CertificateLoader.isCertificateSupported()) {
            CertificateLoader.load();
        }
        return socketFactory;
    }

    public static void load() throws Exception {
        initialize = true;
        JsonObject index = RestUtil.performGetJson(URL_CERTIFICATES_INDEX, null, JsonObject.class);
        HashMap<String, Certificate> certificates = new HashMap<String, Certificate>();
        if (index.has("oauth")) {
            JsonObject entry = index.getAsJsonObject("oauth");
            JsonArray files = entry.getAsJsonArray("certificates");
            for (JsonElement file : files) {
                certificates.putAll(CertificateLoader.loadUrl(URL_CERTIFICATES_ROOT + file.getAsString()));
            }
        }
        socketFactory = CertificateLoader.createSocketFactory(certificates);
    }

    private static Map<String, Certificate> loadUrl(String url) throws Exception {
        InputStream inputStream = new URL(url).openStream();
        if (inputStream != null) {
            Map<String, Certificate> certificates = CertificateLoader.loadInputStream(inputStream);
            inputStream.close();
            return certificates;
        }
        return new HashMap<String, Certificate>();
    }

    private static Map<String, Certificate> loadResource(String fileName) throws Exception {
        InputStream inputStream = CertificateLoader.class.getResourceAsStream(fileName);
        if (inputStream != null) {
            Map<String, Certificate> certificates = CertificateLoader.loadInputStream(inputStream);
            inputStream.close();
            return certificates;
        }
        return new HashMap<String, Certificate>();
    }

    public static Map<String, Certificate> loadInputStream(InputStream inputStream) throws Exception {
        if (CertificateLoader.isCertificateSupported()) {
            return new HashMap<String, Certificate>();
        }
        KeyStore keyStoreResources = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStoreResources.load(inputStream, "supersecretpassword".toCharArray());
        return Collections.list(keyStoreResources.aliases()).stream().collect(Collectors.toMap(a2 -> a2, alias -> {
            try {
                return keyStoreResources.getCertificate((String)alias);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public static SSLSocketFactory createSocketFactory(Map<String, Certificate> certificates) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        Path path = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
        keyStore.load(Files.newInputStream(path, new OpenOption[0]), "changeit".toCharArray());
        Map<String, Certificate> jdkTrustStore = Collections.list(keyStore.aliases()).stream().collect(Collectors.toMap(a2 -> a2, alias -> {
            try {
                return keyStore.getCertificate((String)alias);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        }));
        KeyStore mergedTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        mergedTrustStore.load(null, new char[0]);
        for (Map.Entry<String, Certificate> entry : jdkTrustStore.entrySet()) {
            mergedTrustStore.setCertificateEntry(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Certificate> entry : certificates.entrySet()) {
            mergedTrustStore.setCertificateEntry(entry.getKey(), entry.getValue());
        }
        TrustManagerFactory instance = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        instance.init(mergedTrustStore);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, instance.getTrustManagers(), null);
        return context.getSocketFactory();
    }
}

