/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.loader.microsoft;

import java.io.File;
import net.labymod.accountmanager.storage.StorageType;
import net.labymod.accountmanager.storage.credentials.CredentialsAccessor;
import net.labymod.accountmanager.storage.loader.microsoft.MicrosoftLauncherStorage;
import net.labymod.accountmanager.storage.loader.microsoft.model.LauncherAccount;

public class MicrosoftStoreLauncherStorage
extends MicrosoftLauncherStorage {
    public MicrosoftStoreLauncherStorage(CredentialsAccessor credentialsAccessor, File minecraftDirectory) {
        super(credentialsAccessor, minecraftDirectory);
    }

    @Override
    public File getFile() {
        return new File(this.minecraftDirectory, "launcher_accounts_microsoft_store.json");
    }

    @Override
    public void load() throws Exception {
        super.load();
        if (this.isLoaded()) {
            for (LauncherAccount account : this.getAccounts()) {
                account.setStorageType(StorageType.MICROSOFT_STORE);
            }
        }
    }

    @Override
    public StorageType getType() {
        return StorageType.MICROSOFT_STORE;
    }
}

