/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.loader.java.model;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.labymod.accountmanager.storage.StorageType;
import net.labymod.accountmanager.storage.account.AbstractAccount;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.loader.java.model.Profile;
import net.labymod.accountmanager.utils.UUIDUtil;

public class AuthenticationDatabase
extends AbstractAccount {
    public String accessToken;
    public String username;
    public String displayName;
    public String userId;
    public String uuid;
    public Map<String, Profile> profiles = new HashMap<String, Profile>();
    public Object properties;

    public AuthenticationDatabase(int profilesFormat, String accessToken, String username, String displayName, String userId, String uuid) {
        this.accessToken = accessToken;
        this.username = username;
        if (profilesFormat >= 2) {
            this.profiles.put(uuid.replaceAll("-", ""), new Profile(displayName));
        } else {
            this.displayName = displayName;
            this.userId = userId;
            this.uuid = uuid;
        }
    }

    @Override
    public boolean isMicrosoft() {
        return false;
    }

    @Override
    public UUID getUUID() {
        return this.isNewFormat() ? UUIDUtil.getUUIDFromCompactUUID(this.profiles.keySet().iterator().next().replaceAll("-", "")) : UUID.fromString(this.uuid);
    }

    @Override
    public boolean isPremium() {
        return this.accessToken != null && !this.accessToken.isEmpty();
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getUsername() {
        return this.isNewFormat() ? this.profiles.values().iterator().next().displayName : this.displayName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDemo() {
        if (this.isNewFormat()) {
            if (this.profiles == null) return true;
            if (this.profiles.isEmpty()) {
                return true;
            }
        } else if (this.uuid == null) return true;
        if (this.username != null) return false;
        return true;
    }

    @Override
    public String getAvatarImage() {
        return null;
    }

    public boolean isNewFormat() {
        return this.uuid == null;
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.JAVA;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Account) {
            return ((Account)obj).getUUID().equals(this.getUUID());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getUUID().hashCode();
    }
}

