/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage;

import java.io.File;
import java.util.Collection;
import java.util.function.Consumer;
import net.labymod.accountmanager.authentication.AccountAuthentication;
import net.labymod.accountmanager.storage.StorageType;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.account.AccountSessionState;

public interface AccountStorage<T extends Account> {
    public File getFile();

    public boolean isLoaded();

    public void load() throws Exception;

    public void save() throws Exception;

    public Collection<T> getAccounts();

    public Account getActiveAccount();

    public StorageType getType();

    public String getClientToken();

    public boolean isAuthenticationInitialized();

    public void initializeAuthentication();

    public AccountAuthentication getAuthentication();

    public void refreshAccounts(Consumer<Account> var1);

    default public void setAllSessionStatesTo(AccountSessionState state) {
        for (Account account : this.getAccounts()) {
            account.setSessionState(state);
        }
    }
}

