/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.authentication.microsoft;

import java.text.SimpleDateFormat;
import net.labymod.accountmanager.authentication.microsoft.MicrosoftAuthState;
import net.labymod.accountmanager.authentication.microsoft.StateCallback;
import net.labymod.accountmanager.authentication.microsoft.model.MicrosoftAccountResult;
import net.labymod.accountmanager.authentication.microsoft.model.minecraft.LoginRequest;
import net.labymod.accountmanager.authentication.microsoft.model.minecraft.LoginResponse;
import net.labymod.accountmanager.authentication.microsoft.model.minecraft.ProfileResponse;
import net.labymod.accountmanager.authentication.microsoft.model.minecraft.StoreResponse;
import net.labymod.accountmanager.authentication.microsoft.model.oauth.OAuthResponse;
import net.labymod.accountmanager.authentication.microsoft.model.xboxlive.XBLRequest;
import net.labymod.accountmanager.authentication.microsoft.model.xboxlive.XBoxProfile;
import net.labymod.accountmanager.authentication.microsoft.model.xboxlive.XSTSRequest;
import net.labymod.accountmanager.storage.loader.microsoft.model.msa.token.TokenData;
import net.labymod.accountmanager.storage.loader.microsoft.model.msa.token.XUI;
import net.labymod.accountmanager.utils.RestUtil;

public class MicrosoftAuthentication {
    public static final SimpleDateFormat DATE_FORMAT_EXACT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final int REDIRECT_PORT = 8086;
    public static final String AZURE_CLIENT_ID = "27843883-6e3b-42cb-9e51-4f55a700601e";
    public static final String OAUTH_SCOPE = "XboxLive.signin%20offline_access";
    public static final String GRANT_TYPE_AUTH = "authorization_code";
    public static final String GRANT_TYPE_REFRESH = "refresh_token";
    public static final String REDIRECT_URL = String.format("http://localhost:%s", 8086);
    public static final String PARTY_MINECRAFT_SERVICE = "rp://api.minecraftservices.com/";
    private static final String URL_OAUTH_ACCESS_TOKEN = "https://login.live.com/oauth20_token.srf";
    private static final String URL_XBL_AUTH = "https://user.auth.xboxlive.com/user/authenticate";
    private static final String URL_XSTS_AUTH = "https://xsts.auth.xboxlive.com/xsts/authorize";
    private static final String URL_AVATAR = "https://profile.xboxlive.com/users/xuid(%s)/profile/settings?settings=DisplayPic,PublicGamerpic";
    private static final String URL_LOGIN_WITH_XBOX = "https://api.minecraftservices.com/authentication/login_with_xbox";
    private static final String URL_STORE = "https://api.minecraftservices.com/entitlements/mcstore";
    private static final String URL_PROFILE = "https://api.minecraftservices.com/minecraft/profile";
    private StateCallback callback;

    public MicrosoftAuthentication() {
        this(stateId -> {});
    }

    public MicrosoftAuthentication(StateCallback callback) {
        this.callback = callback;
    }

    public void setCallback(StateCallback callback) {
        this.callback = callback;
    }

    public MicrosoftAccountResult authenticate(String code) throws Exception {
        OAuthResponse oAuth = this.getOAuthAccess(code);
        if (oAuth.error != null && !oAuth.error.isEmpty()) {
            throw new RuntimeException(oAuth.error + ": " + oAuth.errorDescription);
        }
        return this.authenticate(oAuth);
    }

    public MicrosoftAccountResult refresh(String accessToken) throws Exception {
        OAuthResponse oAuth = this.refreshOAuthAccess(accessToken);
        if (oAuth.error != null && !oAuth.error.isEmpty()) {
            throw new RuntimeException(oAuth.error + ": " + oAuth.errorDescription);
        }
        return this.authenticate(oAuth);
    }

    public MicrosoftAccountResult authenticate(OAuthResponse oAuth) throws Exception {
        TokenData xblAuth = this.getXBL(oAuth.accessToken);
        TokenData minecraftScope = this.getXSTS(xblAuth.token, PARTY_MINECRAFT_SERVICE);
        LoginResponse minecraftAPILogin = this.getMinecraftAccess(minecraftScope);
        ProfileResponse mcProfile = this.getMinecraftProfile(minecraftAPILogin.accessToken);
        TokenData xboxScope = this.getXSTS(xblAuth.token, "http://xboxlive.com");
        XBoxProfile xbBoxProfile = this.getXBoxProfile(xboxScope);
        return new MicrosoftAccountResult(mcProfile, xbBoxProfile, oAuth, minecraftAPILogin, xblAuth, xboxScope, minecraftScope);
    }

    public OAuthResponse getOAuthAccess(String code) throws Exception {
        this.callback.onStateChange(MicrosoftAuthState.GET_OAUTH_TOKEN);
        String payload = String.format("client_id=%s&code=%s&grant_type=%s&redirect_uri=%s", AZURE_CLIENT_ID, code, GRANT_TYPE_AUTH, REDIRECT_URL);
        return RestUtil.performPostFormRequest(URL_OAUTH_ACCESS_TOKEN, payload, OAuthResponse.class);
    }

    public OAuthResponse refreshOAuthAccess(String refreshToken) throws Exception {
        this.callback.onStateChange(MicrosoftAuthState.GET_OAUTH_TOKEN);
        String payload = String.format("client_id=%s&refresh_token=%s&grant_type=%s&redirect_uri=%s&scope=%s", AZURE_CLIENT_ID, refreshToken, GRANT_TYPE_REFRESH, REDIRECT_URL, OAUTH_SCOPE);
        return RestUtil.performPostFormRequest(URL_OAUTH_ACCESS_TOKEN, payload, OAuthResponse.class);
    }

    public TokenData getXBL(String accessToken) throws Exception {
        this.callback.onStateChange(MicrosoftAuthState.GET_XBL);
        XBLRequest request = new XBLRequest(new XBLRequest.Properties("RPS", "user.auth.xboxlive.com", accessToken), "http://auth.xboxlive.com", "JWT");
        return RestUtil.performPostObjectRequest(URL_XBL_AUTH, request, TokenData.class);
    }

    public TokenData getXSTS(String xblToken, String party) throws Exception {
        this.callback.onStateChange(MicrosoftAuthState.GET_XSTS);
        XSTSRequest request = new XSTSRequest(new XSTSRequest.Properties("RETAIL", new String[]{xblToken}), party, "JWT");
        return RestUtil.performPostObjectRequest(URL_XSTS_AUTH, request, TokenData.class);
    }

    public LoginResponse getMinecraftAccess(TokenData xsts) throws Exception {
        return this.getMinecraftAccess(xsts.displayClaims.xui[0].uhs, xsts.token);
    }

    public LoginResponse getMinecraftAccess(String userHash, String xstsToken) throws Exception {
        if (this.callback != null) {
            this.callback.onStateChange(MicrosoftAuthState.GET_MC_TOKEN);
        }
        LoginRequest request = new LoginRequest("XBL3.0 x=" + userHash + ";" + xstsToken);
        return RestUtil.performPostObjectRequest(URL_LOGIN_WITH_XBOX, request, LoginResponse.class);
    }

    public ProfileResponse getMinecraftProfile(String mcAccessToken) throws Exception {
        this.callback.onStateChange(MicrosoftAuthState.GET_MC_PROFILE);
        return RestUtil.performGetJson(URL_PROFILE, mcAccessToken, ProfileResponse.class);
    }

    public XBoxProfile getXBoxProfile(TokenData xstsResponse) throws Exception {
        this.callback.onStateChange(MicrosoftAuthState.GET_XBOX_PROFILE);
        XUI xui = xstsResponse.displayClaims.xui[0];
        return RestUtil.performGetContract(String.format(URL_AVATAR, xui.xid), xui.uhs, xstsResponse.token, XBoxProfile.class);
    }

    public StoreResponse getMinecraftPurchase(String accessToken) throws Exception {
        this.callback.onStateChange(MicrosoftAuthState.GET_PURCHASE);
        return RestUtil.performGetJson(URL_STORE, accessToken, StoreResponse.class);
    }
}

