/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage0;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EssentialSetupTweaker
implements ITweaker {
    private static final String STAGE1_RESOURCE = "gg/essential/loader/stage0/stage1.jar";
    private static final String STAGE1_PKG = "gg.essential.loader.stage1.";
    private static final String STAGE1_PKG_PATH = "gg.essential.loader.stage1.".replace('.', '/');
    private static final String STAGE1_CLS = "gg.essential.loader.stage1.EssentialSetupTweaker";
    private static final Logger LOGGER = LogManager.getLogger(EssentialSetupTweaker.class);
    private final ITweaker stage1;

    public EssentialSetupTweaker() {
        try {
            this.stage1 = EssentialSetupTweaker.loadStage1(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ITweaker loadStage1(ITweaker stage0) throws Exception {
        Enumeration<URL> resources;
        if (Launch.minecraftHome == null) {
            Launch.minecraftHome = new File(".");
        }
        Path dataDir = Launch.minecraftHome.toPath().resolve("essential").resolve("loader").resolve("stage0").resolve("launchwrapper");
        Path stage1UpdateFile = dataDir.resolve("stage1.update.jar");
        Path stage1File = dataDir.resolve("stage1.jar");
        URL stage1Url = stage1File.toUri().toURL();
        if (!Files.exists(dataDir, new LinkOption[0])) {
            Files.createDirectories(dataDir, new FileAttribute[0]);
        }
        if (Files.exists(stage1UpdateFile, new LinkOption[0])) {
            LOGGER.info("Found update for stage1.");
            Files.deleteIfExists(stage1File);
            Files.move(stage1UpdateFile, stage1File, new CopyOption[0]);
        }
        URL latestUrl = null;
        int latestVersion = -1;
        if (Files.exists(stage1File, new LinkOption[0])) {
            latestVersion = EssentialSetupTweaker.getVersion(stage1Url);
            LOGGER.debug("Found stage1 version {}: {}", new Object[]{latestVersion, stage1Url});
        }
        if (!(resources = EssentialSetupTweaker.class.getClassLoader().getResources(STAGE1_RESOURCE)).hasMoreElements()) {
            LOGGER.warn("Found no embedded stage1 jar files.");
        }
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            int version = EssentialSetupTweaker.getVersion(url);
            LOGGER.debug("Found stage1 version {}: {}", new Object[]{version, url});
            if (version <= latestVersion) continue;
            latestVersion = version;
            latestUrl = url;
        }
        if (latestUrl != null) {
            LOGGER.info("Updating stage1 to version {} from {}", new Object[]{latestVersion, latestUrl});
            try (InputStream in = latestUrl.openStream();){
                Files.deleteIfExists(stage1File);
                Files.copy(in, stage1File, new CopyOption[0]);
            }
        }
        LaunchClassLoader classLoader = Launch.classLoader;
        classLoader.addURL(stage1Url);
        classLoader.addClassLoaderExclusion(STAGE1_PKG);
        EssentialSetupTweaker.addUrlHack(classLoader.getClass().getClassLoader(), stage1Url);
        return (ITweaker)Class.forName(STAGE1_CLS, true, (ClassLoader)classLoader).getConstructor(ITweaker.class).newInstance(stage0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getVersion(URL file) {
        try (JarInputStream in = new JarInputStream(file.openStream(), false);){
            Manifest manifest = in.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            if (!STAGE1_PKG_PATH.equals(attributes.getValue("Name"))) {
                int n2 = -1;
                return n2;
            }
            int n = Integer.parseInt(attributes.getValue("Implementation-Version"));
            return n;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to read version from " + file, (Throwable)e);
            return -1;
        }
    }

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        this.stage1.acceptOptions(args, gameDir, assetsDir, profile);
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        this.stage1.injectIntoClassLoader(classLoader);
    }

    public String getLaunchTarget() {
        return this.stage1.getLaunchTarget();
    }

    public String[] getLaunchArguments() {
        return this.stage1.getLaunchArguments();
    }

    private static void addUrlHack(ClassLoader loader, URL url) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ClassLoader classLoader = Launch.classLoader.getClass().getClassLoader();
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)classLoader, url);
    }
}

