/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import com.google.gson.JsonArray;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscfeatures.tablisttutorial.TablistAPI;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import io.github.moulberry.notenoughupdates.util.XPInformation;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/github/moulberry/notenoughupdates/util/TabSkillInfoParser;", "", "()V", "maxSkillTabPattern", "Ljava/util/regex/Pattern;", "sentErrorOnce", "", "skillTabPattern", "calculateLevelXp", "", "levelingArray", "Lcom/google/gson/JsonArray;", "level", "", "isWithinPercentageRange", "xp", "existingXp", "percentage", "levelArray", "kotlin.jvm.PlatformType", "skillType", "", "parseSkillInfo", "", "sendError", "message", "NotEnoughUpdates"})
public final class TabSkillInfoParser {
    @NotNull
    public static final TabSkillInfoParser INSTANCE = new TabSkillInfoParser();
    @NotNull
    private static final Pattern skillTabPattern;
    @NotNull
    private static final Pattern maxSkillTabPattern;
    private static boolean sentErrorOnce;

    private TabSkillInfoParser() {
    }

    private final double calculateLevelXp(JsonArray levelingArray, int level) {
        double totalXp = 0.0;
        int n = level + 1;
        for (int i = 0; i < n; ++i) {
            double xp = levelingArray.get(i).getAsDouble();
            totalXp += xp;
        }
        return totalXp;
    }

    private final boolean isWithinPercentageRange(double xp, double existingXp, double percentage) {
        double diff = Math.abs(xp - existingXp) / existingXp * (double)100;
        return diff <= percentage;
    }

    private final void sendError(String message) {
        if (!sentErrorOnce) {
            Utils.addChatMessage(message);
            sentErrorOnce = true;
        }
    }

    private final JsonArray levelArray(String skillType) {
        return Intrinsics.areEqual((Object)skillType, (Object)"runecrafting") ? Utils.getElement(Constants.LEVELING, "runecrafting_xp").getAsJsonArray() : Utils.getElement(Constants.LEVELING, "leveling_xp").getAsJsonArray();
    }

    @JvmStatic
    public static final void parseSkillInfo() {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        if (Constants.LEVELING == null) {
            INSTANCE.sendError(EnumChatFormatting.RED + "[NEU] There is an error with your repo, please report this in the discord at " + EnumChatFormatting.AQUA + "discord.gg/moulberry");
            return;
        }
        for (String s : TablistAPI.getOptionalWidgetLines(TablistAPI.WidgetNames.SKILLS)) {
            double totalXp;
            XPInformation.SkillInfo existingLevel;
            JsonArray levelingArray;
            int level;
            String name;
            Matcher matcher = skillTabPattern.matcher(s);
            Matcher maxLevelMatcher = maxSkillTabPattern.matcher(s);
            if (matcher.matches()) {
                XPInformation.SkillInfo existingLevel2;
                String string = matcher.group("type");
                Intrinsics.checkNotNull((Object)string);
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                name = string2;
                String string3 = matcher.group("level");
                Intrinsics.checkNotNull((Object)string3);
                level = Integer.parseInt(string3);
                String string4 = matcher.group("progress");
                Intrinsics.checkNotNull((Object)string4);
                Float progress = StringsKt.toFloatOrNull((String)string4);
                if (progress == null) {
                    INSTANCE.sendError(EnumChatFormatting.RED + "[NEU] Error while parsing skill level from tab list");
                    return;
                }
                levelingArray = INSTANCE.levelArray(name);
                Intrinsics.checkNotNullExpressionValue((Object)levelingArray, (String)"levelingArray");
                double levelXp = INSTANCE.calculateLevelXp(levelingArray, level - 1);
                double nextLevelDiff = levelingArray.get(level).getAsDouble();
                double nextLevelProgress = nextLevelDiff * (double)progress.floatValue() / (double)100;
                double totalXp2 = levelXp + nextLevelProgress;
                XPInformation.SkillInfo skillInfo = XPInformation.getInstance().getSkillInfo(name, false);
                if (skillInfo == null) {
                    skillInfo = existingLevel2 = new XPInformation.SkillInfo();
                }
                if (INSTANCE.isWithinPercentageRange(totalXp2, existingLevel2.totalXp, 1.0)) break;
                existingLevel2.level = level;
                existingLevel2.totalXp = totalXp2;
                existingLevel2.currentXp = nextLevelProgress;
                existingLevel2.currentXpMax = nextLevelDiff;
                HashMap<String, XPInformation.SkillInfo> hashMap = XPInformation.getInstance().getSkillInfoMap();
                Intrinsics.checkNotNullExpressionValue(hashMap, (String)"getInstance().skillInfoMap");
                ((Map)hashMap).put(name, existingLevel2);
                break;
            }
            if (!maxLevelMatcher.matches()) continue;
            String string = maxLevelMatcher.group("type");
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String string5 = maxLevelMatcher.group("level");
            Intrinsics.checkNotNull((Object)string5);
            level = Integer.parseInt(string5);
            XPInformation.SkillInfo skillInfo = XPInformation.getInstance().getSkillInfo(name, false);
            if (skillInfo == null) {
                skillInfo = existingLevel = new XPInformation.SkillInfo();
            }
            if (existingLevel.level == level) continue;
            existingLevel.level = level;
            levelingArray = INSTANCE.levelArray(name);
            Intrinsics.checkNotNullExpressionValue((Object)levelingArray, (String)"levelingArray");
            existingLevel.totalXp = totalXp = INSTANCE.calculateLevelXp(levelingArray, level - 1);
            HashMap<String, XPInformation.SkillInfo> hashMap = XPInformation.getInstance().getSkillInfoMap();
            Intrinsics.checkNotNullExpressionValue(hashMap, (String)"getInstance().skillInfoMap");
            ((Map)hashMap).put(name, existingLevel);
        }
    }

    static {
        Pattern pattern = Pattern.compile("^\u00a7r (?<type>\\w+) (?<level>\\d+): \u00a7r\u00a7a(?<progress>.+)%\u00a7r$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"^\u00a7r (?<type>\\\\w\u2026r\u00a7a(?<progress>.+)%\u00a7r\\$\")");
        skillTabPattern = pattern;
        Pattern pattern2 = Pattern.compile("^\u00a7r (?<type>\\w+) (?<level>\\d+): \u00a7r\u00a7c\u00a7lMAX\u00a7r$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(\"^\u00a7r (?<type>\\\\w\u2026el>\\\\d+): \u00a7r\u00a7c\u00a7lMAX\u00a7r\\$\")");
        maxSkillTabPattern = pattern2;
    }
}

