/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0011H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/github/moulberry/notenoughupdates/util/HotmInformation;", "", "()V", "pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "ticksTillReload", "", "getLevel", "string", "", "loadDataFromInventory", "", "onGuiOpen", "event", "Lnet/minecraftforge/client/event/GuiOpenEvent;", "onTick", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ClientTickEvent;", "Companion", "NotEnoughUpdates"})
@SourceDebugExtension(value={"SMAP\nHotmInformation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotmInformation.kt\nio/github/moulberry/notenoughupdates/util/HotmInformation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1747#2,3:121\n*S KotlinDebug\n*F\n+ 1 HotmInformation.kt\nio/github/moulberry/notenoughupdates/util/HotmInformation\n*L\n69#1:121,3\n*E\n"})
public final class HotmInformation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int ticksTillReload;
    private final Pattern pattern = Pattern.compile("\u00a7[7b]Level (\\d*)(?:\u00a78/.*)?");
    @NotNull
    private static final int[] QUICK_FORGE_MULTIPLIERS;

    @SubscribeEvent
    public final void onGuiOpen(@NotNull GuiOpenEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GuiScreen gui = event.gui;
        if (!(gui instanceof GuiChest)) {
            return;
        }
        if (Intrinsics.areEqual((Object)Utils.getOpenChestName(), (Object)"Heart of the Mountain")) {
            this.ticksTillReload = 5;
        }
    }

    @SubscribeEvent
    public final void onTick(@NotNull TickEvent.ClientTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.ticksTillReload == 0) {
            return;
        }
        int n = this.ticksTillReload;
        this.ticksTillReload = n + -1;
        if (this.ticksTillReload == 0) {
            this.loadDataFromInventory();
        }
    }

    private final void loadDataFromInventory() {
        NEUConfig.HiddenProfileSpecific hiddenProfileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (hiddenProfileSpecific == null) {
            return;
        }
        NEUConfig.HiddenProfileSpecific profileSpecific = hiddenProfileSpecific;
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (!(currentScreen instanceof GuiChest)) {
            return;
        }
        Container container = ((GuiChest)currentScreen).field_147002_h;
        Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type net.minecraft.inventory.ContainerChest");
        ContainerChest container2 = (ContainerChest)container;
        int n = container2.func_85151_d().func_70302_i_();
        for (int i = 0; i < n; ++i) {
            Map<String, Integer> map2;
            String displayName;
            boolean bl;
            List<String> lore;
            block6: {
                ItemStack stack;
                if (container2.func_85151_d().func_70301_a(i) == null || ItemUtils.getDisplayName(stack) == null) continue;
                Intrinsics.checkNotNullExpressionValue(ItemUtils.getLore(stack), (String)"getLore(stack)");
                Iterable $this$any$iv = lore;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"Right-click to", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            String perkName = StringUtils.cleanColour(displayName);
            Intrinsics.checkNotNullExpressionValue(profileSpecific.hotmTree, (String)"profileSpecific.hotmTree");
            String string = lore.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lore[0]");
            Integer n2 = this.getLevel(string);
            map2.put(perkName, n2);
        }
    }

    private final int getLevel(String string) {
        int n;
        Matcher matcher = this.pattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(1)");
            n = Integer.parseInt(string2);
        } else {
            n = 1;
        }
        int level = n;
        boolean withBlueCheeseGoblinOmelette = StringsKt.contains$default((CharSequence)string, (CharSequence)"\u00a7b", (boolean)false, (int)2, null);
        boolean isNotMaxed = StringsKt.contains$default((CharSequence)string, (CharSequence)"\u00a78/", (boolean)false, (int)2, null);
        return withBlueCheeseGoblinOmelette && (isNotMaxed || level > 1) ? level - 1 : level;
    }

    @JvmStatic
    public static final int getQuickForgeMultiplier(int level) {
        return Companion.getQuickForgeMultiplier(level);
    }

    static {
        int[] nArray = new int[]{985, 970, 955, 940, 925, 910, 895, 880, 865, 850, 845, 840, 835, 830, 825, 820, 815, 810, 805, 700};
        QUICK_FORGE_MULTIPLIERS = nArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/github/moulberry/notenoughupdates/util/HotmInformation$Companion;", "", "()V", "QUICK_FORGE_MULTIPLIERS", "", "getQuickForgeMultiplier", "", "level", "NotEnoughUpdates"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int getQuickForgeMultiplier(int level) {
            if (level <= 0) {
                return 1000;
            }
            return level > 20 ? -1 : QUICK_FORGE_MULTIPLIERS[level - 1];
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

