/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.RepositoryReloadEvent;
import io.github.moulberry.notenoughupdates.recipes.EssenceUpgrades;
import io.github.moulberry.notenoughupdates.recipes.NeuRecipe;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Constants {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter((Type)((Object)Pattern.class), new PatternSerializer()).create();
    public static JsonObject BONUSES;
    public static JsonObject DISABLE;
    public static JsonObject ENCHANTS;
    public static JsonObject LEVELING;
    public static JsonObject MISC;
    public static JsonObject PETNUMS;
    public static JsonObject PETS;
    public static JsonObject PARENTS;
    public static JsonObject ESSENCECOSTS;
    public static JsonObject FAIRYSOULS;
    public static JsonObject REFORGESTONES;
    public static JsonObject TROPHYFISH;
    public static JsonObject WEIGHT;
    public static JsonObject RNGSCORE;
    public static JsonObject ABIPHONE;
    public static JsonObject ESSENCESHOPS;
    public static JsonObject SBLEVELS;
    public static JsonObject MUSEUM;
    public static JsonObject BESTIARY;
    public static JsonObject SACKS;
    public static JsonObject HOPPITY;
    public static JsonObject DYES;
    public static JsonObject GEMSTONES;
    public static JsonObject GARDEN;
    public static JsonObject ANIMATEDSKULLS;
    private static final ReentrantLock lock;

    @SubscribeEvent
    public void reload(RepositoryReloadEvent event) {
        try {
            lock.lock();
            BONUSES = Utils.getConstant("bonuses", gson);
            DISABLE = Utils.getConstant("disable", gson);
            ENCHANTS = Utils.getConstant("enchants", gson);
            LEVELING = Utils.getConstant("leveling", gson);
            MISC = Utils.getConstant("misc", gson);
            PETNUMS = Utils.getConstant("petnums", gson);
            PETS = Utils.getConstant("pets", gson);
            PARENTS = Utils.getConstant("parents", gson);
            ESSENCECOSTS = Utils.getConstant("essencecosts", gson);
            FAIRYSOULS = Utils.getConstant("fairy_souls", gson);
            REFORGESTONES = Utils.getConstant("reforgestones", gson);
            TROPHYFISH = Utils.getConstant("trophyfish", gson);
            WEIGHT = Utils.getConstant("weight", gson);
            RNGSCORE = Utils.getConstant("rngscore", gson);
            ABIPHONE = Utils.getConstant("abiphone", gson);
            ESSENCESHOPS = Utils.getConstant("essenceshops", gson);
            SBLEVELS = Utils.getConstant("sblevels", gson);
            MUSEUM = Utils.getConstant("museum", gson);
            BESTIARY = Utils.getConstant("bestiary", gson);
            SACKS = Utils.getConstant("sacks", gson);
            HOPPITY = Utils.getConstant("hoppity", gson);
            DYES = Utils.getConstant("dyes", gson);
            GEMSTONES = Utils.getConstant("gemstones", gson);
            GARDEN = Utils.getConstant("garden", gson);
            ANIMATEDSKULLS = Utils.getConstant("animatedskulls", gson);
            this.parseEssenceCosts();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            lock.unlock();
        }
    }

    public void parseEssenceCosts() {
        for (Map.Entry<String, JsonElement> entry : ESSENCECOSTS.entrySet()) {
            NeuRecipe parsed = EssenceUpgrades.parseFromEssenceCostEntry(entry);
            if (parsed != null) {
                NotEnoughUpdates.INSTANCE.manager.registerNeuRecipe(parsed);
                continue;
            }
            System.out.println("NULL for: " + entry);
        }
    }

    static {
        lock = new ReentrantLock();
    }

    private static class PatternSerializer
    implements JsonDeserializer<Pattern>,
    JsonSerializer<Pattern> {
        private PatternSerializer() {
        }

        @Override
        public Pattern deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Pattern.compile(json.getAsString());
        }

        @Override
        public JsonElement serialize(Pattern src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.pattern());
        }
    }
}

