/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import io.github.moulberry.notenoughupdates.util.AsyncDependencyLoader;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

class AsyncDependencyLoaderImpl<R, T>
implements AsyncDependencyLoader<T> {
    private final Supplier<R> supplyDependency;
    private final Function<R, CompletableFuture<T>> generator;
    private final BiFunction<R, R, Boolean> isDifferent;
    private volatile CompletableFuture<T> lastValue;
    private volatile R lastDependency;
    private volatile boolean isFirstFire = true;

    @Override
    public synchronized Optional<T> peekValue() {
        R nextDependency = this.supplyDependency.get();
        if (this.isFirstFire || this.isDifferent.apply(nextDependency, this.lastDependency).booleanValue()) {
            this.isFirstFire = false;
            if (this.lastValue != null) {
                this.lastValue.cancel(true);
            }
            this.lastValue = this.generator.apply(nextDependency);
        }
        this.lastDependency = nextDependency;
        return Optional.ofNullable(this.lastValue.getNow(null));
    }

    AsyncDependencyLoaderImpl(Supplier<R> supplyDependency, Function<R, CompletableFuture<T>> generator, BiFunction<R, R, Boolean> isDifferent) {
        this.supplyDependency = supplyDependency;
        this.generator = generator;
        this.isDifferent = isDifferent;
    }
}

