/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.recipes;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.recipes.CraftingRecipe;
import io.github.moulberry.notenoughupdates.recipes.ForgeRecipe;
import io.github.moulberry.notenoughupdates.recipes.ItemShopRecipe;
import io.github.moulberry.notenoughupdates.recipes.KatRecipe;
import io.github.moulberry.notenoughupdates.recipes.MobLootRecipe;
import io.github.moulberry.notenoughupdates.recipes.NeuRecipe;
import io.github.moulberry.notenoughupdates.recipes.VillagerTradeRecipe;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public enum RecipeType {
    CRAFTING("crafting", "Crafting", CraftingRecipe::parseCraftingRecipe, new ItemStack(Blocks.field_150462_ai)),
    FORGE("forge", "Forging", ForgeRecipe::parseForgeRecipe, new ItemStack(Blocks.field_150467_bQ)),
    TRADE("trade", "Trading", VillagerTradeRecipe::parseStaticRecipe, new ItemStack(Items.field_151166_bC)),
    MOB_LOOT("drops", "Mob Loot", MobLootRecipe::parseRecipe, new ItemStack(Items.field_151048_u)),
    NPC_SHOP("npc_shop", "NPC Item Shop", ItemShopRecipe::parseItemRecipe, new ItemStack(Items.field_151014_N)),
    ESSENCE_UPGRADES("", "Essence Upgrades", null, new ItemStack(Items.field_151156_bN)),
    KAT_UPGRADE("katgrade", "Katsitting", KatRecipe::parseRecipe, new ItemStack((Block)Blocks.field_150328_O));

    private final String id;
    private final String label;
    private final RecipeFactory recipeFactory;
    private final ItemStack icon;

    private RecipeType(String id, String label, RecipeFactory recipeFactory, ItemStack icon) {
        this.id = id;
        this.label = label;
        this.recipeFactory = recipeFactory;
        this.icon = icon;
        icon.func_151001_c("neurecipe-" + id);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public RecipeFactory getRecipeFactory() {
        return this.recipeFactory;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public NeuRecipe createRecipe(NEUManager manager, JsonObject recipe, JsonObject outputItemJson) {
        return this.recipeFactory.createRecipe(manager, recipe, outputItemJson);
    }

    public static RecipeType getRecipeTypeForId(String id) {
        for (RecipeType value : RecipeType.values()) {
            if (!value.id.equals(id)) continue;
            return value;
        }
        return null;
    }

    @FunctionalInterface
    static interface RecipeFactory {
        public NeuRecipe createRecipe(NEUManager var1, JsonObject var2, JsonObject var3);
    }
}

