/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.recipes;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.entityviewer.EntityViewer;
import io.github.moulberry.notenoughupdates.miscgui.GuiItemRecipe;
import io.github.moulberry.notenoughupdates.profileviewer.Panorama;
import io.github.moulberry.notenoughupdates.recipes.Ingredient;
import io.github.moulberry.notenoughupdates.recipes.NeuRecipe;
import io.github.moulberry.notenoughupdates.recipes.RecipeSlot;
import io.github.moulberry.notenoughupdates.recipes.RecipeType;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.JsonUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class MobLootRecipe
implements NeuRecipe {
    private static final int MOB_POS_X = 38;
    private static final int MOB_POS_Y = 100;
    private static final int SLOT_POS_X = 82;
    private static final int SLOT_POS_Y = 24;
    public static ResourceLocation BACKGROUND = new ResourceLocation("notenoughupdates", "textures/gui/mob_loot_tall.png");
    private final Ingredient mobIngredient;
    private final List<MobDrop> drops;
    private final int coins;
    private final int combatXp;
    private final int xp;
    private final String name;
    private final String render;
    private final int level;
    private final List<String> extra;
    private EntityLivingBase entityLivingBase;
    private final String panoName;
    private ResourceLocation[] panos = null;
    public static final int PANORAMA_POS_X = 13;
    public static final int PANORAMA_POS_Y = 23;
    public static final int PANORAMA_WIDTH = 50;
    public static final int PANORAMA_HEIGHT = 80;

    public MobLootRecipe(Ingredient mobIngredient, List<MobDrop> drops, int level, int coins, int xp, int combatXp, String name, String render, List<String> extra, String panoName) {
        this.mobIngredient = mobIngredient;
        this.drops = drops;
        this.level = level;
        this.coins = coins;
        this.xp = xp;
        this.extra = extra;
        this.combatXp = combatXp;
        this.name = name;
        this.render = render;
        this.panoName = panoName;
    }

    public String getName() {
        return this.name;
    }

    public List<MobDrop> getDrops() {
        return this.drops;
    }

    public int getCoins() {
        return this.coins;
    }

    public int getCombatXp() {
        return this.combatXp;
    }

    public Ingredient getMob() {
        return this.mobIngredient;
    }

    public int getXp() {
        return this.xp;
    }

    public String getRender() {
        return this.render;
    }

    public synchronized EntityLivingBase getRenderEntity() {
        if (this.entityLivingBase == null) {
            if (this.render == null) {
                return null;
            }
            this.entityLivingBase = this.render.startsWith("@") ? EntityViewer.constructEntity(new ResourceLocation(this.render.substring(1))) : EntityViewer.constructEntity(this.render, Collections.emptyList());
        }
        return this.entityLivingBase;
    }

    @Override
    public Set<Ingredient> getIngredients() {
        return Sets.newHashSet((Object[])new Ingredient[]{this.mobIngredient});
    }

    @Override
    public Set<Ingredient> getCatalystItems() {
        return Sets.newHashSet((Object[])new Ingredient[]{this.mobIngredient});
    }

    @Override
    public Set<Ingredient> getOutputs() {
        return this.drops.stream().flatMap(it -> Stream.concat(Stream.of(it.drop), it.alternatives.stream().map(that -> that.drop))).collect(Collectors.toSet());
    }

    @Override
    public String getTitle() {
        return this.getFullMobName();
    }

    public String getFullMobName() {
        return (this.level > 0 ? "\u00a78[\u00a77Lv " + this.level + "\u00a78] \u00a7c" : "\u00a7c") + this.name;
    }

    @Override
    public List<RecipeSlot> getSlots() {
        ArrayList<RecipeSlot> slots = new ArrayList<RecipeSlot>();
        BiConsumer<Integer, ItemStack> addSlot = (sl, is) -> slots.add(new RecipeSlot(82 + sl % 5 * 16, 24 + sl / 5 * 16, (ItemStack)is));
        for (int i = 0; i < this.drops.size(); ++i) {
            MobDrop mobDrop = this.drops.get(i);
            addSlot.accept(i, mobDrop.getItemStack());
        }
        return slots;
    }

    @Override
    public RecipeType getType() {
        return RecipeType.MOB_LOOT;
    }

    @Override
    public boolean shouldUseForCraftCost() {
        return false;
    }

    @Override
    public boolean hasVariableCost() {
        return true;
    }

    @Override
    public void drawExtraBackground(GuiItemRecipe gui, int mouseX, int mouseY) {
        if (this.panos == null) {
            this.panos = Panorama.getPanoramasForLocation(this.panoName, "day");
        }
        Panorama.drawPanorama((float)System.nanoTime() / 2.0E10f % 1.0f * 360.0f, gui.guiLeft + 13, gui.guiTop + 23, 50, 80, 0.0f, 0.0f, this.panos);
        if (this.getRenderEntity() != null) {
            EntityViewer.renderEntity(this.entityLivingBase, gui.guiLeft + 38, gui.guiTop + 100, mouseX, mouseY);
        }
    }

    @Override
    public void drawHoverInformation(GuiItemRecipe gui, int mouseX, int mouseY) {
        if (gui.isWithinRect(mouseX, mouseY, gui.guiLeft + 13, gui.guiTop + 23, 50, 80)) {
            ArrayList<String> stuff = new ArrayList<String>();
            stuff.add(this.getFullMobName());
            stuff.add("");
            if (this.coins > 0) {
                stuff.add("\u00a7r\u00a76Coins: " + this.coins);
            }
            if (this.xp > 0) {
                stuff.add("\u00a7r\u00a7aExperience: " + this.xp);
            }
            if (this.combatXp > 0) {
                stuff.add("\u00a7r\u00a7bCombat Experience: " + this.combatXp);
            }
            stuff.addAll(this.extra);
            Utils.drawHoveringText(stuff, mouseX, mouseY, gui.field_146294_l, gui.field_146295_m, -1);
        }
    }

    @Override
    public int[] getPageFlipPositionLeftTopCorner() {
        return new int[]{14, 118};
    }

    @Override
    public JsonObject serialize() {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("level", this.level);
        recipe.addProperty("coins", this.coins);
        recipe.addProperty("xp", this.xp);
        recipe.addProperty("combat_xp", this.combatXp);
        recipe.addProperty("name", this.name);
        recipe.addProperty("render", this.render);
        recipe.addProperty("type", this.getType().getId());
        recipe.addProperty("panorama", "unknown");
        recipe.add("extra", JsonUtils.transformListToJsonArray(this.extra, JsonPrimitive::new));
        recipe.add("drops", JsonUtils.transformListToJsonArray(this.drops, drop -> {
            JsonObject dropObject = new JsonObject();
            dropObject.addProperty("id", drop.drop.serialize());
            dropObject.add("extra", JsonUtils.transformListToJsonArray(drop.extra, JsonPrimitive::new));
            dropObject.addProperty("chance", drop.chance);
            return dropObject;
        }));
        return recipe;
    }

    @Override
    public ResourceLocation getBackground() {
        return BACKGROUND;
    }

    private static MobDrop parseMobDrop(NEUManager manager, JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return new MobDrop(new Ingredient(manager, jsonElement.getAsString()), null, Collections.emptyList(), Collections.emptyList());
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        return new MobDrop(new Ingredient(manager, jsonObject.get("id").getAsString()), jsonObject.has("chance") ? jsonObject.get("chance").getAsString() : null, JsonUtils.getJsonArrayOrEmpty(jsonObject, "extra", JsonElement::getAsString), JsonUtils.getJsonArrayOrEmpty(jsonObject, "alternatives", element -> MobLootRecipe.parseMobDrop(manager, element)));
    }

    public static MobLootRecipe parseRecipe(NEUManager manager, JsonObject recipe, JsonObject outputItemJson) {
        return new MobLootRecipe(new Ingredient(manager, outputItemJson.get("internalname").getAsString(), 1.0), JsonUtils.getJsonArrayOrEmpty(recipe, "drops", element -> MobLootRecipe.parseMobDrop(manager, element)), recipe.has("level") ? recipe.get("level").getAsInt() : 0, recipe.has("coins") ? recipe.get("coins").getAsInt() : 0, recipe.has("xp") ? recipe.get("xp").getAsInt() : 0, recipe.has("combat_xp") ? recipe.get("combat_xp").getAsInt() : 0, recipe.get("name").getAsString(), recipe.has("render") && !recipe.get("render").isJsonNull() ? recipe.get("render").getAsString() : null, JsonUtils.getJsonArrayOrEmpty(recipe, "extra", JsonElement::getAsString), recipe.has("panorama") ? recipe.get("panorama").getAsString() : "unknown");
    }

    public static class MobDrop {
        public final Ingredient drop;
        public final String chance;
        public final List<MobDrop> alternatives;
        public final List<String> extra;
        private ItemStack itemStack;
        private int lastHoveredIndex = 0;

        public MobDrop(Ingredient drop, String chance, List<String> extra, List<MobDrop> alternatives) {
            this.drop = drop;
            this.chance = chance;
            this.extra = extra;
            this.alternatives = alternatives;
        }

        public ItemStack getItemStack() {
            if (!Keyboard.isKeyDown((int)42)) {
                this.lastHoveredIndex = (int)(System.currentTimeMillis() / 2000L % (long)(this.alternatives.size() + 1));
            }
            if (this.lastHoveredIndex == this.alternatives.size()) {
                if (this.itemStack == null) {
                    this.itemStack = this.drop.getItemStack().func_77946_l();
                    ArrayList<String> arrayList = new ArrayList<String>(this.extra);
                    arrayList.add("\u00a7r\u00a7e\u00a7lDrop Chance: \u00a76" + this.formatDropChance());
                    ItemUtils.appendLore(this.itemStack, arrayList);
                }
                return this.itemStack;
            }
            return this.alternatives.get(this.lastHoveredIndex).getItemStack();
        }

        private String formatDropChance() {
            double chanceIn;
            if (this.chance == null) {
                return "";
            }
            if (!this.chance.endsWith("%")) {
                return this.chance;
            }
            String chanceText = this.chance.substring(0, this.chance.length() - 1);
            try {
                chanceIn = 100.0 / Double.parseDouble(chanceText);
            }
            catch (NumberFormatException e2) {
                return this.chance;
            }
            String format2 = StringUtils.formatNumber(chanceIn);
            return "1/" + format2 + " (" + this.chance + ")";
        }
    }
}

